/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.function.Function;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.InstantColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.TextColumn;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;

public abstract class AbstractColumn<T>
implements Column<T> {
    public static final int DEFAULT_ARRAY_SIZE = 128;
    private String name;
    private final ColumnType type;

    public AbstractColumn(ColumnType type, String name) {
        this.type = type;
        this.setName(name);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Column<T> setName(String name) {
        this.name = name.trim();
        return this;
    }

    @Override
    public ColumnType type() {
        return this.type;
    }

    @Override
    public abstract Column<T> emptyCopy();

    public String toString() {
        return this.type().getPrinterFriendlyName() + " column: " + this.name();
    }

    @Override
    public StringColumn asStringColumn() {
        StringColumn sc = StringColumn.create(this.name() + " strings");
        for (Object value : this) {
            sc.append(String.valueOf(value));
        }
        return sc;
    }

    public BooleanColumn mapToBooleanColumn(String name, Function<? super T, ? extends Boolean> function) {
        BooleanColumn newColumn = BooleanColumn.create(name, this.size());
        this.mapInto(function, newColumn);
        return newColumn;
    }

    public DateColumn mapToDateColumn(String name, Function<? super T, ? extends LocalDate> function) {
        DateColumn newColumn = DateColumn.create(name, this.size());
        this.mapInto(function, newColumn);
        return newColumn;
    }

    public DateTimeColumn mapToDateTimeColumn(String name, Function<? super T, ? extends LocalDateTime> function) {
        DateTimeColumn newColumn = DateTimeColumn.create(name, this.size());
        this.mapInto(function, newColumn);
        return newColumn;
    }

    public DoubleColumn mapToDoubleColumn(String name, Function<? super T, ? extends Double> function) {
        DoubleColumn newColumn = DoubleColumn.create(name, this.size());
        this.mapInto(function, newColumn);
        return newColumn;
    }

    public FloatColumn mapToFloatColumn(String name, Function<? super T, ? extends Float> function) {
        FloatColumn newColumn = FloatColumn.create(name, this.size());
        this.mapInto(function, newColumn);
        return newColumn;
    }

    public InstantColumn mapToInstantColumn(String name, Function<? super T, ? extends Instant> function) {
        InstantColumn newColumn = InstantColumn.create(name, this.size());
        this.mapInto(function, newColumn);
        return newColumn;
    }

    public IntColumn mapToIntColumn(String name, Function<? super T, ? extends Integer> function) {
        IntColumn newColumn = IntColumn.create(name, this.size());
        this.mapInto(function, newColumn);
        return newColumn;
    }

    public LongColumn mapToLongColumn(String name, Function<? super T, ? extends Long> function) {
        LongColumn newColumn = LongColumn.create(name, this.size());
        this.mapInto(function, newColumn);
        return newColumn;
    }

    public ShortColumn mapToShortColumn(String name, Function<? super T, ? extends Short> function) {
        ShortColumn newColumn = ShortColumn.create(name, this.size());
        this.mapInto(function, newColumn);
        return newColumn;
    }

    public StringColumn mapToStringColumn(String name, Function<? super T, ? extends String> function) {
        StringColumn newColumn = StringColumn.create(name, this.size());
        this.mapInto(function, newColumn);
        return newColumn;
    }

    public TextColumn mapToTextColumn(String name, Function<? super T, ? extends String> function) {
        TextColumn newColumn = TextColumn.create(name, this.size());
        this.mapInto(function, newColumn);
        return newColumn;
    }

    public TimeColumn mapToTimeColumn(String name, Function<? super T, ? extends LocalTime> function) {
        TimeColumn newColumn = TimeColumn.create(name, this.size());
        this.mapInto(function, newColumn);
        return newColumn;
    }
}

