/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.fixed;

import com.univocity.parsers.fixed.FixedWidthFields;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.io.ReadOptions;
import tech.tablesaw.io.Source;

public class FixedWidthReadOptions
extends ReadOptions {
    private final ColumnType[] columnTypes;
    private final FixedWidthFields columnSpecs;
    private final String lineEnding;
    private final char padding;
    private final char lookupWildcard;
    private final boolean skipTrailingCharsUntilNewline;
    private final boolean recordEndsOnNewline;
    private final boolean skipInvalidRows;
    private final Integer maxNumberOfColumns;

    private FixedWidthReadOptions(Builder builder) {
        super(builder);
        this.columnTypes = builder.columnTypes;
        this.columnSpecs = builder.columnSpecs;
        this.padding = builder.padding;
        this.lookupWildcard = builder.lookupWildcard;
        this.skipTrailingCharsUntilNewline = builder.skipTrailingCharsUntilNewline;
        this.recordEndsOnNewline = builder.recordEndsOnNewline;
        this.skipInvalidRows = builder.skipInvalidRows;
        this.lineEnding = builder.lineEnding;
        this.maxNumberOfColumns = builder.maxNumberOfColumns;
    }

    public static Builder builder(Source source) {
        return new Builder(source);
    }

    public static Builder builder(File file) {
        return new Builder(file).tableName(file.getName());
    }

    public static Builder builder(String fileName) {
        return new Builder(new File(fileName));
    }

    public static Builder builder(InputStream stream) {
        return new Builder(stream);
    }

    public static Builder builder(Reader reader) {
        return new Builder(reader);
    }

    public ColumnType[] columnTypes() {
        return this.columnTypes;
    }

    public FixedWidthFields columnSpecs() {
        return this.columnSpecs;
    }

    public String lineEnding() {
        return this.lineEnding;
    }

    public char padding() {
        return this.padding;
    }

    public char lookupWildcard() {
        return this.lookupWildcard;
    }

    public boolean skipTrailingCharsUntilNewline() {
        return this.skipTrailingCharsUntilNewline;
    }

    public boolean recordEndsOnNewline() {
        return this.recordEndsOnNewline;
    }

    public boolean skipInvalidRows() {
        return this.skipInvalidRows;
    }

    public Integer maxNumberOfColumns() {
        return this.maxNumberOfColumns;
    }

    public static class Builder
    extends ReadOptions.Builder {
        protected FixedWidthFields columnSpecs;
        protected String lineEnding;
        protected char padding = (char)32;
        protected char lookupWildcard = (char)63;
        protected boolean skipTrailingCharsUntilNewline = false;
        protected boolean recordEndsOnNewline = false;
        protected boolean skipInvalidRows = false;
        protected ColumnType[] columnTypes;
        protected Integer maxNumberOfColumns = 10000;

        protected Builder(Source source) {
            super(source);
        }

        protected Builder(URL url) throws IOException {
            super(url);
        }

        protected Builder(File file) {
            super(file);
        }

        protected Builder(Reader reader) {
            super(reader);
        }

        protected Builder(InputStream stream) {
            super(stream);
        }

        public Builder columnSpecs(FixedWidthFields columnSpecs) {
            this.columnSpecs = columnSpecs;
            return this;
        }

        @Override
        public Builder maxCharsPerColumn(int maxCharsPerColumn) {
            super.maxCharsPerColumn(maxCharsPerColumn);
            return this;
        }

        public Builder lineEnding(String lineEnding) {
            this.lineEnding = lineEnding;
            return this;
        }

        public Builder systemLineEnding() {
            return this.lineEnding(System.lineSeparator());
        }

        public Builder padding(char padding) {
            this.padding = padding;
            return this;
        }

        public Builder lookupWildcard(char lookupWildcard) {
            this.lookupWildcard = lookupWildcard;
            return this;
        }

        public Builder skipTrailingCharsUntilNewline(boolean skipTrailingCharsUntilNewline) {
            this.skipTrailingCharsUntilNewline = skipTrailingCharsUntilNewline;
            return this;
        }

        public Builder recordEndsOnNewline(boolean recordEndsOnNewline) {
            this.recordEndsOnNewline = recordEndsOnNewline;
            return this;
        }

        public Builder skipInvalidRows(boolean skipInvalidRows) {
            this.skipInvalidRows = skipInvalidRows;
            return this;
        }

        public Builder columnTypes(ColumnType[] columnTypes) {
            this.columnTypes = columnTypes;
            return this;
        }

        public Builder maxNumberOfColumns(Integer maxNumberOfColumns) {
            this.maxNumberOfColumns = maxNumberOfColumns;
            return this;
        }

        @Override
        public FixedWidthReadOptions build() {
            return new FixedWidthReadOptions(this);
        }

        @Override
        public Builder header(boolean header) {
            super.header(header);
            return this;
        }

        @Override
        public Builder tableName(String tableName) {
            super.tableName(tableName);
            return this;
        }

        @Override
        public Builder sample(boolean sample) {
            super.sample(sample);
            return this;
        }

        @Override
        @Deprecated
        public Builder dateFormat(String dateFormat) {
            super.dateFormat(dateFormat);
            return this;
        }

        @Override
        @Deprecated
        public Builder timeFormat(String timeFormat) {
            super.timeFormat(timeFormat);
            return this;
        }

        @Override
        @Deprecated
        public Builder dateTimeFormat(String dateTimeFormat) {
            super.dateTimeFormat(dateTimeFormat);
            return this;
        }

        @Override
        public Builder dateFormat(DateTimeFormatter dateFormat) {
            super.dateFormat(dateFormat);
            return this;
        }

        @Override
        public Builder timeFormat(DateTimeFormatter timeFormat) {
            super.timeFormat(timeFormat);
            return this;
        }

        @Override
        public Builder dateTimeFormat(DateTimeFormatter dateTimeFormat) {
            super.dateTimeFormat(dateTimeFormat);
            return this;
        }

        @Override
        public Builder locale(Locale locale) {
            super.locale(locale);
            return this;
        }

        @Override
        public Builder missingValueIndicator(String missingValueIndicator) {
            super.missingValueIndicator(missingValueIndicator);
            return this;
        }

        @Override
        public Builder minimizeColumnSizes() {
            super.minimizeColumnSizes();
            return this;
        }
    }
}

