/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.analytic;

import java.util.ArrayDeque;
import java.util.function.Function;
import tech.tablesaw.analytic.AggregateFunction;
import tech.tablesaw.analytic.FunctionMetaData;
import tech.tablesaw.analytic.WindowFrame;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.columns.numbers.DoubleColumnType;

enum AggregateFunctions implements FunctionMetaData
{
    SUM(new Sum<T>(), ColumnType.DOUBLE, AggregateFunctions::isNumericColumn),
    MAX(new Max<T>(), ColumnType.DOUBLE, AggregateFunctions::isNumericColumn),
    MIN(new Min<T>(), ColumnType.DOUBLE, AggregateFunctions::isNumericColumn),
    MEAN(new Mean<T>(), ColumnType.DOUBLE, AggregateFunctions::isNumericColumn),
    COUNT(new Count<T>(), ColumnType.INTEGER, t -> true);

    private final WindowDependentAggregateFunction<?> implementation;
    private final ColumnType outputColumnType;
    private final Function<ColumnType, Boolean> isCompatibleColumnTestFunc;

    private AggregateFunctions(WindowDependentAggregateFunction<?> implementation, ColumnType outputColumnType, Function<ColumnType, Boolean> isCompatibleColumnTestFunc) {
        this.implementation = implementation;
        this.outputColumnType = outputColumnType;
        this.isCompatibleColumnTestFunc = isCompatibleColumnTestFunc;
    }

    AggregateFunction<?, ? extends Number> getImplementation(WindowFrame.WindowGrowthType growthType) {
        return this.implementation.functionFor(growthType);
    }

    @Override
    public String functionName() {
        return this.name();
    }

    @Override
    public ColumnType returnType() {
        return this.outputColumnType;
    }

    @Override
    public boolean isCompatibleColumn(ColumnType type) {
        return this.isCompatibleColumnTestFunc.apply(type);
    }

    private static boolean isNumericColumn(ColumnType type) {
        return type.equals(ColumnType.DOUBLE) || type.equals(ColumnType.FLOAT) || type.equals(ColumnType.INTEGER) || type.equals(ColumnType.SHORT) || type.equals(ColumnType.LONG);
    }

    static class Count<T>
    extends WindowDependentAggregateFunction<T> {
        Count() {
        }

        @Override
        WindowDependentAggregateFunction.AppendAggregateFunction<T, Integer> functionForAppendWindows() {
            return new WindowDependentAggregateFunction.AppendAggregateFunction<T, Integer>(){
                private int count = 0;

                @Override
                public Integer getValue() {
                    return this.count;
                }

                @Override
                public void addRightMostMissing() {
                }

                @Override
                public void addRightMost(T newValue) {
                    ++this.count;
                }
            };
        }

        @Override
        AggregateFunction<T, Integer> functionForSlidingWindows() {
            return new AggregateFunction<T, Integer>(){
                private final ArrayDeque<Boolean> queue = new ArrayDeque();
                private int missingCount = 0;

                @Override
                public void removeLeftMost() {
                    Boolean removedMissingValue = this.queue.remove();
                    if (removedMissingValue.booleanValue()) {
                        --this.missingCount;
                    }
                }

                @Override
                public void addRightMost(T newValue) {
                    this.queue.add(false);
                }

                @Override
                public void addRightMostMissing() {
                    this.queue.add(true);
                    ++this.missingCount;
                }

                @Override
                public Integer getValue() {
                    return this.queue.size() - this.missingCount;
                }
            };
        }
    }

    static class Mean<T extends Number>
    extends WindowDependentAggregateFunction<T> {
        Mean() {
        }

        @Override
        WindowDependentAggregateFunction.AppendAggregateFunction<T, Double> functionForAppendWindows() {
            return new WindowDependentAggregateFunction.AppendAggregateFunction<T, Double>(){
                private double sum = DoubleColumnType.missingValueIndicator();
                private double count = 0.0;

                @Override
                public Double getValue() {
                    if (this.count == 0.0) {
                        return DoubleColumnType.missingValueIndicator();
                    }
                    return this.sum / this.count;
                }

                @Override
                public void addRightMostMissing() {
                }

                @Override
                public void addRightMost(T newValue) {
                    if (DoubleColumnType.valueIsMissing(this.sum)) {
                        this.sum = 0.0;
                    }
                    this.sum += ((Number)newValue).doubleValue();
                    this.count += 1.0;
                }
            };
        }

        @Override
        AggregateFunction<T, Double> functionForSlidingWindows() {
            return new AggregateFunction<T, Double>(){
                private final ArrayDeque<Double> queue = new ArrayDeque();
                private Double sum = 0.0;
                private int missingCount = 0;

                @Override
                public void removeLeftMost() {
                    Double removed = this.queue.remove();
                    if (DoubleColumnType.valueIsMissing(removed)) {
                        --this.missingCount;
                    } else {
                        2 var2_2 = this;
                        var2_2.sum = var2_2.sum - removed;
                    }
                }

                @Override
                public void addRightMost(T newValue) {
                    Double doubleValue = ((Number)newValue).doubleValue();
                    2 var3_3 = this;
                    var3_3.sum = var3_3.sum + doubleValue;
                    this.queue.add(doubleValue);
                }

                @Override
                public void addRightMostMissing() {
                    this.queue.add(DoubleColumnType.missingValueIndicator());
                    ++this.missingCount;
                }

                @Override
                public Double getValue() {
                    if (this.queue.size() - this.missingCount == 0) {
                        return DoubleColumnType.missingValueIndicator();
                    }
                    return this.sum / (double)(this.queue.size() - this.missingCount);
                }
            };
        }
    }

    static class Min<T extends Number>
    extends WindowDependentAggregateFunction<T> {
        Min() {
        }

        @Override
        WindowDependentAggregateFunction.AppendAggregateFunction<T, Double> functionForAppendWindows() {
            return new WindowDependentAggregateFunction.AppendAggregateFunction<T, Double>(){
                private Double min = DoubleColumnType.missingValueIndicator();

                @Override
                public void addRightMost(T newValue) {
                    if (DoubleColumnType.valueIsMissing(this.min)) {
                        this.min = ((Number)newValue).doubleValue();
                        return;
                    }
                    this.min = Math.min(this.min, ((Number)newValue).doubleValue());
                }

                @Override
                public void addRightMostMissing() {
                }

                @Override
                public Double getValue() {
                    return this.min;
                }
            };
        }

        @Override
        AggregateFunction<T, Double> functionForSlidingWindows() {
            return new AggregateFunction<T, Double>(){
                private final ArrayDeque<Double> queue = new ArrayDeque();

                @Override
                public void removeLeftMost() {
                    this.queue.remove();
                }

                @Override
                public void addRightMost(T newValue) {
                    this.queue.add(((Number)newValue).doubleValue());
                }

                @Override
                public void addRightMostMissing() {
                    this.queue.add(DoubleColumnType.missingValueIndicator());
                }

                @Override
                public Double getValue() {
                    return this.queue.stream().filter(d -> !DoubleColumnType.valueIsMissing(d)).mapToDouble(Number::doubleValue).min().orElse(DoubleColumnType.missingValueIndicator());
                }
            };
        }
    }

    static class Max<T extends Number>
    extends WindowDependentAggregateFunction<T> {
        Max() {
        }

        @Override
        WindowDependentAggregateFunction.AppendAggregateFunction<T, Double> functionForAppendWindows() {
            return new WindowDependentAggregateFunction.AppendAggregateFunction<T, Double>(){
                private Double max = DoubleColumnType.missingValueIndicator();

                @Override
                public void addRightMost(T newValue) {
                    if (DoubleColumnType.valueIsMissing(this.max)) {
                        this.max = ((Number)newValue).doubleValue();
                        return;
                    }
                    this.max = Math.max(this.max, ((Number)newValue).doubleValue());
                }

                @Override
                public void addRightMostMissing() {
                }

                @Override
                public Double getValue() {
                    return this.max;
                }
            };
        }

        @Override
        AggregateFunction<T, Double> functionForSlidingWindows() {
            return new AggregateFunction<T, Double>(){
                private final ArrayDeque<Double> queue = new ArrayDeque();

                @Override
                public void removeLeftMost() {
                    this.queue.remove();
                }

                @Override
                public void addRightMost(T newValue) {
                    this.queue.add(((Number)newValue).doubleValue());
                }

                @Override
                public void addRightMostMissing() {
                    this.queue.add(DoubleColumnType.missingValueIndicator());
                }

                @Override
                public Double getValue() {
                    return this.queue.stream().filter(d -> !DoubleColumnType.valueIsMissing(d)).mapToDouble(Number::doubleValue).max().orElse(DoubleColumnType.missingValueIndicator());
                }
            };
        }
    }

    static class Sum<T extends Number>
    extends WindowDependentAggregateFunction<T> {
        Sum() {
        }

        @Override
        WindowDependentAggregateFunction.AppendAggregateFunction<T, Double> functionForAppendWindows() {
            return new WindowDependentAggregateFunction.AppendAggregateFunction<T, Double>(){
                private double sum = DoubleColumnType.missingValueIndicator();

                @Override
                public Double getValue() {
                    return this.sum;
                }

                @Override
                public void addRightMostMissing() {
                }

                @Override
                public void addRightMost(T newValue) {
                    if (DoubleColumnType.valueIsMissing(this.sum)) {
                        this.sum = 0.0;
                    }
                    this.sum += ((Number)newValue).doubleValue();
                }
            };
        }

        @Override
        AggregateFunction<T, Double> functionForSlidingWindows() {
            return new AggregateFunction<T, Double>(){
                private final ArrayDeque<Double> queue = new ArrayDeque();
                private Double sum = 0.0;
                private int missingCount = 0;

                @Override
                public void removeLeftMost() {
                    Double removed = this.queue.remove();
                    if (DoubleColumnType.valueIsMissing(removed)) {
                        --this.missingCount;
                    } else {
                        2 var2_2 = this;
                        var2_2.sum = var2_2.sum - removed;
                    }
                }

                @Override
                public void addRightMost(T newValue) {
                    Double doubleValue = ((Number)newValue).doubleValue();
                    2 var3_3 = this;
                    var3_3.sum = var3_3.sum + doubleValue;
                    this.queue.add(doubleValue);
                }

                @Override
                public void addRightMostMissing() {
                    this.queue.add(DoubleColumnType.missingValueIndicator());
                    ++this.missingCount;
                }

                @Override
                public Double getValue() {
                    if (this.queue.isEmpty() || this.missingCount == this.queue.size()) {
                        return DoubleColumnType.missingValueIndicator();
                    }
                    return this.sum;
                }
            };
        }
    }

    private static abstract class WindowDependentAggregateFunction<T> {
        private WindowDependentAggregateFunction() {
        }

        abstract AppendAggregateFunction<T, ? extends Number> functionForAppendWindows();

        abstract AggregateFunction<T, ? extends Number> functionForSlidingWindows();

        AggregateFunction<T, ? extends Number> functionFor(WindowFrame.WindowGrowthType growthType) {
            switch (growthType) {
                case FIXED: 
                case FIXED_LEFT: 
                case FIXED_RIGHT: {
                    return this.functionForAppendWindows();
                }
                case SLIDING: {
                    return this.functionForSlidingWindows();
                }
            }
            throw new IllegalArgumentException("Unexpected growthType: " + (Object)((Object)growthType));
        }

        static abstract class AppendAggregateFunction<T, R>
        implements AggregateFunction<T, R> {
            AppendAggregateFunction() {
            }

            @Override
            public final void removeLeftMost() {
                throw new UnsupportedOperationException("Implementers of append aggregate functions should never call removeLeftMost");
            }
        }
    }
}

