/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.upconversion;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import uk.ac.ed.ph.snuggletex.SnuggleLogicException;
import uk.ac.ed.ph.snuggletex.SnuggleRuntimeException;
import uk.ac.ed.ph.snuggletex.internal.util.XMLUtilities;
import uk.ac.ed.ph.snuggletex.upconversion.UpConversionOptions;
import uk.ac.ed.ph.snuggletex.upconversion.UpConversionUtilities;
import uk.ac.ed.ph.snuggletex.utilities.SaxonTransformerFactoryChooser;
import uk.ac.ed.ph.snuggletex.utilities.SimpleStylesheetCache;
import uk.ac.ed.ph.snuggletex.utilities.StylesheetCache;
import uk.ac.ed.ph.snuggletex.utilities.StylesheetManager;
import uk.ac.ed.ph.snuggletex.utilities.TransformerFactoryChooser;

public class MathMLUpConverter {
    public static final String SNUGGLETEX_ANNOTATION_NAME = "SnuggleTeX";
    public static final String LATEX_ANNOTATION_NAME = "LaTeX";
    public static final String CONTENT_MATHML_ANNOTATION_NAME = "MathML-Content";
    public static final String CONTENT_FAILURES_ANNOTATION_NAME = "MathML-Content-upconversion-failures";
    public static final String MAXIMA_ANNOTATION_NAME = "Maxima";
    public static final String MAXIMA_FAILURES_ANNOTATION_NAME = "Maxima-upconversion-failures";
    public static final String ASCIIMATH_INPUT_ANNOTATION_NAME = "ASCIIMathInput";
    private static final String UPCONVERTER_BASE_LOCATION = "classpath:/uk/ac/ed/ph/snuggletex/upconversion";
    private static final String ASCIIMATH_FIXER_XSL_LOCATION = "classpath:/uk/ac/ed/ph/snuggletex/upconversion/asciimathml-fixer.xsl";
    private static final String UPCONVERTER_XSL_LOCATION = "classpath:/uk/ac/ed/ph/snuggletex/upconversion/snuggletex-upconverter.xsl";
    private final StylesheetManager stylesheetManager;

    public MathMLUpConverter() {
        this((TransformerFactoryChooser)SaxonTransformerFactoryChooser.getInstance(), (StylesheetCache)new SimpleStylesheetCache());
    }

    public MathMLUpConverter(StylesheetCache stylesheetCache) {
        this((TransformerFactoryChooser)SaxonTransformerFactoryChooser.getInstance(), stylesheetCache);
    }

    public MathMLUpConverter(TransformerFactoryChooser transformerFactoryChooser, StylesheetCache stylesheetCache) {
        this(new StylesheetManager(transformerFactoryChooser, stylesheetCache));
    }

    public MathMLUpConverter(StylesheetManager stylesheetManager) {
        this.stylesheetManager = stylesheetManager;
    }

    public Document upConvertSnuggleTeXMathML(Document document, UpConversionOptions upConversionOptions) {
        Document resultDocument = XMLUtilities.createNSAwareDocumentBuilder().newDocument();
        try {
            Templates upconverterStylesheet = this.stylesheetManager.getStylesheet(UPCONVERTER_XSL_LOCATION, true);
            Transformer upconverter = upconverterStylesheet.newTransformer();
            upconverter.setParameter("{http://www.ph.ed.ac.uk/snuggletex}global-upconversion-options", this.createUpConversionOptionsElement(upConversionOptions));
            upconverter.transform(new DOMSource(document), new DOMResult(resultDocument));
        }
        catch (TransformerConfigurationException e) {
            throw new SnuggleRuntimeException("Could not instantiate Transformer from Templates", (Throwable)e);
        }
        catch (TransformerException e) {
            throw new SnuggleLogicException("Up-conversion XSLT transform failed", (Throwable)e);
        }
        return resultDocument;
    }

    private Element createUpConversionOptionsElement(UpConversionOptions upConversionOptions) {
        Document document = XMLUtilities.createNSAwareDocumentBuilder().newDocument();
        Element root = (Element)document.appendChild(document.createElementNS("http://www.ph.ed.ac.uk/snuggletex", "root"));
        UpConversionUtilities.appendUpConversionOptionsElement(document, root, upConversionOptions, true);
        return (Element)root.getFirstChild();
    }

    public Document upConvertASCIIMathML(Document asciiMathMLDocument, UpConversionOptions upConversionOptions) {
        Document fixedDocument = XMLUtilities.createNSAwareDocumentBuilder().newDocument();
        try {
            Templates fixerStylesheet = this.stylesheetManager.getStylesheet(ASCIIMATH_FIXER_XSL_LOCATION, true);
            fixerStylesheet.newTransformer().transform(new DOMSource(asciiMathMLDocument), new DOMResult(fixedDocument));
        }
        catch (TransformerConfigurationException e) {
            throw new SnuggleRuntimeException("Could not instantiate Transformer from Templates", (Throwable)e);
        }
        catch (TransformerException e) {
            throw new SnuggleLogicException("ASCIIMathML fix-up XSLT transform failed", (Throwable)e);
        }
        return this.upConvertSnuggleTeXMathML(fixedDocument, upConversionOptions);
    }

    public Document upConvertASCIIMathML(String rawASCIIMathML, UpConversionOptions upConversionOptions) {
        Document inputDocument;
        try {
            inputDocument = XMLUtilities.createNSAwareDocumentBuilder().parse(new InputSource(new StringReader(rawASCIIMathML)));
        }
        catch (SAXException e) {
            throw new SnuggleRuntimeException("Could not parse XML generated by ASCIIMathML: " + rawASCIIMathML, (Throwable)e);
        }
        catch (IOException e) {
            throw new SnuggleRuntimeException("Unexpected Exception reading ASCIIMathML XML String data", (Throwable)e);
        }
        return this.upConvertASCIIMathML(inputDocument, upConversionOptions);
    }
}

