/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player;

import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_meta_t;
import uk.co.caprica.vlcj.player.MediaMeta;
import uk.co.caprica.vlcj.player.MediaMetaData;
import uk.co.caprica.vlcj.player.NativeString;
import uk.co.caprica.vlcj.version.Version;

class DefaultMediaMeta
implements MediaMeta {
    private final Logger logger = LoggerFactory.getLogger(DefaultMediaMeta.class);
    private static final Version VERSION_220 = new Version("2.2.0");
    private static final Version VERSION_300 = new Version("3.0.0");
    private final AtomicBoolean released = new AtomicBoolean();
    private final LibVlc libvlc;
    private final libvlc_media_t media;
    private final Version actualVersion;
    private BufferedImage artwork;

    DefaultMediaMeta(LibVlc libvlc, libvlc_media_t media) {
        this.libvlc = libvlc;
        this.media = media;
        this.actualVersion = new Version(libvlc.libvlc_get_version());
        libvlc.libvlc_media_retain(media);
    }

    @Override
    public final void parse() {
        this.logger.debug("parse()");
        this.libvlc.libvlc_media_parse(this.media);
    }

    @Override
    public final String getTitle() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Title);
    }

    @Override
    public final void setTitle(String title) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Title, title);
    }

    @Override
    public final String getArtist() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Artist);
    }

    @Override
    public final void setArtist(String artist) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Artist, artist);
    }

    @Override
    public final String getGenre() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Genre);
    }

    @Override
    public final void setGenre(String genre) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Genre, genre);
    }

    @Override
    public final String getCopyright() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Copyright);
    }

    @Override
    public final void setCopyright(String copyright) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Copyright, copyright);
    }

    @Override
    public final String getAlbum() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Album);
    }

    @Override
    public final void setAlbum(String album) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Album, album);
    }

    @Override
    public final String getTrackNumber() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_TrackNumber);
    }

    @Override
    public final void setTrackNumber(String trackNumber) {
        this.setMeta(libvlc_meta_t.libvlc_meta_TrackNumber, trackNumber);
    }

    @Override
    public final String getDescription() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Description);
    }

    @Override
    public final void setDescription(String description) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Description, description);
    }

    @Override
    public final String getRating() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Rating);
    }

    @Override
    public final void setRating(String rating) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Rating, rating);
    }

    @Override
    public final String getDate() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Date);
    }

    @Override
    public final void setDate(String date) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Date, date);
    }

    @Override
    public final String getSetting() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Setting);
    }

    @Override
    public final void setSetting(String setting) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Setting, setting);
    }

    @Override
    public final String getUrl() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_URL);
    }

    @Override
    public final void setUrl(String url) {
        this.setMeta(libvlc_meta_t.libvlc_meta_URL, url);
    }

    @Override
    public final String getLanguage() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Language);
    }

    @Override
    public final void setLanguage(String language) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Language, language);
    }

    @Override
    public final String getNowPlaying() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_NowPlaying);
    }

    @Override
    public final void setNowPlaying(String nowPlaying) {
        this.setMeta(libvlc_meta_t.libvlc_meta_NowPlaying, nowPlaying);
    }

    @Override
    public final String getPublisher() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Publisher);
    }

    @Override
    public final void setPublisher(String publisher) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Publisher, publisher);
    }

    @Override
    public final String getEncodedBy() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_EncodedBy);
    }

    @Override
    public final void setEncodedBy(String encodedBy) {
        this.setMeta(libvlc_meta_t.libvlc_meta_EncodedBy, encodedBy);
    }

    @Override
    public final String getArtworkUrl() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_ArtworkURL);
    }

    @Override
    public final void setArtworkUrl(String artworkUrl) {
        this.setMeta(libvlc_meta_t.libvlc_meta_ArtworkURL, artworkUrl);
    }

    @Override
    public final String getTrackId() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_TrackID);
    }

    @Override
    public final void setTrackId(String trackId) {
        this.setMeta(libvlc_meta_t.libvlc_meta_TrackID, trackId);
    }

    @Override
    public final String getTrackTotal() {
        this.checkVersion(VERSION_220);
        return this.getMeta(libvlc_meta_t.libvlc_meta_TrackTotal);
    }

    @Override
    public final void setTrackTotal(String trackTotal) {
        this.checkVersion(VERSION_220);
        this.setMeta(libvlc_meta_t.libvlc_meta_TrackTotal, trackTotal);
    }

    @Override
    public final String getDirector() {
        this.checkVersion(VERSION_220);
        return this.getMeta(libvlc_meta_t.libvlc_meta_Director);
    }

    @Override
    public final void setDirector(String director) {
        this.checkVersion(VERSION_220);
        this.setMeta(libvlc_meta_t.libvlc_meta_Director, director);
    }

    @Override
    public final String getSeason() {
        this.checkVersion(VERSION_220);
        return this.getMeta(libvlc_meta_t.libvlc_meta_Season);
    }

    @Override
    public final void setSeason(String season) {
        this.checkVersion(VERSION_220);
        this.setMeta(libvlc_meta_t.libvlc_meta_Season, season);
    }

    @Override
    public final String getEpisode() {
        this.checkVersion(VERSION_220);
        return this.getMeta(libvlc_meta_t.libvlc_meta_Episode);
    }

    @Override
    public final void setEpisode(String episode) {
        this.checkVersion(VERSION_220);
        this.setMeta(libvlc_meta_t.libvlc_meta_Episode, episode);
    }

    @Override
    public final String getShowName() {
        this.checkVersion(VERSION_220);
        return this.getMeta(libvlc_meta_t.libvlc_meta_ShowName);
    }

    @Override
    public final void setShowName(String showName) {
        this.checkVersion(VERSION_220);
        this.setMeta(libvlc_meta_t.libvlc_meta_ShowName, showName);
    }

    @Override
    public final String getActors() {
        this.checkVersion(VERSION_220);
        return this.getMeta(libvlc_meta_t.libvlc_meta_Actors);
    }

    @Override
    public final void setActors(String actors) {
        this.checkVersion(VERSION_220);
        this.setMeta(libvlc_meta_t.libvlc_meta_Actors, actors);
    }

    @Override
    public String getAlbumArtist() {
        this.checkVersion(VERSION_300);
        return this.getMeta(libvlc_meta_t.libvlc_meta_AlbumArtist);
    }

    @Override
    public void setAlbumArtist(String albumArtist) {
        this.checkVersion(VERSION_300);
        this.setMeta(libvlc_meta_t.libvlc_meta_AlbumArtist, albumArtist);
    }

    @Override
    public String getDiscNumber() {
        this.checkVersion(VERSION_300);
        return this.getMeta(libvlc_meta_t.libvlc_meta_DiscNumber);
    }

    @Override
    public void setDiscNumber(String discNumber) {
        this.checkVersion(VERSION_300);
        this.setMeta(libvlc_meta_t.libvlc_meta_DiscNumber, discNumber);
    }

    @Override
    public final BufferedImage getArtwork() {
        String artworkUrl;
        this.logger.debug("getArtwork()");
        if (this.artwork == null && (artworkUrl = this.getArtworkUrl()) != null && artworkUrl.length() > 0) {
            try {
                URL url = new URL(artworkUrl);
                this.logger.debug("url={}", (Object)url);
                this.artwork = ImageIO.read(url);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load artwork", e);
            }
        }
        return this.artwork;
    }

    @Override
    public final long getLength() {
        return this.libvlc.libvlc_media_get_duration(this.media);
    }

    @Override
    public final void save() {
        this.logger.debug("save()");
        this.libvlc.libvlc_media_save_meta(this.media);
    }

    @Override
    public final void release() {
        this.logger.debug("release()");
        if (this.released.compareAndSet(false, true)) {
            this.libvlc.libvlc_media_release(this.media);
        }
    }

    @Override
    public MediaMetaData asMediaMetaData() {
        MediaMetaData result = new MediaMetaData();
        result.setTitle(this.getTitle());
        result.setArtist(this.getArtist());
        result.setGenre(this.getGenre());
        result.setCopyright(this.getCopyright());
        result.setAlbum(this.getAlbum());
        result.setTrackNumber(this.getTrackNumber());
        result.setDescription(this.getDescription());
        result.setRating(this.getRating());
        result.setDate(this.getDate());
        result.setSetting(this.getSetting());
        result.setUrl(this.getUrl());
        result.setLanguage(this.getLanguage());
        result.setNowPlaying(this.getNowPlaying());
        result.setPublisher(this.getPublisher());
        result.setEncodedBy(this.getEncodedBy());
        result.setArtworkUrl(this.getArtworkUrl());
        result.setTrackId(this.getTrackId());
        if (this.actualVersion.atLeast(VERSION_220)) {
            result.setTrackTotal(this.getTrackTotal());
            result.setDirector(this.getDirector());
            result.setSeason(this.getSeason());
            result.setEpisode(this.getEpisode());
            result.setShowName(this.getShowName());
            result.setActors(this.getActors());
        }
        if (this.actualVersion.atLeast(VERSION_300)) {
            result.setAlbumArtist(this.getAlbumArtist());
            result.setDiscNumber(this.getDiscNumber());
        }
        return result;
    }

    protected void finalize() throws Throwable {
        this.logger.debug("finalize()");
        this.logger.debug("Meta data has been garbage collected");
        super.finalize();
    }

    private String getMeta(libvlc_meta_t metaType) {
        this.logger.trace("getMeta(metaType={},media={})", (Object)metaType, (Object)this.media);
        return NativeString.getNativeString(this.libvlc, this.libvlc.libvlc_media_get_meta(this.media, metaType.intValue()));
    }

    private void setMeta(libvlc_meta_t metaType, String value) {
        this.logger.trace("setMeta(metaType={},media={},value={})", new Object[]{metaType, this.media, value});
        this.libvlc.libvlc_media_set_meta(this.media, metaType.intValue(), value);
    }

    private void checkVersion(Version checkVersion) {
        if (!this.actualVersion.atLeast(checkVersion)) {
            throw new RuntimeException("Requires at least VLC version " + checkVersion);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append("title=").append(this.getTitle()).append(',');
        sb.append("artist=").append(this.getArtist()).append(',');
        sb.append("genre=").append(this.getGenre()).append(',');
        sb.append("copyright=").append(this.getCopyright()).append(',');
        sb.append("album=").append(this.getAlbum()).append(',');
        sb.append("trackNumber=").append(this.getTrackNumber()).append(',');
        sb.append("description=").append(this.getDescription()).append(',');
        sb.append("rating=").append(this.getRating()).append(',');
        sb.append("date=").append(this.getDate()).append(',');
        sb.append("setting=").append(this.getSetting()).append(',');
        sb.append("url=").append(this.getUrl()).append(',');
        sb.append("language=").append(this.getLanguage()).append(',');
        sb.append("nowPlaying=").append(this.getNowPlaying()).append(',');
        sb.append("publisher=").append(this.getPublisher()).append(',');
        sb.append("encodedBy=").append(this.getEncodedBy()).append(',');
        sb.append("artworkUrl=").append(this.getArtworkUrl()).append(',');
        sb.append("trackId=").append(this.getTrackId()).append(',');
        if (this.actualVersion.atLeast(VERSION_220)) {
            sb.append("trackTotal=").append(this.getTrackTotal()).append(',');
            sb.append("director=").append(this.getDirector()).append(',');
            sb.append("season=").append(this.getSeason()).append(',');
            sb.append("episode=").append(this.getEpisode()).append(',');
            sb.append("showName=").append(this.getShowName()).append(',');
            sb.append("actors=").append(this.getActors()).append(',');
        }
        if (this.actualVersion.atLeast(VERSION_300)) {
            sb.append("albumArtist=").append(this.getAlbumArtist()).append(',');
            sb.append("discNumber=").append(this.getDiscNumber()).append(',');
        }
        sb.append("length=").append(this.getLength()).append(']');
        return sb.toString();
    }
}

