/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.embedded.videosurface;

import com.sun.jna.Native;
import java.awt.Canvas;
import java.awt.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.embedded.videosurface.VideoSurface;
import uk.co.caprica.vlcj.player.embedded.videosurface.VideoSurfaceAdapter;

public class CanvasVideoSurface
extends VideoSurface {
    private final Logger logger = LoggerFactory.getLogger(CanvasVideoSurface.class);
    private static final long serialVersionUID = 1L;
    private final Canvas canvas;

    public CanvasVideoSurface(Canvas canvas, VideoSurfaceAdapter videoSurfaceAdapter) {
        super(videoSurfaceAdapter);
        this.canvas = canvas;
    }

    public final Canvas canvas() {
        return this.canvas;
    }

    @Override
    public void attach(LibVlc libvlc, MediaPlayer mediaPlayer) {
        this.logger.debug("attach()");
        if (!this.canvas.isDisplayable()) {
            throw new IllegalStateException("The video surface component must be displayable");
        }
        long componentId = Native.getComponentID((Component)this.canvas);
        this.logger.debug("componentId={}", (Object)componentId);
        this.videoSurfaceAdapter.attach(libvlc, mediaPlayer, componentId);
        this.logger.debug("video surface attached");
    }
}

