/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.factory.discovery.strategy;

import com.sun.jna.NativeLibrary;
import uk.co.caprica.vlcj.binding.lib.LibC;
import uk.co.caprica.vlcj.binding.support.runtime.RuntimeUtil;
import uk.co.caprica.vlcj.factory.discovery.provider.DirectoryProviderDiscoveryStrategy;

public class OsxNativeDiscoveryStrategy
extends DirectoryProviderDiscoveryStrategy {
    private static final String[] FILENAME_PATTERNS = new String[]{"libvlc\\.dylib", "libvlccore\\.dylib"};
    private static final String[] PLUGIN_PATH_FORMATS = new String[]{"%s/../plugins"};

    public OsxNativeDiscoveryStrategy() {
        super(FILENAME_PATTERNS, PLUGIN_PATH_FORMATS);
    }

    @Override
    public boolean supported() {
        return RuntimeUtil.isMac();
    }

    @Override
    public boolean onFound(String path) {
        this.forceLoadLibVlcCore(path);
        return true;
    }

    private void forceLoadLibVlcCore(String path) {
        NativeLibrary.addSearchPath((String)RuntimeUtil.getLibVlcCoreLibraryName(), (String)path);
        NativeLibrary.getInstance((String)RuntimeUtil.getLibVlcCoreLibraryName());
    }

    @Override
    protected boolean setPluginPath(String pluginPath) {
        return LibC.INSTANCE.setenv("VLC_PLUGIN_PATH", pluginPath, 1) == 0;
    }
}

