/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import com.sun.jna.Pointer;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_drain_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_flush_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_pause_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_play_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_resume_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_set_volume_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_player_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.callback.AudioCallback;

final class AudioCallbacks {
    private final libvlc_audio_play_cb playCallback = new PlayCallback();
    private final libvlc_audio_pause_cb pauseCallback = new PauseCallback();
    private final libvlc_audio_resume_cb resumeCallback = new ResumeCallback();
    private final libvlc_audio_flush_cb flushCallback = new FlushCallback();
    private final libvlc_audio_drain_cb drainCallback = new DrainCallback();
    private final libvlc_audio_set_volume_cb setVolumeCallback = new SetVolumeCallback();
    private final MediaPlayer mediaPlayer;
    private AudioCallback audioCallback;

    AudioCallbacks(MediaPlayer mediaPlayer) {
        this.mediaPlayer = mediaPlayer;
    }

    void callback(String format, int rate, int channels, AudioCallback audioCallback, boolean manageVolume) {
        this.audioCallback = audioCallback;
        this.enableCallbacks(format, rate, channels, manageVolume);
    }

    private void enableCallbacks(String format, int rate, int channels, boolean manageVolume) {
        LibVlc.libvlc_audio_set_format((libvlc_media_player_t)this.mediaPlayer.mediaPlayerInstance(), (String)format, (int)rate, (int)channels);
        LibVlc.libvlc_audio_set_callbacks((libvlc_media_player_t)this.mediaPlayer.mediaPlayerInstance(), (libvlc_audio_play_cb)this.playCallback, (libvlc_audio_pause_cb)this.pauseCallback, (libvlc_audio_resume_cb)this.resumeCallback, (libvlc_audio_flush_cb)this.flushCallback, (libvlc_audio_drain_cb)this.drainCallback, null);
        if (manageVolume) {
            LibVlc.libvlc_audio_set_volume_callback((libvlc_media_player_t)this.mediaPlayer.mediaPlayerInstance(), (libvlc_audio_set_volume_cb)this.setVolumeCallback);
        }
    }

    private final class PlayCallback
    implements libvlc_audio_play_cb {
        private PlayCallback() {
        }

        public void play(Pointer data, Pointer samples, int count, long pts) {
            AudioCallbacks.this.audioCallback.play(AudioCallbacks.this.mediaPlayer, samples, count, pts);
        }
    }

    private final class PauseCallback
    implements libvlc_audio_pause_cb {
        private PauseCallback() {
        }

        public void pause(Pointer data, long pts) {
            AudioCallbacks.this.audioCallback.pause(AudioCallbacks.this.mediaPlayer, pts);
        }
    }

    private final class ResumeCallback
    implements libvlc_audio_resume_cb {
        private ResumeCallback() {
        }

        public void resume(Pointer data, long pts) {
            AudioCallbacks.this.audioCallback.resume(AudioCallbacks.this.mediaPlayer, pts);
        }
    }

    private final class FlushCallback
    implements libvlc_audio_flush_cb {
        private FlushCallback() {
        }

        public void flush(Pointer data, long pts) {
            AudioCallbacks.this.audioCallback.flush(AudioCallbacks.this.mediaPlayer, pts);
        }
    }

    private final class DrainCallback
    implements libvlc_audio_drain_cb {
        private DrainCallback() {
        }

        public void drain(Pointer data) {
            AudioCallbacks.this.audioCallback.drain(AudioCallbacks.this.mediaPlayer);
        }
    }

    private class SetVolumeCallback
    implements libvlc_audio_set_volume_cb {
        private SetVolumeCallback() {
        }

        public void setVolume(Pointer data, float volume, int mute) {
            AudioCallbacks.this.audioCallback.setVolume(volume, mute == 0);
        }
    }
}

