/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.codec.java;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.co.real_logic.sbe.codec.java.GroupOrder;

public class MethodSelector {
    private final Set<String> ignoredMethods;
    private final Map<Class<?>, Set<String>> sortedMethods = new HashMap();

    public static Set<String> objectAndIteratorMethods() {
        return new HashSet<String>(Arrays.asList("hashCode", "clone", "toString", "getClass", "next", "hasNext", "remove", "iterator"));
    }

    public MethodSelector(Set<String> ignoredMethods) {
        this.ignoredMethods = ignoredMethods;
    }

    public List<Method> select(Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        Set<String> sortedMethodNames = this.getSortedMethods(clazz, methods);
        HashMap<String, Method> sortedMethods = new HashMap<String, Method>();
        ArrayList<Method> unsortedMethods = new ArrayList<Method>();
        for (Method method : methods) {
            this.selectMethod(sortedMethodNames, sortedMethods, unsortedMethods, method);
        }
        for (String name : sortedMethodNames) {
            unsortedMethods.add((Method)sortedMethods.get(name));
        }
        return unsortedMethods;
    }

    private Set<String> getSortedMethods(Class<?> clazz, Method[] methods) {
        Set<String> sortedMethodNames = this.sortedMethods.get(clazz);
        if (sortedMethodNames == null) {
            GroupOrder order = clazz.getAnnotation(GroupOrder.class);
            if (order == null) {
                this.sortedMethods.put(clazz, Collections.emptySet());
                return Collections.emptySet();
            }
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (Class<?> groupClazz : order.value()) {
                for (Method method : methods) {
                    if (method.getReturnType() != groupClazz || method.getParameterTypes().length != 0) continue;
                    result.add(method.getName());
                }
            }
            this.sortedMethods.put(clazz, result);
            return result;
        }
        return sortedMethodNames;
    }

    private void selectMethod(Set<String> sortedMethodNames, Map<String, Method> sortedMethods, List<Method> unsortedMethods, Method method) {
        int mods = method.getModifiers();
        if (!Modifier.isPublic(mods) || Modifier.isStatic(mods) || method.getParameterTypes().length != 0 || method.getReturnType().equals(Void.TYPE) || this.ignoredMethods.contains(method.getName())) {
            return;
        }
        if (sortedMethodNames == null) {
            unsortedMethods.add(method);
        } else if (sortedMethodNames.contains(method.getName())) {
            sortedMethods.put(method.getName(), method);
        } else {
            unsortedMethods.add(method);
        }
    }
}

