/*
 * Decompiled with CFR 0.152.
 */
package jal.doubles;

import jal.doubles.BinaryOperator;
import jal.doubles.BinaryPredicate;
import jal.doubles.Generator;
import jal.doubles.Inspection;
import jal.doubles.Predicate;
import jal.doubles.UnaryOperator;
import java.util.Random;

public final class Modification {
    private static Random default_RNG = new Random();

    public static void copy(double[] source, double[] destination, int first, int last, int to) {
        if (last > first) {
            System.arraycopy(source, first, destination, to, last - first);
        }
    }

    public static void swap_ranges(double[] array1, double[] array2, int first1, int last1, int first2) {
        while (first1 < last1) {
            double tmp = array2[first2];
            array2[first2] = array1[first1];
            array1[first1] = tmp;
            ++first1;
            ++first2;
        }
    }

    public static void transform(double[] source, double[] destination, int first, int last, int to, UnaryOperator f) {
        while (first < last) {
            destination[to++] = f.apply(source[first++]);
        }
    }

    public static void transform(double[] source1, double[] source2, double[] destination, int first1, int last1, int first2, int to, BinaryOperator f) {
        while (first1 < last1) {
            destination[to++] = f.apply(source1[first1++], source2[first2++]);
        }
    }

    public static void replace(double[] array, int first, int last, double old_value, double new_value) {
        while (first < last) {
            if (array[first] == old_value) {
                array[first] = new_value;
            }
            ++first;
        }
    }

    public static void replace_if(double[] array, int first, int last, Predicate p, double new_value) {
        while (first < last) {
            if (p.apply(array[first])) {
                array[first] = new_value;
            }
            ++first;
        }
    }

    public static void replace_copy(double[] source, double[] destination, int first, int last, int to, double old_value, double new_value) {
        while (first < last) {
            double tmp = source[first++];
            destination[to++] = tmp == old_value ? new_value : tmp;
        }
    }

    public static void replace_copy_if(double[] source, double[] destination, int first, int last, int to, Predicate p, double new_value) {
        while (first < last) {
            double tmp = source[first++];
            destination[to++] = p.apply(tmp) ? new_value : tmp;
        }
    }

    public static void fill(double[] array, int first, int last, double x) {
        while (first < last) {
            array[first++] = x;
        }
    }

    public static void generate(double[] array, int first, int last, Generator f) {
        while (first < last) {
            array[first++] = f.apply();
        }
    }

    public static int remove_if(double[] array, int first, int last, double x) {
        int oldLast = last;
        --first;
        while (true) {
            if (++first < last && array[first] != x) {
                continue;
            }
            while (first < --last && array[last] == x) {
            }
            if (first >= last) {
                return first;
            }
            array[first] = array[last];
        }
    }

    public static int remove_if(double[] array, int first, int last, Predicate p) {
        int oldLast = last;
        --first;
        while (true) {
            if (++first < last && !p.apply(array[first])) {
                continue;
            }
            while (first < --last && p.apply(array[last])) {
            }
            if (first >= last) {
                return first;
            }
            array[first] = array[last];
        }
    }

    public static int stable_remove(double[] array, int first, int last, double x) {
        first = Inspection.find(array, first, last, x);
        int next = Inspection.find_not(array, first, last, x);
        while (next < last) {
            array[first++] = array[next];
            ++next;
            next = Inspection.find_not(array, next, last, x);
        }
        return first;
    }

    public static int stable_remove_if(double[] array, int first, int last, Predicate p) {
        first = Inspection.find_if(array, first, last, p);
        int next = Inspection.find_if_not(array, first, last, p);
        while (next < last) {
            array[first++] = array[next];
            ++next;
            next = Inspection.find_if_not(array, next, last, p);
        }
        return first;
    }

    public static int remove_copy(double[] source, double[] destination, int first, int last, int to, double value) {
        while (first < last) {
            double tmp;
            if ((tmp = source[first++]) == value) continue;
            destination[to++] = tmp;
        }
        return to;
    }

    public static int remove_copy_if(double[] source, double[] destination, int first, int last, int to, Predicate p) {
        while (first < last) {
            double tmp;
            if (p.apply(tmp = source[first++])) continue;
            destination[to++] = tmp;
        }
        return to;
    }

    public static int unique(double[] array, int first, int last) {
        first = Inspection.adjacent_find(array, first, last);
        return Modification.unique_copy(array, array, first, last, first);
    }

    public static int unique(double[] array, int first, int last, BinaryPredicate p) {
        first = Inspection.adjacent_find(array, first, last, p);
        return Modification.unique_copy(array, array, first, last, first, p);
    }

    public static int unique_copy(double[] source, double[] destination, int first, int last, int to) {
        if (first >= last) {
            return to;
        }
        destination[to] = source[first];
        while (++first < last) {
            if (destination[to] == source[first]) continue;
            destination[++to] = source[first];
        }
        return to + 1;
    }

    public static int unique_copy(double[] source, double[] destination, int first, int last, int to, BinaryPredicate p) {
        if (first >= last) {
            return to;
        }
        destination[to] = source[first];
        while (++first < last) {
            if (p.apply(destination[to], source[first])) continue;
            destination[++to] = source[first];
        }
        return to + 1;
    }

    public static void reverse(double[] array, int first, int last) {
        while (first < --last) {
            double tmp = array[first];
            array[first++] = array[last];
            array[last] = tmp;
        }
    }

    public static void reverse_copy(double[] array, int first, int last, int to) {
        while (last > first) {
            array[to++] = array[--last];
        }
    }

    public static void reverse_copy(double[] source, double[] destination, int first, int last, int to) {
        while (last > first) {
            destination[to++] = source[--last];
        }
    }

    public static void rotate(double[] array, int first, int middle, int last) {
        if (middle != first && middle != last) {
            Modification.reverse(array, first, middle);
            Modification.reverse(array, middle, last);
            Modification.reverse(array, first, last);
        }
    }

    public static void rotate_copy(double[] source, double[] destination, int first, int middle, int last, int to) {
        Modification.copy(source, destination, middle, last, to);
        Modification.copy(source, destination, first, middle, to + (last - middle));
    }

    public static void random_shuffle(double[] array, int first, int last, Random RNG) {
        for (int i = first + 1; i < last; ++i) {
            int randomPlace = Math.abs(RNG.nextInt()) % (i - first + 1);
            double tmp = array[randomPlace];
            array[randomPlace] = array[i];
            array[i] = tmp;
        }
    }

    public static void random_shuffle(double[] array, int first, int last) {
        Modification.random_shuffle(array, first, last, default_RNG);
    }

    public static int partition(double[] array, int first, int last, Predicate p) {
        --first;
        while (true) {
            if (++first < last && p.apply(array[first])) {
                continue;
            }
            while (first < --last && !p.apply(array[last])) {
            }
            if (first >= last) {
                return first;
            }
            double tmp = array[first];
            array[first] = array[last];
            array[last] = tmp;
        }
    }

    public static int stable_partition(double[] array, int first, int last, Predicate p) {
        if (first + 1 < last) {
            int middle = first + (last - first) / 2;
            int firstCut = Modification.stable_partition(array, first, middle, p);
            int secondCut = Modification.stable_partition(array, middle, last, p);
            Modification.rotate(array, firstCut, middle, secondCut);
            return firstCut + (secondCut - middle);
        }
        if (first >= last || !p.apply(array[first])) {
            return first;
        }
        return last;
    }

    private Modification() {
    }
}

