/*
 * Decompiled with CFR 0.152.
 */
package jal.objects;

import jal.objects.BinaryOperator;

public final class Numeric {
    public static Object accumulate(Object[] array, int first, int last, Object init, BinaryOperator op) {
        Object acc = init;
        while (first < last) {
            acc = op.apply(acc, array[first++]);
        }
        return acc;
    }

    public static Object inner_product(Object[] array1, Object[] array2, int first1, int last1, int first2, Object init, BinaryOperator op1, BinaryOperator op2) {
        Object acc = init;
        while (first1 < last1) {
            acc = op1.apply(acc, op2.apply(array1[first1++], array2[first2++]));
        }
        return acc;
    }

    public static int partial_sum(Object[] source, Object[] dest, int first, int last, int to, BinaryOperator op) {
        if (first < last) {
            dest[to] = source[first];
            Object value = dest[to];
            while (++first < last) {
                value = op.apply(value, source[first]);
                dest[++to] = value;
            }
            return to + 1;
        }
        return to;
    }

    public static int adjacent_difference(Object[] source, Object[] dest, int first, int last, int to, BinaryOperator op) {
        if (first < last) {
            dest[to] = source[first];
            Object prev_value = source[first];
            while (++first < last) {
                Object cur_value = source[first];
                dest[++to] = op.apply(cur_value, prev_value);
                prev_value = cur_value;
            }
            return to + 1;
        }
        return to;
    }

    private Numeric() {
    }
}

