/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import moa.AbstractMOAObject;
import moa.core.Measurement;
import moa.evaluation.ClassificationPerformanceEvaluator;
import weka.core.Utils;

public class FadingFactorClassificationPerformanceEvaluator
extends AbstractMOAObject
implements ClassificationPerformanceEvaluator {
    private static final long serialVersionUID = 1L;
    protected double TotalweightObserved;
    protected double alpha;
    protected Estimator weightCorrect;

    public void setalpha(double a) {
        this.alpha = a;
        this.reset();
    }

    public void reset() {
        this.weightCorrect = new Estimator(this.alpha);
    }

    public void addClassificationAttempt(int trueClass, double[] classVotes, double weight) {
        if (weight > 0.0) {
            this.TotalweightObserved += weight;
            if (Utils.maxIndex((double[])classVotes) == trueClass) {
                this.weightCorrect.add(1.0);
            } else {
                this.weightCorrect.add(0.0);
            }
        }
    }

    public Measurement[] getPerformanceMeasurements() {
        return new Measurement[]{new Measurement("classified instances", this.TotalweightObserved), new Measurement("classifications correct (percent)", this.getFractionCorrectlyClassified() * 100.0)};
    }

    public double getTotalWeightObserved() {
        return this.TotalweightObserved;
    }

    public double getFractionCorrectlyClassified() {
        return this.weightCorrect.estimation();
    }

    public double getFractionIncorrectlyClassified() {
        return 1.0 - this.getFractionCorrectlyClassified();
    }

    public void getDescription(StringBuilder sb, int indent) {
        Measurement.getMeasurementsDescription(this.getPerformanceMeasurements(), sb, indent);
    }

    protected class Estimator {
        protected double alpha;
        protected double estimation;
        protected double b;

        public Estimator(double a) {
            this.alpha = a;
            this.estimation = 0.0;
            this.b = 1.0;
        }

        public void add(double value) {
            this.estimation = this.alpha * this.estimation + value;
            this.b = this.alpha * this.b + 1.0;
        }

        public double estimation() {
            return this.estimation / this.b;
        }
    }
}

