/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import java.util.LinkedList;
import moa.AbstractMOAObject;
import moa.classifiers.Classifier;
import moa.core.Measurement;
import moa.evaluation.ClassificationPerformanceEvaluator;

public class LearningEvaluation
extends AbstractMOAObject {
    private static final long serialVersionUID = 1L;
    protected Measurement[] measurements;

    public LearningEvaluation(Measurement[] measurements) {
        this.measurements = (Measurement[])measurements.clone();
    }

    public LearningEvaluation(Measurement[] evaluationMeasurements, ClassificationPerformanceEvaluator cpe, Classifier model) {
        LinkedList<Measurement> measurementList = new LinkedList<Measurement>();
        for (Measurement measurement : evaluationMeasurements) {
            measurementList.add(measurement);
        }
        for (Measurement measurement : cpe.getPerformanceMeasurements()) {
            measurementList.add(measurement);
        }
        for (Measurement measurement : model.getModelMeasurements()) {
            measurementList.add(measurement);
        }
        this.measurements = measurementList.toArray(new Measurement[measurementList.size()]);
    }

    public Measurement[] getMeasurements() {
        return (Measurement[])this.measurements.clone();
    }

    public void getDescription(StringBuilder sb, int indent) {
        Measurement.getMeasurementsDescription(this.measurements, sb, indent);
    }
}

