/*
 * Decompiled with CFR 0.152.
 */
package moa.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import moa.gui.FileExtensionFilter;
import moa.gui.GUIUtils;

public class TextViewerPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static String exportFileExtension = "txt";
    protected JTextArea textArea = new JTextArea();
    protected JScrollPane scrollPane;
    protected JButton exportButton;

    public TextViewerPanel() {
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        this.exportButton = new JButton("Export as .txt file...");
        this.exportButton.setEnabled(false);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2));
        buttonPanel.add(this.exportButton);
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(this.textArea);
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)buttonPanel, "South");
        this.exportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setAcceptAllFileFilterUsed(true);
                fileChooser.addChoosableFileFilter(new FileExtensionFilter(exportFileExtension));
                if (fileChooser.showSaveDialog(TextViewerPanel.this) == 0) {
                    File chosenFile = fileChooser.getSelectedFile();
                    String fileName = chosenFile.getPath();
                    if (!chosenFile.exists() && !fileName.endsWith(exportFileExtension)) {
                        fileName = fileName + "." + exportFileExtension;
                    }
                    try {
                        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                        out.write(TextViewerPanel.this.textArea.getText());
                        out.close();
                    }
                    catch (IOException ioe) {
                        GUIUtils.showExceptionDialog(TextViewerPanel.this.exportButton, "Problem saving file " + fileName, ioe);
                    }
                }
            }
        });
    }

    public void setText(String newText) {
        Point p = this.scrollPane.getViewport().getViewPosition();
        this.textArea.setText(newText);
        this.scrollPane.getViewport().setViewPosition(p);
        this.exportButton.setEnabled(newText != null);
    }
}

