/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers;

import moa.classifiers.HoeffdingTree;
import moa.classifiers.NaiveBayes;
import moa.classifiers.RandomHoeffdingTreeNB;
import weka.core.Instance;
import weka.core.Utils;

public class RandomHoeffdingTreeNBAdaptive
extends RandomHoeffdingTreeNB {
    private static final long serialVersionUID = 1L;

    protected HoeffdingTree.LearningNode newLearningNode(double[] initialClassObservations) {
        return new LearningNodeNBAdaptive(initialClassObservations);
    }

    public static class LearningNodeNBAdaptive
    extends RandomHoeffdingTreeNB.LearningNodeNB {
        private static final long serialVersionUID = 1L;
        protected double mcCorrectWeight = 0.0;
        protected double nbCorrectWeight = 0.0;

        public LearningNodeNBAdaptive(double[] initialClassObservations) {
            super(initialClassObservations);
        }

        public void learnFromInstance(Instance inst, HoeffdingTree ht) {
            int trueClass = (int)inst.classValue();
            if (this.observedClassDistribution.maxIndex() == trueClass) {
                this.mcCorrectWeight += inst.weight();
            }
            if (Utils.maxIndex((double[])NaiveBayes.doNaiveBayesPrediction(inst, this.observedClassDistribution, this.attributeObservers)) == trueClass) {
                this.nbCorrectWeight += inst.weight();
            }
            super.learnFromInstance(inst, ht);
        }

        public double[] getClassVotes(Instance inst, HoeffdingTree ht) {
            if (this.mcCorrectWeight > this.nbCorrectWeight) {
                return this.observedClassDistribution.getArrayCopy();
            }
            return NaiveBayes.doNaiveBayesPrediction(inst, this.observedClassDistribution, this.attributeObservers);
        }
    }
}

