/*
 * Decompiled with CFR 0.152.
 */
package moa.cluster;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import moa.cluster.Cluster;
import moa.cluster.Miniball;
import weka.core.DenseInstance;
import weka.core.Instance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SphereCluster
extends Cluster {
    private double[] center;
    private double radius;
    private double weight;

    public SphereCluster(double[] center, double radius) {
        this(center, radius, 1.0);
    }

    public SphereCluster() {
    }

    public SphereCluster(double[] center, double radius, double weightedSize) {
        this();
        this.center = center;
        this.radius = radius;
        this.weight = weightedSize;
    }

    public SphereCluster(int dimensions, double radius, Random random) {
        this();
        this.center = new double[dimensions];
        this.radius = radius;
        double interval = 1.0 - 2.0 * radius;
        for (int i = 0; i < this.center.length; ++i) {
            this.center[i] = random.nextDouble() * interval + radius;
        }
        this.weight = 0.0;
    }

    public SphereCluster(List<? extends Instance> instances, int dimension) {
        this();
        if (instances == null || instances.size() <= 0) {
            return;
        }
        this.weight = instances.size();
        Miniball mb = new Miniball(dimension);
        mb.clear();
        for (Instance instance : instances) {
            mb.check_in(instance.toDoubleArray());
        }
        mb.build();
        this.center = mb.center();
        this.radius = mb.radius();
        mb.clear();
    }

    public double overlapRadiusDegree(SphereCluster other) {
        double radiusSmall;
        double radiusBig;
        double[] center0 = this.getCenter();
        double radius0 = this.getRadius();
        double[] center1 = other.getCenter();
        double radius1 = other.getRadius();
        if (radius0 < radius1) {
            radiusBig = radius1;
            radiusSmall = radius0;
        } else {
            radiusBig = radius0;
            radiusSmall = radius1;
        }
        double dist = 0.0;
        for (int i = 0; i < center0.length; ++i) {
            double delta = center0[i] - center1[i];
            dist += delta * delta;
        }
        if ((dist = Math.sqrt(dist)) > radiusSmall + radiusBig) {
            return 0.0;
        }
        if (dist + radiusSmall <= radiusBig) {
            return 1.0;
        }
        return (radiusSmall + radiusBig - dist) / (2.0 * radiusSmall);
    }

    public void combine(SphereCluster cluster) {
        double[] center = this.getCenter();
        double[] newcenter = new double[center.length];
        double[] other_center = cluster.getCenter();
        double other_weight = cluster.getWeight();
        double other_radius = cluster.getRadius();
        for (int i = 0; i < center.length; ++i) {
            newcenter[i] = (center[i] * this.getWeight() + other_center[i] * other_weight) / (this.getWeight() + other_weight);
        }
        center = newcenter;
        double r_0 = this.getRadius() + Math.abs(this.distance(center, newcenter));
        double r_1 = other_radius + Math.abs(this.distance(other_center, newcenter));
        this.radius = Math.max(r_0, r_1);
        this.weight += other_weight;
    }

    public void merge(SphereCluster cluster) {
        double[] c0 = this.getCenter();
        double w0 = this.getWeight();
        double r0 = this.getRadius();
        double[] c1 = cluster.getCenter();
        double w1 = cluster.getWeight();
        double r1 = cluster.getRadius();
        double[] v = new double[c0.length];
        double d = 0.0;
        for (int i = 0; i < c0.length; ++i) {
            v[i] = c0[i] - c1[i];
            d += v[i] * v[i];
        }
        d = Math.sqrt(d);
        double r = 0.0;
        double[] c = new double[c0.length];
        if (d + r0 <= r1 || d + r1 <= r0) {
            if (d + r0 <= r1) {
                r = r1;
                c = c1;
            } else {
                r = r0;
                c = c0;
            }
        } else {
            r = (r0 + r1 + d) / 2.0;
            for (int i = 0; i < c.length; ++i) {
                c[i] = c1[i] - v[i] / d * (r1 - r);
            }
        }
        this.setCenter(c);
        this.setRadius(r);
        this.setWeight(w0 + w1);
    }

    @Override
    public double[] getCenter() {
        double[] copy = new double[this.center.length];
        System.arraycopy(this.center, 0, copy, 0, this.center.length);
        return copy;
    }

    public void setCenter(double[] center) {
        this.center = center;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    @Override
    public double getInclusionProbability(Instance instance) {
        if (this.getCenterDistance(instance) <= this.getRadius()) {
            return 1.0;
        }
        return 0.0;
    }

    public double getCenterDistance(Instance instance) {
        double distance = 0.0;
        double[] center = this.getCenter();
        for (int i = 0; i < center.length; ++i) {
            double d = center[i] - instance.value(i);
            distance += d * d;
        }
        return Math.sqrt(distance);
    }

    public double getCenterDistance(SphereCluster other) {
        return this.distance(this.getCenter(), other.getCenter());
    }

    public double getHullDistance(SphereCluster other) {
        double distance = 0.0;
        double[] center0 = this.getCenter();
        double[] center1 = other.getCenter();
        distance = this.distance(center0, center1);
        distance = distance - this.getRadius() - other.getRadius();
        return distance;
    }

    public boolean overlapSave(SphereCluster other) {
        double minDist = Math.sqrt(2.0) * (this.getRadius() + other.getRadius());
        double diff = this.getCenterDistance(other) - minDist;
        return diff > 0.0;
    }

    private double distance(double[] v1, double[] v2) {
        double distance = 0.0;
        double[] center = this.getCenter();
        for (int i = 0; i < center.length; ++i) {
            double d = v1[i] - v2[i];
            distance += d * d;
        }
        return Math.sqrt(distance);
    }

    public double[] getDistanceVector(Instance instance) {
        return this.distanceVector(this.getCenter(), instance.toDoubleArray());
    }

    public double[] getDistanceVector(SphereCluster other) {
        return this.distanceVector(this.getCenter(), other.getCenter());
    }

    private double[] distanceVector(double[] v1, double[] v2) {
        double[] v = new double[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            v[i] = v2[i] - v1[i];
        }
        return v;
    }

    @Override
    public Instance sample(Random random) {
        double[] center = this.getCenter();
        int dimensions = center.length;
        double[] sin = new double[dimensions - 1];
        double[] cos = new double[dimensions - 1];
        double length = random.nextDouble() * this.getRadius();
        double lastValue = 1.0;
        for (int i = 0; i < dimensions - 1; ++i) {
            double angle = random.nextDouble() * 2.0 * Math.PI;
            sin[i] = lastValue * Math.sin(angle);
            cos[i] = Math.cos(angle);
            lastValue = sin[i];
        }
        double[] res = new double[dimensions];
        res[0] = center[0] + length * cos[0];
        for (int i = 1; i < dimensions - 1; ++i) {
            res[i] = center[i] + length * sin[i - 1] * cos[i];
        }
        res[dimensions - 1] = center[dimensions - 1] + length * sin[dimensions - 2];
        return new DenseInstance(1.0, res);
    }

    @Override
    protected void getClusterSpecificInfo(ArrayList<String> infoTitle, ArrayList<String> infoValue) {
        super.getClusterSpecificInfo(infoTitle, infoValue);
        infoTitle.add("Radius");
        infoValue.add(Double.toString(this.getRadius()));
    }
}

