/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import moa.cluster.Clustering;
import moa.cluster.SphereCluster;
import moa.clusterers.AbstractClusterer;
import moa.core.Measurement;
import moa.gui.visualization.DataPoint;
import moa.options.FloatOption;
import moa.options.IntOption;
import weka.core.Instance;

public class ClusterGenerator
extends AbstractClusterer {
    public IntOption timeWindowOption = new IntOption("timeWindow", 't', "Rang of the window.", 1000);
    public FloatOption radiusDecreaseOption = new FloatOption("radiusDecrease", 'r', "The average radii of the centroids in the model.", 0.0, 0.0, 1.0);
    public FloatOption radiusIncreaseOption = new FloatOption("radiusIncrease", 'R', "The average radii of the centroids in the model.", 0.0, 0.0, 1.0);
    public FloatOption positionOffsetOption = new FloatOption("positionOffset", 'p', "The average radii of the centroids in the model.", 0.0, 0.0, 1.0);
    private static double err_intervall_width = 0.0;
    private ArrayList<DataPoint> points;
    private int instanceCounter;
    private int windowCounter;
    private Random random;
    private double overlapThreshold;
    private int microInitMinPoints = 5;
    private Clustering sourceClustering = null;

    public void resetLearningImpl() {
        this.points = new ArrayList();
        this.instanceCounter = 0;
        this.windowCounter = 0;
        this.random = new Random(227L);
    }

    public void trainOnInstanceImpl(Instance inst) {
        if (this.windowCounter >= this.timeWindowOption.getValue()) {
            this.points.clear();
            this.windowCounter = 0;
        }
        ++this.windowCounter;
        ++this.instanceCounter;
        this.points.add(new DataPoint(inst, this.instanceCounter));
    }

    public boolean implementsMicroClusterer() {
        return true;
    }

    public void setSourceClustering(Clustering source) {
        this.sourceClustering = source;
    }

    public Clustering getMicroClusteringResult() {
        if (this.sourceClustering == null) {
            System.out.println("You need to set a source clustering for the ClusterGenerator to work");
            return null;
        }
        return this.alterClustering(this.sourceClustering);
    }

    public Clustering getClusteringResult() {
        this.sourceClustering = new Clustering(this.points);
        return this.alterClustering(this.sourceClustering);
    }

    private Clustering alterClustering(Clustering scclustering) {
        double errLevelRadiusDecrease = this.radiusDecreaseOption.getValue();
        double errLevelRadiusIncrease = this.radiusIncreaseOption.getValue();
        double errLevelPosition = this.positionOffsetOption.getValue();
        int numCluster = scclustering.size();
        double[] err_seeds = new double[numCluster];
        double err_seed_sum = 0.0;
        for (int i = 0; i < numCluster; ++i) {
            double tmp_seed = this.random.nextDouble();
            err_seeds[i] = err_seed_sum + tmp_seed;
            err_seed_sum += tmp_seed;
        }
        double sumWeight = 0.0;
        for (int i = 0; i < numCluster; ++i) {
            sumWeight += scclustering.get(i).getWeight();
        }
        Clustering clustering = new Clustering();
        for (int i = 0; i < numCluster; ++i) {
            double errOffset;
            if (!(scclustering.get(i) instanceof SphereCluster)) {
                System.out.println("Not a Sphere Cluster");
                continue;
            }
            SphereCluster sourceCluster = (SphereCluster)scclustering.get(i);
            double[] center = Arrays.copyOf(sourceCluster.getCenter(), sourceCluster.getCenter().length);
            double weight = sourceCluster.getWeight();
            double radius = sourceCluster.getRadius();
            if (errLevelPosition > 0.0) {
                int d;
                errOffset = this.random.nextDouble() * err_intervall_width / 2.0;
                double errOffsetDirection = this.random.nextBoolean() ? 1 : -1;
                double level = errLevelPosition + errOffsetDirection * errOffset;
                double[] vector = new double[center.length];
                double vectorLength = 0.0;
                for (int d2 = 0; d2 < center.length; ++d2) {
                    vector[d2] = (double)(this.random.nextBoolean() ? 1 : -1) * this.random.nextDouble();
                    vectorLength += Math.pow(vector[d2], 2.0);
                }
                vectorLength = Math.sqrt(vectorLength);
                double length = 2.0 * radius * level;
                for (int d3 = 0; d3 < center.length; ++d3) {
                    vector[d3] = vector[d3] / vectorLength * length;
                }
                double[] newCenter = new double[center.length];
                for (d = 0; d < center.length; ++d) {
                    newCenter[d] = center[d] + vector[d] >= 0.0 && center[d] + vector[d] <= 1.0 ? center[d] + vector[d] : center[d] + -1.0 * vector[d];
                }
                center = newCenter;
                for (d = 0; d < center.length; ++d) {
                    if (newCenter[d] >= 0.0 && newCenter[d] <= 1.0) continue;
                    System.out.println("This shouldnt have happend, Cluster center out of bounds:" + Arrays.toString(newCenter));
                }
            }
            if (errLevelRadiusDecrease > 0.0 || errLevelRadiusIncrease > 0.0) {
                double level;
                int errOffsetDirection;
                errOffset = this.random.nextDouble() * err_intervall_width / 2.0;
                int n = errOffsetDirection = this.random.nextBoolean() ? 1 : -1;
                if (errLevelRadiusDecrease > 0.0 && (errLevelRadiusIncrease == 0.0 || this.random.nextBoolean())) {
                    level = errLevelRadiusDecrease + (double)errOffsetDirection * errOffset;
                    level = level < 0.0 ? 0.0 : level;
                    level = level > 1.0 ? 1.0 : level;
                    radius *= 1.0 - level;
                } else {
                    level = errLevelRadiusIncrease + (double)errOffsetDirection * errOffset;
                    level = level < 0.0 ? 0.0 : level;
                    level = level > 1.0 ? 1.0 : level;
                    radius += radius * level;
                }
            }
            SphereCluster newCluster = new SphereCluster(center, radius, weight);
            newCluster.setMeasureValue("Source Cluster", "C" + sourceCluster.getId());
            clustering.add(newCluster);
        }
        return clustering;
    }

    protected Measurement[] getModelMeasurementsImpl() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void getModelDescription(StringBuilder out, int indent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isRandomizable() {
        return false;
    }

    public double[] getVotesForInstance(Instance inst) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

