/*
 * Decompiled with CFR 0.152.
 */
package moa.gui;

import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import moa.gui.AbstractTabPanel;
import moa.gui.GUIDefaults;

public class GUI
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTabbedPane panel;

    public GUI() {
        this.createAndShowGUI();
    }

    private void createAndShowGUI() {
        JFrame frame = new JFrame("MOA Graphical User Interface");
        frame.setDefaultCloseOperation(3);
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.panel = new JTabbedPane();
        frame.setContentPane(this.panel);
        String[] tabs = GUIDefaults.getTabs();
        Hashtable tabOptions = new Hashtable();
        for (int i = 0; i < tabs.length; ++i) {
            try {
                String[] optionsStr = tabs[i].split(":");
                String classname = optionsStr[0];
                AbstractTabPanel tabPanel = (AbstractTabPanel)Class.forName(classname).newInstance();
                this.panel.addTab(tabPanel.getTabTitle(), null, tabPanel, tabPanel.getDescription());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GUI gui = new GUI();
                    gui.setVisible(true);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

