/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import moa.cluster.Cluster;
import moa.cluster.Clustering;
import moa.evaluation.MeasureCollection;
import moa.gui.visualization.DataPoint;
import weka.core.Instance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticalCollection2
extends MeasureCollection {
    private static final long serialVersionUID = 1L;
    protected Random instanceRandom = new Random(117L);
    private boolean debug = false;
    private final double beta = 0.5;

    @Override
    protected String[] getNames() {
        String[] names = new String[]{"GT cross entropy", "FC cross entropy", "Homogeneity", "Completeness", "V-Measure"};
        return names;
    }

    @Override
    protected boolean[] getDefaultEnabled() {
        boolean[] defaults = new boolean[]{false, false, false, false, false};
        return defaults;
    }

    @Override
    public void evaluateClustering(Clustering clustering, Clustering trueClustering, ArrayList<DataPoint> points) throws Exception {
        double homogeneity;
        int[][] counts = new int[trueClustering.size() + 1][clustering.size() + 1];
        int[] sumsHC = new int[trueClustering.size() + 1];
        int[] sumsFC = new int[clustering.size() + 1];
        int n = 0;
        for (int p = 0; p < points.size(); ++p) {
            DataPoint point = points.get(p);
            boolean hc_noise = true;
            for (int i = 0; i < trueClustering.size() + 1; ++i) {
                boolean check = false;
                if (i < trueClustering.size()) {
                    Cluster hc = trueClustering.get(i);
                    if (hc.getInclusionProbability((Instance)point) >= 1.0) {
                        check = true;
                        hc_noise = false;
                    }
                } else if (hc_noise) {
                    check = true;
                }
                if (!check) continue;
                boolean fc_noise = true;
                for (int j = 0; j < clustering.size() + 1; ++j) {
                    if (j < clustering.size()) {
                        Cluster fc = clustering.get(j);
                        if (!(fc.getInclusionProbability((Instance)point) >= 1.0)) continue;
                        int[] nArray = counts[i];
                        int n2 = j;
                        nArray[n2] = nArray[n2] + 1;
                        int n3 = j;
                        sumsFC[n3] = sumsFC[n3] + 1;
                        int n4 = i;
                        sumsHC[n4] = sumsHC[n4] + 1;
                        ++n;
                        fc_noise = false;
                        continue;
                    }
                    if (!fc_noise) continue;
                    int[] nArray = counts[i];
                    int n5 = j;
                    nArray[n5] = nArray[n5] + 1;
                    int n6 = j;
                    sumsFC[n6] = sumsFC[n6] + 1;
                    int n7 = i;
                    sumsHC[n7] = sumsHC[n7] + 1;
                    ++n;
                }
            }
        }
        if (this.debug) {
            for (int i = 0; i < counts.length; ++i) {
                System.out.println("Con " + i + ": " + Arrays.toString(counts[i]));
            }
            System.out.println("Sum FC " + Arrays.toString(sumsFC));
            System.out.println("Sum HC " + Arrays.toString(sumsHC));
        }
        double FCentropy = 0.0;
        for (int fc = 0; fc < clustering.size() + 1; ++fc) {
            double weight = (double)sumsFC[fc] / (double)n;
            if (!(weight > 0.0)) continue;
            FCentropy += weight * Math.log10(weight);
        }
        FCentropy /= -1.0 * Math.log10(clustering.size() + 1);
        if (this.debug) {
            System.out.println("FC entropy " + FCentropy);
        }
        double GTentropy = 0.0;
        for (int hc = 0; hc < trueClustering.size() + 1; ++hc) {
            double weight = (double)sumsHC[hc] / (double)n;
            if (!(weight > 0.0)) continue;
            GTentropy += weight * Math.log10(weight);
        }
        GTentropy /= -1.0 * Math.log10(trueClustering.size() + 1);
        if (this.debug) {
            System.out.println("GT entropy " + GTentropy);
        }
        double FCcrossEntropy = 0.0;
        for (int fc = 0; fc < clustering.size() + 1; ++fc) {
            double e = 0.0;
            if (sumsFC[fc] <= 0) continue;
            for (int hc = 0; hc < trueClustering.size() + 1; ++hc) {
                if (counts[hc][fc] == 0) continue;
                double prob = (double)counts[hc][fc] / (double)sumsFC[fc];
                e += prob * Math.log10(prob);
            }
            FCcrossEntropy += (double)sumsFC[fc] / (double)n * e;
        }
        this.addValue("FC cross entropy", 1.0 - (FCcrossEntropy /= -1.0 * Math.log10(trueClustering.size() + 1)));
        if (this.debug) {
            System.out.println("FC cross entropy " + (1.0 - FCcrossEntropy));
        }
        double GTcrossEntropy = 0.0;
        for (int hc = 0; hc < trueClustering.size() + 1; ++hc) {
            double e = 0.0;
            if (sumsHC[hc] > 0) {
                for (int fc = 0; fc < clustering.size() + 1; ++fc) {
                    if (counts[hc][fc] == 0) continue;
                    double prob = (double)counts[hc][fc] / (double)sumsHC[hc];
                    e += prob * Math.log10(prob);
                }
            }
            GTcrossEntropy += (double)sumsHC[hc] / (double)n * e;
        }
        this.addValue("GT cross entropy", 1.0 - (GTcrossEntropy /= -1.0 * Math.log10(trueClustering.size() + 1)));
        if (this.debug) {
            System.out.println("GT cross entropy " + (1.0 - GTcrossEntropy));
        }
        if ((homogeneity = FCentropy == 0.0 ? 1.0 : 1.0 - FCcrossEntropy / FCentropy) > 1.0 || homogeneity < 0.0) {
            this.addValue("Homogeneity", -1.0);
        } else {
            this.addValue("Homogeneity", homogeneity);
        }
        double completeness = GTentropy == 0.0 ? 1.0 : 1.0 - GTcrossEntropy / GTentropy;
        this.addValue("Completeness", completeness);
        double vmeasure = 1.5 * homogeneity * completeness / (0.5 * homogeneity + completeness);
        if (Double.isNaN(vmeasure)) {
            // empty if block
        }
        if (vmeasure > 1.0 || homogeneity < 0.0) {
            this.addValue("V-Measure", -1.0);
        } else {
            this.addValue("V-Measure", vmeasure);
        }
    }
}

