/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.visualization;

import java.util.HashMap;
import java.util.TreeSet;
import weka.core.DenseInstance;
import weka.core.Instance;

public class DataPoint
extends DenseInstance {
    protected int timestamp;
    private HashMap<String, String> measure_values;

    public DataPoint(Instance nextInstance, Integer timestamp) {
        super(nextInstance);
        this.setDataset(nextInstance.dataset());
        this.timestamp = timestamp;
        this.measure_values = new HashMap();
    }

    public void updateWeight(int cur_timestamp, double decay_rate) {
        this.setWeight(Math.pow(2.0, -1.0 * decay_rate * (double)(cur_timestamp - this.timestamp)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMeasureValue(String measureKey, double value) {
        HashMap<String, String> hashMap = this.measure_values;
        synchronized (hashMap) {
            this.measure_values.put(measureKey, Double.toString(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMeasureValue(String measureKey, String value) {
        HashMap<String, String> hashMap = this.measure_values;
        synchronized (hashMap) {
            this.measure_values.put(measureKey, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMeasureValue(String measureKey) {
        if (this.measure_values.containsKey(measureKey)) {
            HashMap<String, String> hashMap = this.measure_values;
            synchronized (hashMap) {
                return this.measure_values.get(measureKey);
            }
        }
        return "";
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInfo(int x_dim, int y_dim) {
        TreeSet<String> sortedset;
        Object label;
        StringBuffer sb = new StringBuffer();
        sb.append("<html><table>");
        sb.append("<tr><td>Point</td><td>" + this.timestamp + "</td></tr>");
        for (int i = 0; i < this.m_AttValues.length - 1; ++i) {
            label = "Dim " + i;
            if (i == x_dim) {
                label = "<b>X</b>";
            }
            if (i == y_dim) {
                label = "<b>Y</b>";
            }
            sb.append("<tr><td>" + (String)label + "</td><td>" + this.value(i) + "</td></tr>");
        }
        sb.append("<tr><td>Decay</td><td>" + this.weight() + "</td></tr>");
        sb.append("<tr><td>True cluster</td><td>" + this.classValue() + "</td></tr>");
        sb.append("</table>");
        sb.append("<br>");
        sb.append("<b>Evaluation</b><br>");
        sb.append("<table>");
        label = this.measure_values;
        synchronized (label) {
            sortedset = new TreeSet<String>(this.measure_values.keySet());
        }
        for (String key : sortedset) {
            sb.append("<tr><td>" + key + "</td><td>" + this.measure_values.get(key) + "</td></tr>");
        }
        sb.append("</table></html>");
        return sb.toString();
    }

    public double getDistance(DataPoint other) {
        double distance = 0.0;
        int numDims = this.numAttributes();
        if (this.classIndex() != 0) {
            --numDims;
        }
        for (int i = 0; i < numDims; ++i) {
            double d = this.value(i) - other.value(i);
            distance += d * d;
        }
        return Math.sqrt(distance);
    }
}

