/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.sequence;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.functions.Logistic;
import weka.classifiers.sequence.IterativeProfileHMMClassifier;
import weka.classifiers.sequence.core.Alphabet;
import weka.classifiers.sequence.core.BaumWelchLearner;
import weka.classifiers.sequence.core.ForwardAlgorithm;
import weka.classifiers.sequence.core.IllegalSymbolException;
import weka.classifiers.sequence.core.ImpossibleStateProbabilityException;
import weka.classifiers.sequence.core.InvalidStructureException;
import weka.classifiers.sequence.core.InvalidViterbiPathException;
import weka.classifiers.sequence.core.NumericStabilityException;
import weka.classifiers.sequence.core.ProbabilityPerStateCalculator;
import weka.classifiers.sequence.core.ProfileHMM;
import weka.classifiers.sequence.core.SufficientEmissionStatistics;
import weka.classifiers.sequence.core.ViterbiAlgorithm;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.instance.RemoveWithValues;

public class IterativeProfileHMMClassifierSingleHMM
extends IterativeProfileHMMClassifier {
    private static final long serialVersionUID = 3134763907535654753L;
    private ProfileHMM profileHMM = null;
    private double logLikelihoodOfPHMM;
    private double initiallogLikelihoodOfPHMM;
    private String[] allTrainingSequences;
    private double oldLogLikelihoodOfPHMM;
    private int numIterationPerClass;
    private Instances filtered;
    private Logistic logistic;
    private Instances preFiltered;
    private double[] trainingClassDistribution;
    private List<Double> viterbiScore;
    private List<Double> fwdScore;
    private List<List<Double>> allScore;
    private int iteration;

    public IterativeProfileHMMClassifierSingleHMM() {
        this.logLikelihoodThreshold = 1.0E-4;
        this.useNullModel = false;
        this.transitionsEmissionsNotInLog = false;
        this.learnInsertEmissions = false;
        this.setBaumWelchOption(2);
        this.viterbiProb = false;
        this.fwdProb = false;
        this.allProb = false;
        this.allProbOnly = false;
        this.noBasic = false;
        this.noPathLogScores = false;
        this.logLikelihoodOfPHMM = Double.NEGATIVE_INFINITY;
        this.initiallogLikelihoodOfPHMM = Double.NEGATIVE_INFINITY;
        this.converged = new Vector();
        this.oldLogLikelihoodOfPHMM = Double.NEGATIVE_INFINITY;
        this.numIterationPerClass = 0;
        this.positiveClassIndex = 0;
        this.filtered = null;
    }

    @Override
    public Instances propositionalise(Instances oldInstances) throws IllegalSymbolException, InvalidStructureException, InvalidViterbiPathException, ImpossibleStateProbabilityException {
        Instances transformed = this.createPropositionalisedInstancesFormat(oldInstances);
        for (int j = 0; j < oldInstances.numInstances(); ++j) {
            this.viterbiScore = new Vector<Double>();
            this.fwdScore = new Vector<Double>();
            this.allScore = new Vector<List<Double>>();
            Instance oldInstance = oldInstances.instance(j);
            String[] alignment = this.doAlignmentForPropositionalisation(oldInstance);
            transformed = this.doPropositionalisation(alignment, transformed, oldInstance.classValue());
        }
        return transformed;
    }

    public Instances extractSufficientStatistics(Instances oldInstances) throws IllegalSymbolException, InvalidStructureException, InvalidViterbiPathException, NumericStabilityException {
        String[] sequences = new String[oldInstances.numInstances()];
        for (int k = 0; k < oldInstances.numInstances(); ++k) {
            String sequence = oldInstances.instance(k).stringValue(oldInstances.instance(k).attribute(this.sequenceIndex));
            if (this.getRestrictSequenceLength() != -1 && sequence.length() > this.getRestrictSequenceLength()) {
                sequence = sequence.substring(0, this.getRestrictSequenceLength());
            }
            sequences[k] = sequence;
        }
        double[][] allAttributeValues = this.getSufficientStats(false, sequences);
        Instances transformed = this.createSufficientStatsFormat(oldInstances, allAttributeValues[1].length);
        for (int i = 0; i < oldInstances.numInstances(); ++i) {
            DenseInstance newInst = new DenseInstance(transformed.numAttributes());
            newInst.setDataset(transformed);
            newInst.setClassValue(oldInstances.instance(i).classValue());
            for (int j = 0; j < allAttributeValues[i].length; ++j) {
                newInst.setValue(j, allAttributeValues[i][j]);
            }
            transformed.add((Instance)newInst);
        }
        return transformed;
    }

    private Instances createSufficientStatsFormat(Instances oldInstances, int numNonClassAttributes) {
        FastVector attInfo = new FastVector(numNonClassAttributes + 1);
        FastVector my_nominal_class_values = new FastVector();
        for (int i = 0; i < oldInstances.numClasses(); ++i) {
            my_nominal_class_values.addElement((Object)oldInstances.classAttribute().value(i));
        }
        for (int j = 0; j < numNonClassAttributes; ++j) {
            Attribute tempAttribute = new Attribute("SuffStats_" + j);
            attInfo.addElement((Object)tempAttribute);
        }
        Attribute tempAttribute = new Attribute("class", (List)my_nominal_class_values);
        attInfo.addElement((Object)tempAttribute);
        Instances transformed = new Instances(oldInstances.relationName() + "_sufficientStatsSingleHMM", (ArrayList)attInfo, 1);
        transformed.setClassIndex(numNonClassAttributes);
        return transformed;
    }

    @Override
    public Instance propositionaliseTestInstance(Instance oldInstance) throws IllegalSymbolException, InvalidStructureException, InvalidViterbiPathException, ImpossibleStateProbabilityException {
        Instances oldInstances = oldInstance.dataset();
        Instances transformed = this.createPropositionalisedInstancesFormat(oldInstances);
        this.viterbiScore = new Vector<Double>();
        this.fwdScore = new Vector<Double>();
        this.allScore = new Vector<List<Double>>();
        String[] alignment = this.doAlignmentForPropositionalisation(oldInstance);
        transformed = this.doPropositionalisation(alignment, transformed, oldInstance.classValue());
        return transformed.firstInstance();
    }

    public Instance extractSufficientStatisticsTestInstance(Instance oldInstance) throws IllegalSymbolException, InvalidStructureException, InvalidViterbiPathException, NumericStabilityException {
        Instances oldInstances = oldInstance.dataset();
        String[] sequences = new String[1];
        String sequence = oldInstance.stringValue(oldInstance.attribute(this.sequenceIndex));
        if (this.getRestrictSequenceLength() != -1 && sequence.length() > this.getRestrictSequenceLength()) {
            sequence = sequence.substring(0, this.getRestrictSequenceLength());
        }
        sequences[0] = sequence;
        double[][] allAttributeValues = this.getSufficientStats(false, sequences);
        Instances transformed = this.createSufficientStatsFormat(oldInstances, allAttributeValues[0].length);
        DenseInstance newInst = new DenseInstance(transformed.numAttributes());
        newInst.setDataset(transformed);
        newInst.setClassValue(oldInstance.classValue());
        for (int j = 0; j < allAttributeValues[0].length; ++j) {
            newInst.setValue(j, allAttributeValues[0][j]);
        }
        transformed.add((Instance)newInst);
        return transformed.firstInstance();
    }

    private String[] doAlignmentForPropositionalisation(Instance oldInstance) throws IllegalSymbolException, InvalidStructureException, InvalidViterbiPathException, ImpossibleStateProbabilityException {
        String[] alignment = new String[1];
        String test = "";
        test = test + oldInstance.stringValue(oldInstance.attribute(this.sequenceIndex));
        if (this.getRestrictSequenceLength() != -1 && test.length() > this.getRestrictSequenceLength()) {
            test = test.substring(0, this.getRestrictSequenceLength());
        }
        if (this.profileHMM != null) {
            if (this.isViterbiProb() || !this.isNoBasic()) {
                ViterbiAlgorithm vitAlg = new ViterbiAlgorithm(this.profileHMM, test);
                alignment[0] = vitAlg.calculateViterbiPath();
                if (this.noBasic) {
                    alignment[0] = "";
                }
                this.viterbiScore.add(0, vitAlg.getScore());
                vitAlg = null;
            } else {
                alignment[0] = "";
            }
            if (this.isFwdProb()) {
                ForwardAlgorithm fwd = new ForwardAlgorithm(this.profileHMM, test);
                fwd.calculateForward();
                this.fwdScore.add(0, fwd.getScore());
                fwd = null;
            }
            if (this.isAllProb()) {
                ProbabilityPerStateCalculator calc = new ProbabilityPerStateCalculator(this.profileHMM, test);
                this.allScore.add(0, calc.getScores());
                calc = null;
            }
        } else {
            alignment[0] = "";
            this.viterbiScore.add(0, null);
            this.fwdScore.add(0, null);
            this.allScore.add(0, null);
        }
        if (this.noPathLogScores) {
            int i;
            double[] path;
            int viterbiSize = this.viterbiScore.size();
            int fwdSize = this.fwdScore.size();
            if (viterbiSize > 0) {
                path = new double[viterbiSize];
                for (i = 0; i < viterbiSize; ++i) {
                    path[i] = this.viterbiScore.get(i);
                }
                path = Utils.logs2probs((double[])path);
                Utils.normalize((double[])path);
                for (i = 0; i < viterbiSize; ++i) {
                    this.viterbiScore.set(i, path[i]);
                }
                path = null;
            }
            if (fwdSize > 0) {
                path = new double[fwdSize];
                for (i = 0; i < fwdSize; ++i) {
                    path[i] = this.fwdScore.get(i);
                }
                path = Utils.logs2probs((double[])path);
                Utils.normalize((double[])path);
                for (i = 0; i < fwdSize; ++i) {
                    this.fwdScore.set(i, path[i]);
                }
                path = null;
            }
        }
        return alignment;
    }

    @Override
    protected Instances doPropositionalisation(String[] allAlignment, Instances transformed, double classValue) throws IllegalSymbolException, InvalidStructureException, InvalidViterbiPathException {
        DenseInstance newInst = new DenseInstance(transformed.numAttributes());
        newInst.setDataset(transformed);
        newInst.setClassValue(classValue);
        int attributeCounter = 0;
        for (int k = 0; k < allAlignment.length; ++k) {
            String alignment = allAlignment[k];
            for (int i = 0; i < alignment.length(); ++i) {
                if (alignment.charAt(i) == '-') {
                    newInst.setValue(attributeCounter, "-");
                    newInst.setValue(++attributeCounter, 0.0);
                    ++attributeCounter;
                    continue;
                }
                if (Character.isUpperCase(alignment.charAt(i))) {
                    newInst.setValue(attributeCounter, alignment.charAt(i) + "");
                    ++attributeCounter;
                }
                if (i < alignment.length() - 1 && Character.isLowerCase(alignment.charAt(i + 1))) {
                    ++i;
                    int count = 0;
                    while (i < alignment.length() && Character.isLowerCase(alignment.charAt(i))) {
                        ++i;
                        ++count;
                    }
                    --i;
                    newInst.setValue(attributeCounter, (double)count);
                    ++attributeCounter;
                    continue;
                }
                if (i >= alignment.length() - 1) continue;
                newInst.setValue(attributeCounter, 0.0);
                ++attributeCounter;
            }
            if (this.isViterbiProb()) {
                newInst.setValue(attributeCounter, this.viterbiScore.get(k).doubleValue());
                ++attributeCounter;
            }
            if (this.isFwdProb()) {
                newInst.setValue(attributeCounter, this.fwdScore.get(k).doubleValue());
                ++attributeCounter;
            }
            if (!this.isAllProb()) continue;
            List<Double> scores = this.allScore.get(k);
            double[] probs = new double[scores.size()];
            if (this.isAllProbOnly()) {
                for (int n = 0; n < scores.size(); ++n) {
                    probs[n] = scores.get(n);
                }
                probs = Utils.logs2probs((double[])probs);
                Utils.normalize((double[])probs);
            }
            for (int j = 0; j < scores.size(); ++j) {
                if (!this.isAllProbOnly()) {
                    newInst.setValue(attributeCounter, scores.get(j).doubleValue());
                } else {
                    newInst.setValue(attributeCounter, probs[j]);
                }
                ++attributeCounter;
            }
        }
        transformed.add((Instance)newInst);
        newInst = null;
        return transformed;
    }

    @Override
    public Instances createPropositionalisedInstancesFormat(Instances oldInstances) {
        Attribute tempAttribute;
        Alphabet usedAlphabet = null;
        int numNonClassAttributes = 0;
        if (this.profileHMM != null) {
            if (usedAlphabet == null) {
                usedAlphabet = this.profileHMM.getAlphabet();
            }
            if (!this.noBasic) {
                numNonClassAttributes += this.profileHMM.getNumberMatchStates() * 2 - 1;
            }
            if (this.isViterbiProb()) {
                ++numNonClassAttributes;
            }
            if (this.isFwdProb()) {
                ++numNonClassAttributes;
            }
            if (this.isAllProb()) {
                numNonClassAttributes += this.profileHMM.getNumberMatchStates() * 3 - 5;
            }
        }
        FastVector attInfo = new FastVector(numNonClassAttributes + 1);
        FastVector my_nominal_values = new FastVector();
        if (!this.noBasic) {
            for (int i = 0; i < usedAlphabet.alphabetSize(); ++i) {
                my_nominal_values.addElement((Object)usedAlphabet.getSymbolAtIndex(i));
            }
            my_nominal_values.addElement((Object)"-");
        }
        FastVector my_nominal_class_values = new FastVector();
        for (int i = 0; i < oldInstances.numClasses(); ++i) {
            my_nominal_class_values.addElement((Object)oldInstances.classAttribute().value(i));
        }
        int counter = 0;
        String tempAttributeName = "";
        if (!this.noBasic) {
            int numberOfAttributes = 0;
            if (this.profileHMM != null) {
                numberOfAttributes = this.profileHMM.getNumberMatchStates() * 2 - 1;
            }
            for (int j = 0; j < numberOfAttributes; ++j) {
                if (j % 2 == 0) {
                    tempAttributeName = j == 0 || j == numberOfAttributes - 1 ? "Match" + counter : "Match_Delete" + counter;
                    tempAttribute = new Attribute(tempAttributeName, (List)my_nominal_values);
                    attInfo.addElement((Object)tempAttribute);
                    continue;
                }
                tempAttributeName = "Insert" + counter;
                tempAttribute = new Attribute(tempAttributeName);
                attInfo.addElement((Object)tempAttribute);
                ++counter;
            }
        }
        if (this.isViterbiProb()) {
            tempAttribute = new Attribute("ViterbiScore");
            attInfo.addElement((Object)tempAttribute);
        }
        if (this.isFwdProb()) {
            tempAttribute = new Attribute("ForwardScore");
            attInfo.addElement((Object)tempAttribute);
        }
        if (this.isAllProb()) {
            int j;
            for (j = 1; j < this.profileHMM.getNumberMatchStates() - 1; ++j) {
                tempAttribute = new Attribute("Score4Match" + j);
                attInfo.addElement((Object)tempAttribute);
            }
            for (j = 0; j < this.profileHMM.getNumberMatchStates() - 1; ++j) {
                tempAttribute = new Attribute("Score4Insert" + j);
                attInfo.addElement((Object)tempAttribute);
            }
            for (j = 0; j < this.profileHMM.getNumberMatchStates() - 2; ++j) {
                tempAttribute = new Attribute("Score4Delete" + j);
                attInfo.addElement((Object)tempAttribute);
            }
        }
        counter = 0;
        tempAttribute = new Attribute("class", (List)my_nominal_class_values);
        attInfo.addElement((Object)tempAttribute);
        Instances transformed = new Instances(oldInstances.relationName() + "_propositionalizedSingleHMM", (ArrayList)attInfo, 1);
        transformed.setClassIndex(numNonClassAttributes);
        return transformed;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.initClassifier(data);
        int iteration = 1;
        do {
            this.next(iteration);
            ++iteration;
        } while (!this.fullyConverged());
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        int index;
        double[] dist = this.distributionForInstance(instance);
        double result = dist[index = Utils.maxIndex((double[])dist)] == 0.0 ? Utils.missingValue() : (double)index;
        return result;
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.positiveClassIndex < 0) {
            throw new Exception("no pure PHMM classification possible");
        }
        double[] distribution = new double[2];
        if (this.profileHMM == null) {
            for (int i = 0; i < distribution.length; ++i) {
                distribution[i] = 0.0;
            }
            return distribution;
        }
        String testSequence = instance.stringValue(instance.attribute(this.sequenceIndex));
        if (this.getRestrictSequenceLength() != -1 && testSequence.length() > this.getRestrictSequenceLength()) {
            testSequence = testSequence.substring(0, this.getRestrictSequenceLength());
        }
        ForwardAlgorithm fwd = new ForwardAlgorithm(this.profileHMM, testSequence);
        fwd.calculateForward();
        FastVector attInfo = new FastVector(2);
        FastVector classInfo = new FastVector(2);
        for (int i = 0; i < this.preFiltered.numClasses(); ++i) {
            classInfo.addElement((Object)this.preFiltered.classAttribute().value(i));
            if (i != 2) continue;
            throw new Exception("Only on binary datasets");
        }
        Attribute tempAttribute1 = new Attribute("score");
        attInfo.addElement((Object)tempAttribute1);
        Attribute tempAttribute2 = new Attribute("class", (List)classInfo);
        attInfo.addElement((Object)tempAttribute2);
        Instances instancesLogistic = new Instances("logistic", (ArrayList)attInfo, 1);
        instancesLogistic.setClassIndex(1);
        DenseInstance newInst = new DenseInstance(instancesLogistic.numAttributes());
        newInst.setDataset(instancesLogistic);
        newInst.setClassValue(Utils.missingValue());
        newInst.setValue(0, fwd.getScore());
        return this.logistic.distributionForInstance((Instance)newInst);
    }

    private void calibrateClassificationClassifier(Instances data) throws Exception {
        DenseInstance newInst;
        ForwardAlgorithm fwd;
        String sequence;
        int i;
        if (this.positiveClassIndex < 0) {
            return;
        }
        this.logistic = new Logistic();
        FastVector attInfo = new FastVector(2);
        FastVector classInfo = new FastVector(2);
        for (int i2 = 0; i2 < this.preFiltered.numClasses(); ++i2) {
            classInfo.addElement((Object)this.preFiltered.classAttribute().value(i2));
            if (i2 != 2) continue;
            throw new Exception("Calibration method only works on binary datasets");
        }
        Attribute tempAttribute1 = new Attribute("score");
        attInfo.addElement((Object)tempAttribute1);
        Attribute tempAttribute2 = new Attribute("class", (List)classInfo);
        attInfo.addElement((Object)tempAttribute2);
        Instances instancesLogistic = new Instances("logistic", (ArrayList)attInfo, 1);
        instancesLogistic.setClassIndex(1);
        for (i = 0; i < data.numInstances(); ++i) {
            sequence = data.instance(i).stringValue(data.instance(i).attribute(this.sequenceIndex));
            fwd = new ForwardAlgorithm(this.profileHMM, sequence);
            fwd.calculateForward();
            newInst = new DenseInstance(instancesLogistic.numAttributes());
            newInst.setDataset(instancesLogistic);
            newInst.setClassValue((double)this.positiveClassIndex);
            newInst.setValue(0, fwd.getScore());
            instancesLogistic.add((Instance)newInst);
            newInst = null;
            fwd = null;
        }
        for (i = 0; i < data.numInstances(); ++i) {
            sequence = IterativeProfileHMMClassifierSingleHMM.pertubate(data.instance(i).stringValue(data.instance(i).attribute(this.sequenceIndex)), 1);
            fwd = new ForwardAlgorithm(this.profileHMM, sequence);
            fwd.calculateForward();
            newInst = new DenseInstance(instancesLogistic.numAttributes());
            newInst.setDataset(instancesLogistic);
            double negativeClassIndex = 0.0;
            if (this.positiveClassIndex == 0) {
                negativeClassIndex = 1.0;
            }
            newInst.setClassValue(negativeClassIndex);
            newInst.setValue(0, fwd.getScore());
            instancesLogistic.add((Instance)newInst);
            newInst = null;
            fwd = null;
        }
        this.logistic.buildClassifier(instancesLogistic);
    }

    private static String pertubate(String realSequence, int seed) {
        String mixedUpSequence = "";
        Random randGen = new Random(seed);
        boolean[] letter = new boolean[realSequence.length()];
        for (int i = 0; i < letter.length; ++i) {
            letter[i] = false;
        }
        do {
            int index;
            if (letter[index = randGen.nextInt(realSequence.length())]) continue;
            mixedUpSequence = mixedUpSequence + realSequence.charAt(index);
            letter[index] = true;
        } while (mixedUpSequence.length() < realSequence.length());
        return mixedUpSequence;
    }

    private int determineColumns(Instances inst) {
        int average = 0;
        for (int i = 0; i < inst.numInstances(); ++i) {
            average += inst.instance(i).stringValue(inst.instance(i).attribute(this.sequenceIndex)).length();
        }
        return Math.round(average / inst.numInstances());
    }

    @Override
    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
    }

    @Override
    public String toString() {
        if (this.profileHMM == null) {
            return "No model built yet.";
        }
        String result = "";
        result = result + "\nOne class classifier ProfileHMM:\n  model for class:    \t" + this.positiveClassIndex + "\n  match states:    \t" + this.profileHMM.getNumberMatchStates() + "\n  iterations in BW:\t" + this.numIterationPerClass + "\n  final score:    \t" + this.logLikelihoodOfPHMM + "\n  initial score:\t" + this.initiallogLikelihoodOfPHMM + "\n";
        return result;
    }

    public static void main(String[] argv) {
        try {
            System.out.println(Evaluation.evaluateModel((Classifier)new IterativeProfileHMMClassifierSingleHMM(), (String[])argv));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getRevision() {
        return "1.0";
    }

    @Override
    public void initClassifier(Instances data) throws Exception {
        int i;
        this.getCapabilities().testWithFail(data);
        data.deleteWithMissingClass();
        if (this.positiveClassIndex >= 0) {
            this.preFiltered = new Instances(data);
            RemoveWithValues filter = new RemoveWithValues();
            String[] options = new String[]{"-L", this.positiveClassIndex + 1 + "", "-C", data.classIndex() + 1 + "", "-V"};
            filter.setInputFormat(data);
            filter.setOptions(options);
            this.filtered = Filter.useFilter((Instances)data, (Filter)filter);
            data = new Instances(this.filtered);
            data.setRelationName(this.preFiltered.relationName());
        }
        if (data.numAttributes() > 2) {
            throw new Exception("Dataset has to consist of exactly one string attribute and a class attribute");
        }
        this.sequenceIndex = data.classIndex() == 1 ? 0 : 1;
        this.iteration = 0;
        int numInstances = data.numInstances();
        this.trainingClassDistribution = new double[data.numClasses()];
        for (i = 0; i < data.numClasses(); ++i) {
            this.trainingClassDistribution[i] = 0.0;
        }
        for (i = 0; i < numInstances; ++i) {
            int n = (int)data.instance(i).classValue();
            this.trainingClassDistribution[n] = this.trainingClassDistribution[n] + 1.0;
        }
        Utils.normalize((double[])this.trainingClassDistribution);
        if (numInstances == 0) {
            this.profileHMM = null;
            this.converged.add(0, true);
            this.numIterationPerClass = -1;
        } else {
            this.allTrainingSequences = new String[data.numInstances()];
            for (int k = 0; k < data.numInstances(); ++k) {
                String sequence = data.instance(k).stringValue(data.instance(k).attribute(this.sequenceIndex));
                if (this.getRestrictSequenceLength() != -1 && sequence.length() > this.getRestrictSequenceLength()) {
                    sequence = sequence.substring(0, this.getRestrictSequenceLength());
                }
                this.allTrainingSequences[k] = sequence;
            }
            if (this.backDist == -1) {
                if (this.getRestrictSequenceLength() != -1) {
                    this.profileHMM = new ProfileHMM(this.getRestrictSequenceLength(), this.getAlphabet(), this.useNullModel, !this.transitionsEmissionsNotInLog);
                } else if (this.getRestrictMatchColumns() != -1) {
                    this.profileHMM = new ProfileHMM(this.getRestrictMatchColumns(), this.getAlphabet(), this.useNullModel, !this.transitionsEmissionsNotInLog);
                } else {
                    int matchColumns = this.determineColumns(data);
                    this.profileHMM = new ProfileHMM(matchColumns, this.getAlphabet(), this.useNullModel, !this.transitionsEmissionsNotInLog);
                }
            } else {
                String[] sequencesForBackgroundDist = null;
                if (this.backDist == 0) {
                    sequencesForBackgroundDist = this.allTrainingSequences;
                } else {
                    if (this.backDist == 2) {
                        sequencesForBackgroundDist = new String[this.preFiltered.numInstances()];
                        for (int k = 0; k < this.preFiltered.numInstances(); ++k) {
                            String sequence = this.preFiltered.instance(k).stringValue(this.preFiltered.instance(k).attribute(this.sequenceIndex));
                            if (this.getRestrictSequenceLength() != -1 && sequence.length() > this.getRestrictSequenceLength()) {
                                sequence = sequence.substring(0, this.getRestrictSequenceLength());
                            }
                            sequencesForBackgroundDist[k] = sequence;
                        }
                    }
                    if (this.backDist == 1 && this.positiveClassIndex >= 0) {
                        RemoveWithValues filter = new RemoveWithValues();
                        String[] options = new String[]{"-L", this.positiveClassIndex + 1 + "", "-C", data.classIndex() + 1 + ""};
                        filter.setInputFormat(this.preFiltered);
                        filter.setOptions(options);
                        Instances filteredNeg = Filter.useFilter((Instances)this.preFiltered, (Filter)filter);
                        Instances negOnly = new Instances(filteredNeg);
                        negOnly.setRelationName(this.preFiltered.relationName());
                        sequencesForBackgroundDist = new String[negOnly.numInstances()];
                        for (int k = 0; k < negOnly.numInstances(); ++k) {
                            String sequence = negOnly.instance(k).stringValue(negOnly.instance(k).attribute(this.sequenceIndex));
                            if (this.getRestrictSequenceLength() != -1 && sequence.length() > this.getRestrictSequenceLength()) {
                                sequence = sequence.substring(0, this.getRestrictSequenceLength());
                            }
                            sequencesForBackgroundDist[k] = sequence;
                        }
                    }
                }
                if (this.getRestrictSequenceLength() != -1) {
                    this.profileHMM = new ProfileHMM(this.getRestrictSequenceLength(), this.getAlphabet(), this.useNullModel, true, sequencesForBackgroundDist, !this.transitionsEmissionsNotInLog);
                } else if (this.getRestrictMatchColumns() != -1) {
                    this.profileHMM = new ProfileHMM(this.getRestrictMatchColumns(), this.getAlphabet(), this.useNullModel, true, sequencesForBackgroundDist, !this.transitionsEmissionsNotInLog);
                } else {
                    int matchColumns = this.determineColumns(data);
                    this.profileHMM = new ProfileHMM(matchColumns, this.getAlphabet(), this.useNullModel, true, sequencesForBackgroundDist, !this.transitionsEmissionsNotInLog);
                }
            }
            this.converged.add(0, false);
            this.logLikelihoodOfPHMM = Double.NEGATIVE_INFINITY;
            this.initiallogLikelihoodOfPHMM = Double.NEGATIVE_INFINITY;
            this.oldLogLikelihoodOfPHMM = Double.NEGATIVE_INFINITY;
            this.numIterationPerClass = -1;
        }
    }

    @Override
    public void next(int iteration) throws Exception {
        BaumWelchLearner bwl = null;
        this.iteration = iteration;
        if (this.allTrainingSequences.length != 0 && !((Boolean)this.converged.get(0)).booleanValue()) {
            double logLikelihood;
            bwl = new BaumWelchLearner(this.allTrainingSequences, this.logLikelihoodThreshold, this.profileHMM, this.learnInsertEmissions, this.isMemorySensitive());
            if (this.getBaumWelchOption() == 1) {
                bwl.setAverageLikelihoodOverSequenceNumber(true);
            }
            if (this.getBaumWelchOption() == 2) {
                bwl.setAverageLikelihoodOverResidueNumber(true);
            }
            ProfileHMM learnt = bwl.learnFast();
            this.logLikelihoodOfPHMM = logLikelihood = bwl.getLogLikelihood();
            if (iteration == 1) {
                this.initiallogLikelihoodOfPHMM = bwl.getInitialLogLikelihood();
            }
            this.profileHMM = learnt;
            this.numIterationPerClass = iteration;
            if (Math.abs(this.oldLogLikelihoodOfPHMM - logLikelihood) <= this.logLikelihoodThreshold) {
                this.converged.set(0, true);
                this.numIterationPerClass = iteration;
            }
            this.oldLogLikelihoodOfPHMM = bwl.getLogLikelihood();
        }
        this.calibrateClassificationClassifier(this.filtered);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return this.clone();
    }

    @Override
    public boolean fullyConverged() {
        if (this.converged.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.converged.size(); ++i) {
            if (((Boolean)this.converged.get(i)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getIteration() {
        return this.iteration;
    }

    @Override
    public void resetAllTrainingSequences() {
        this.allTrainingSequences = null;
    }

    public int getClassIndexToKeep() {
        return this.positiveClassIndex;
    }

    public void setClassIndexToKeep(int classIndexToKeep) {
        this.positiveClassIndex = classIndexToKeep;
    }

    public Instances getOneClassClassificationArff() {
        return this.filtered;
    }

    public ProfileHMM getProfileHMM() {
        return this.profileHMM;
    }

    public void setProfileHMM(ProfileHMM profileHMM) {
        this.profileHMM = profileHMM;
    }

    @Override
    public ProfileHMM getProfileHMM(int i) {
        return this.profileHMM;
    }

    @Override
    public void setProfileHMM(ProfileHMM profileHMM, int i) {
        this.profileHMM = profileHMM;
    }

    public static long getSerialVersionUID() {
        return 3134763907535654753L;
    }

    public double[][] getSufficientStats(boolean includeInserts, String[] sequences) throws IllegalSymbolException, InvalidStructureException, InvalidViterbiPathException, NumericStabilityException {
        double[][] allStats = new double[sequences.length][this.profileHMM.getNumberMatchStates() * this.profileHMM.getAlphabet().alphabetSize()];
        for (int i = 0; i < sequences.length; ++i) {
            SufficientEmissionStatistics stats = new SufficientEmissionStatistics(this.profileHMM, includeInserts);
            allStats[i] = stats.getStats(sequences[i]);
        }
        return allStats;
    }
}

