/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.sequence.core;

import weka.classifiers.sequence.core.Alphabet;
import weka.classifiers.sequence.core.IllegalSymbolException;
import weka.classifiers.sequence.core.NullModel;
import weka.classifiers.sequence.core.NumericStabilityException;
import weka.classifiers.sequence.core.SimpleDistribution;
import weka.core.Utils;

public class BackgroundDistNullModel
extends NullModel {
    private static final long serialVersionUID = -2547427871055879202L;

    public BackgroundDistNullModel(boolean useLogSpace, Alphabet alphabet) {
        super(useLogSpace, alphabet);
    }

    public BackgroundDistNullModel(boolean useLogSpace, Alphabet alphabet, String[] sequences) throws IllegalSymbolException, NumericStabilityException {
        super(useLogSpace, alphabet);
        int i;
        this.distribution = new SimpleDistribution(alphabet, useLogSpace);
        double[] countSequenceElements = new double[alphabet.alphabetSize()];
        for (i = 0; i < countSequenceElements.length; ++i) {
            countSequenceElements[i] = 1.0;
        }
        for (i = 0; i < sequences.length; ++i) {
            String sequence = sequences[i];
            for (int j = 0; j < sequence.length(); ++j) {
                int n = alphabet.indexOfAlphabetSymbol(sequence.charAt(j) + "");
                countSequenceElements[n] = countSequenceElements[n] + 1.0;
            }
        }
        Utils.normalize((double[])countSequenceElements);
        if (useLogSpace) {
            for (i = 0; i < countSequenceElements.length; ++i) {
                countSequenceElements[i] = countSequenceElements[i] == 0.0 ? Double.NEGATIVE_INFINITY : (countSequenceElements[i] == 1.0 ? 0.0 : Math.log(countSequenceElements[i]));
            }
        }
        ((SimpleDistribution)this.distribution).setProbWithArray(countSequenceElements);
    }
}

