/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.sequence.core;

import weka.classifiers.sequence.core.DeleteState;
import weka.classifiers.sequence.core.DynamicProgAlgorithms;
import weka.classifiers.sequence.core.EmissionState;
import weka.classifiers.sequence.core.IllegalSymbolException;
import weka.classifiers.sequence.core.InvalidStructureException;
import weka.classifiers.sequence.core.InvalidViterbiPathException;
import weka.classifiers.sequence.core.ProfileHMM;

public class BackwardAlgorithm
extends DynamicProgAlgorithms {
    private static final long serialVersionUID = 7601518046923307693L;

    public BackwardAlgorithm(ProfileHMM net, String sequence) {
        super(net, sequence);
    }

    public void calculateBackward() throws IllegalSymbolException, InvalidStructureException, InvalidViterbiPathException {
        this.matchMatrix = new double[this.net.getNumberMatchStates() + 1][this.sequence.length()];
        this.insertMatrix = new double[this.net.getNumberMatchStates() + 1][this.sequence.length()];
        this.deleteMatrix = new double[this.net.getNumberMatchStates() + 1][this.sequence.length()];
        this.initialiseMatrices();
        this.recurse();
        this.terminate();
    }

    private void terminate() throws IllegalSymbolException, InvalidStructureException {
        double emissionProb = this.calculateLogEmissionProbability(this.net.getMatchState(0), 0);
        this.score = this.matchMatrix[0][0] + emissionProb;
    }

    private void recurse() throws IllegalSymbolException, InvalidStructureException {
        for (int j = this.net.getNumberMatchStates() - 2; j >= 0; --j) {
            for (int i = this.sequence.length() - 3; i >= 0; --i) {
                if (j <= this.net.getNumberMatchStates() - 4) {
                    this.updateDeleteMatrix(j, i);
                }
                this.updateInsertMatrix(j, i);
                this.updateMatchMatrix(j, i);
            }
        }
    }

    private void updateDeleteMatrix(int j, int i) throws InvalidStructureException, IllegalSymbolException {
        DeleteState deletej = this.net.getDeleteState(j);
        DeleteState deletejPlus1 = this.net.getDeleteState(j + 1);
        EmissionState matchjPlus2 = this.net.getMatchState(j + 2);
        double deletejToMatchjPlus2 = this.getIncomingTransitionProbTo(deletej, matchjPlus2);
        double deletejToDeletejPlus1 = this.getIncomingTransitionProbTo(deletej, deletejPlus1);
        double emissionProb = this.calculateLogEmissionProbability(matchjPlus2, i + 1);
        double matchScore = this.matchMatrix[j + 2][i + 1];
        double deleteScore = this.deleteMatrix[j + 1][i];
        this.deleteMatrix[j][i] = BackwardAlgorithm.logplus(deletejToMatchjPlus2 + matchScore + emissionProb, deletejToDeletejPlus1 + deleteScore);
    }

    private void updateInsertMatrix(int j, int i) throws InvalidStructureException, IllegalSymbolException {
        EmissionState insertj = this.net.getInsertState(j);
        EmissionState matchjPlus1 = this.net.getMatchState(j + 1);
        double insertjToMatchPlus1 = this.getIncomingTransitionProbTo(insertj, matchjPlus1);
        double insertjToInsertj = this.getIncomingTransitionProbTo(insertj, insertj);
        double matchEmissionProb = this.calculateLogEmissionProbability(matchjPlus1, i + 1);
        double insertEmissionProb = this.calculateLogEmissionProbability(insertj, i + 1);
        double matchScore = this.matchMatrix[j + 1][i + 1];
        double insertScore = this.insertMatrix[j][i + 1];
        this.insertMatrix[j][i] = BackwardAlgorithm.logplus(insertjToMatchPlus1 + matchScore + matchEmissionProb, insertjToInsertj + insertScore + insertEmissionProb);
    }

    private void updateMatchMatrix(int j, int i) throws InvalidStructureException, IllegalSymbolException {
        EmissionState matchj = this.net.getMatchState(j);
        EmissionState matchjPlus1 = this.net.getMatchState(j + 1);
        EmissionState insertj = this.net.getInsertState(j);
        double matchjToMatchjPlus1 = this.getIncomingTransitionProbTo(matchj, matchjPlus1);
        double matchjToInsertj = this.getIncomingTransitionProbTo(matchj, insertj);
        double matchEmissionProb = this.calculateLogEmissionProbability(matchjPlus1, i + 1);
        double insertEmissionProb = this.calculateLogEmissionProbability(insertj, i + 1);
        double matchScore = this.matchMatrix[j + 1][i + 1];
        double insertScore = this.insertMatrix[j][i + 1];
        if (j <= this.net.getNumberMatchStates() - 3) {
            DeleteState deletej = this.net.getDeleteState(j);
            double matchjToDeletej = this.getIncomingTransitionProbTo(matchj, deletej);
            double deleteScore = this.deleteMatrix[j][i];
            double logApproxmitionHelper = Double.NEGATIVE_INFINITY;
            logApproxmitionHelper = BackwardAlgorithm.logplus(logApproxmitionHelper, matchjToMatchjPlus1 + matchScore + matchEmissionProb);
            logApproxmitionHelper = BackwardAlgorithm.logplus(logApproxmitionHelper, matchjToInsertj + insertScore + insertEmissionProb);
            this.matchMatrix[j][i] = logApproxmitionHelper = BackwardAlgorithm.logplus(logApproxmitionHelper, matchjToDeletej + deleteScore);
        } else {
            this.matchMatrix[j][i] = BackwardAlgorithm.logplus(matchjToMatchjPlus1 + matchScore + matchEmissionProb, matchjToInsertj + insertScore + insertEmissionProb);
        }
    }

    private void initialiseMatrices() throws IllegalSymbolException, InvalidStructureException {
        for (int i = 0; i < this.net.getNumberMatchStates() + 1; ++i) {
            for (int j = 0; j < this.sequence.length(); ++j) {
                this.matchMatrix[i][j] = Double.NEGATIVE_INFINITY;
                this.deleteMatrix[i][j] = Double.NEGATIVE_INFINITY;
                this.insertMatrix[i][j] = Double.NEGATIVE_INFINITY;
            }
        }
        this.matchMatrix[this.net.getNumberMatchStates()][this.sequence.length() - 1] = 0.0;
        this.matchMatrix[this.net.getNumberMatchStates() - 1][this.sequence.length() - 2] = 0.0;
        EmissionState matchjPlus2 = this.net.getMatchState(this.net.getNumberMatchStates() - 1);
        DeleteState deletej = this.net.getDeleteState(this.net.getNumberMatchStates() - 3);
        double deletejToMatchjPlus2 = this.getIncomingTransitionProbTo(deletej, matchjPlus2);
        double emissionProb = this.calculateLogEmissionProbability(matchjPlus2, this.sequence.length() - 2);
        double matchScore = this.matchMatrix[this.net.getNumberMatchStates() - 1][this.sequence.length() - 2];
        this.deleteMatrix[this.net.getNumberMatchStates() - 3][this.sequence.length() - 3] = deletejToMatchjPlus2 + emissionProb + matchScore;
    }
}

