/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.sequence.core;

import weka.classifiers.sequence.core.Alphabet;
import weka.classifiers.sequence.core.IllegalSymbolException;

public class ExtendedProteinAlphabet
extends Alphabet {
    private static final long serialVersionUID = 3357731593569839979L;

    @Override
    public int alphabetSize() {
        return 24;
    }

    @Override
    public int indexOfAlphabetSymbol(String symbolString) throws IllegalSymbolException {
        char symbol = symbolString.charAt(0);
        int incorrectIndex = symbol - 48 - 17;
        if (incorrectIndex < 0 || incorrectIndex > 25 || incorrectIndex == 9 || incorrectIndex == 14) {
            throw new IllegalSymbolException("Letter not in alphabet: " + symbolString + " " + incorrectIndex);
        }
        int indexValue = this.getCorrectedIndex(incorrectIndex);
        return indexValue;
    }

    @Override
    public String toString() {
        String output = "";
        for (int i = 0; i < this.alphabetSize(); ++i) {
            if (i > 0) {
                output = output + " ";
            }
            output = output + this.getCorrectedSymbol(i) + "";
        }
        return output;
    }

    @Override
    public String getSymbolAtIndex(int index) {
        return this.getCorrectedSymbol(index) + "";
    }

    private int getCorrectedIndex(int incorrectIndex) {
        if (incorrectIndex < 9) {
            return incorrectIndex;
        }
        if (incorrectIndex < 14) {
            return incorrectIndex - 1;
        }
        return incorrectIndex - 2;
    }

    private char getCorrectedSymbol(int incorrectIndex) {
        int correctIndex = incorrectIndex + 17 + 48;
        if (incorrectIndex < 9) {
            return (char)correctIndex;
        }
        if (incorrectIndex < 13) {
            return (char)(correctIndex + 1);
        }
        return (char)(correctIndex + 2);
    }
}

