/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.sequence.core;

import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import weka.classifiers.sequence.core.InvalidStructureException;
import weka.classifiers.sequence.core.Transition;

public class State
implements Serializable {
    private static final long serialVersionUID = 6471794539900349365L;
    protected List<Transition> incoming;
    protected List<Transition> outgoing;
    protected String name;
    protected int id;

    public State() {
    }

    public State(String name, int id) {
        this.name = name;
        this.id = id;
        this.incoming = new Vector<Transition>();
        this.outgoing = new Vector<Transition>();
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public String getFullNameId() {
        return this.name + this.id;
    }

    public void addOutgoingTransition(Transition transition) throws InvalidStructureException {
        if (transition.getStart() != this) {
            throw new InvalidStructureException("transition start doesn't equal this state");
        }
        this.outgoing.add(transition);
    }

    public void addIncomingTransition(Transition transition) throws InvalidStructureException {
        if (transition.getEnd() != this) {
            throw new InvalidStructureException("transition end doesn't equal this state");
        }
        this.incoming.add(transition);
    }

    public double getIncomingTransitionProbFrom(State from) throws InvalidStructureException {
        for (int i = 0; i < this.incoming.size(); ++i) {
            Transition actual = this.incoming.get(i);
            State toTest = actual.getStart();
            if (!toTest.equals(from)) continue;
            return actual.getProbability();
        }
        throw new InvalidStructureException("There is no transition from the specified state into this one");
    }

    public double getIncomingTransitionProbTo(State to) throws InvalidStructureException {
        for (int i = 0; i < this.outgoing.size(); ++i) {
            Transition actual = this.outgoing.get(i);
            State toTest = actual.getEnd();
            if (!toTest.equals(to)) continue;
            return actual.getProbability();
        }
        throw new InvalidStructureException("There is no transition from this state to the specified one");
    }

    public boolean equals(State toCompare) {
        return this.id == toCompare.id && this.name.equals(toCompare.name);
    }

    public List<Transition> getAllOutgoing() {
        return this.outgoing;
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append(this.getFullNameId() + ": ");
        for (int i = 0; i < this.outgoing.size(); ++i) {
            Transition actual = this.outgoing.get(i);
            output.append(((Object)actual).toString() + " ");
        }
        output.append("\n");
        return output.toString();
    }
}

