/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NumericTransform;

public class NumericTransformTest
extends AbstractFilterTest {
    private static final double TOLERANCE = 0.001;

    public NumericTransformTest(String name) {
        super(name);
    }

    public Filter getFilter() {
        return this.getFilter("first-last");
    }

    public Filter getFilter(String rangelist) {
        try {
            NumericTransform af = new NumericTransform();
            af.setAttributeIndices(rangelist);
            return af;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            NumericTransformTest.fail((String)("Exception setting attribute range: " + rangelist + "\n" + ex.getMessage()));
            return null;
        }
    }

    public void testDefault() {
        Instances result = this.useFilter();
        NumericTransformTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        NumericTransformTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        for (int i = 0; i < result.numInstances(); ++i) {
            for (int j = 0; j < result.numAttributes(); ++j) {
                if (this.m_Instances.instance(i).isMissing(j)) {
                    NumericTransformTest.assertTrue((boolean)result.instance(i).isMissing(j));
                    continue;
                }
                if (result.attribute(j).isNumeric()) {
                    NumericTransformTest.assertEquals((String)"Value should be same as Math.abs()", (double)Math.abs(this.m_Instances.instance(i).value(j)), (double)result.instance(i).value(j), (double)0.001);
                    continue;
                }
                NumericTransformTest.assertEquals((String)"Value shouldn't have changed", (double)this.m_Instances.instance(i).value(j), (double)result.instance(i).value(j), (double)0.001);
            }
        }
    }

    public void testInverted() {
        this.m_Filter = this.getFilter("1-3");
        ((NumericTransform)this.m_Filter).setInvertSelection(true);
        Instances result = this.useFilter();
        NumericTransformTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        NumericTransformTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        for (int i = 0; i < result.numInstances(); ++i) {
            for (int j = 0; j < result.numAttributes(); ++j) {
                if (this.m_Instances.instance(i).isMissing(j)) {
                    NumericTransformTest.assertTrue((boolean)result.instance(i).isMissing(j));
                    continue;
                }
                if (result.attribute(j).isNumeric() && j >= 3) {
                    NumericTransformTest.assertEquals((String)"Value should be same as Math.abs()", (double)Math.abs(this.m_Instances.instance(i).value(j)), (double)result.instance(i).value(j), (double)0.001);
                    continue;
                }
                NumericTransformTest.assertEquals((String)"Value shouldn't have changed", (double)this.m_Instances.instance(i).value(j), (double)result.instance(i).value(j), (double)0.001);
            }
        }
    }

    public void testClassNameAndMethodName() throws Exception {
        ((NumericTransform)this.m_Filter).setClassName("java.lang.Math");
        ((NumericTransform)this.m_Filter).setMethodName("rint");
        Instances result = this.useFilter();
        NumericTransformTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        NumericTransformTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        for (int i = 0; i < result.numInstances(); ++i) {
            for (int j = 0; j < result.numAttributes(); ++j) {
                if (this.m_Instances.instance(i).isMissing(j)) {
                    NumericTransformTest.assertTrue((boolean)result.instance(i).isMissing(j));
                    continue;
                }
                if (result.attribute(j).isNumeric()) {
                    NumericTransformTest.assertEquals((String)"Value should be same as Math.rint()", (double)Math.rint(this.m_Instances.instance(i).value(j)), (double)result.instance(i).value(j), (double)0.001);
                    continue;
                }
                NumericTransformTest.assertEquals((String)"Value shouldn't have changed", (double)this.m_Instances.instance(i).value(j), (double)result.instance(i).value(j), (double)0.001);
            }
        }
    }

    public static Test suite() {
        return new TestSuite(NumericTransformTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)NumericTransformTest.suite());
    }
}

