/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Attribute;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Obfuscate;

public class ObfuscateTest
extends AbstractFilterTest {
    public ObfuscateTest(String name) {
        super(name);
    }

    public Filter getFilter() {
        return new Obfuscate();
    }

    public void testTypical() {
        Instances result = this.useFilter();
        ObfuscateTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        ObfuscateTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        ObfuscateTest.assertTrue((!this.m_Instances.relationName().equals(result.relationName()) ? 1 : 0) != 0);
        for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
            Attribute inatt = this.m_Instances.attribute(i);
            Attribute outatt = result.attribute(i);
            if (inatt.isString() || inatt.isDate()) continue;
            ObfuscateTest.assertTrue((String)"Attribute names should be changed", (!inatt.name().equals(outatt.name()) ? 1 : 0) != 0);
            if (!inatt.isNominal()) continue;
            ObfuscateTest.assertEquals((String)"Number of nominal values shouldn't change", (int)inatt.numValues(), (int)outatt.numValues());
            for (int j = 0; j < inatt.numValues(); ++j) {
                ObfuscateTest.assertTrue((String)"Nominal labels should be changed", (!inatt.value(j).equals(outatt.value(j)) ? 1 : 0) != 0);
            }
        }
    }

    public static Test suite() {
        return new TestSuite(ObfuscateTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ObfuscateTest.suite());
    }
}

