/*
 * Decompiled with CFR 0.152.
 */
package weka.test;

import java.util.Collections;
import java.util.StringTokenizer;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.core.ClassDiscovery;
import weka.gui.GenericPropertiesCreator;

public class WekaTestSuite
extends TestSuite {
    protected static boolean isValidClassname(String classname) {
        return classname.indexOf("$") == -1;
    }

    protected static Vector getClassnames(String superclass, Vector packages) {
        Vector result = new Vector();
        for (int i = 0; i < packages.size(); ++i) {
            Vector names = ClassDiscovery.find((String)superclass, (String)((String)packages.get(i)));
            for (int n = 0; n < names.size(); ++n) {
                if (!WekaTestSuite.isValidClassname((String)names.get(n))) continue;
                result.add(names.get(n));
            }
        }
        return result;
    }

    protected static Vector getClassnames(String property) {
        Vector<String> result = new Vector<String>();
        try {
            GenericPropertiesCreator gpc = new GenericPropertiesCreator();
            gpc.execute(false);
            String classes = gpc.getOutputProperties().getProperty(property);
            StringTokenizer tok = new StringTokenizer(classes, ",");
            while (tok.hasMoreTokens()) {
                String classname = tok.nextToken();
                if (!WekaTestSuite.isValidClassname(classname)) continue;
                result.add(classname);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    protected static String getTestClassname(String classname) {
        if (!classname.endsWith("Test")) {
            return classname + "Test";
        }
        return classname;
    }

    protected static Class testClassFor(String classname) {
        Class<?> result = null;
        try {
            result = Class.forName(WekaTestSuite.getTestClassname(classname));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected static TestSuite addAll(Vector classnames) {
        TestSuite result = new TestSuite();
        for (int i = 0; i < classnames.size(); ++i) {
            Class tc = WekaTestSuite.testClassFor((String)classnames.get(i));
            if (tc == null) continue;
            result.addTest((Test)new TestSuite(tc));
        }
        return result;
    }

    public static TestSuite addAll(String property) {
        return WekaTestSuite.addAll(WekaTestSuite.getClassnames(property));
    }

    public static TestSuite addAll(String superclass, Vector packages) {
        return WekaTestSuite.addAll(WekaTestSuite.getClassnames(superclass, packages));
    }

    protected static Vector getMissing(Vector classnames) {
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < classnames.size(); ++i) {
            if (WekaTestSuite.testClassFor((String)classnames.get(i)) != null) continue;
            result.add(WekaTestSuite.getTestClassname((String)classnames.get(i)));
        }
        return result;
    }

    public static Vector getMissing(String property) {
        return WekaTestSuite.getMissing(WekaTestSuite.getClassnames(property));
    }

    public static Vector getMissing(String superclass, Vector packages) {
        return WekaTestSuite.getMissing(WekaTestSuite.getClassnames(superclass, packages));
    }

    protected static Test suite(Test t, Vector missing) {
        if (missing.size() > 0) {
            Collections.sort(missing);
            System.out.println("Missing Test classes:");
            for (int i = 0; i < missing.size(); ++i) {
                System.out.println("- " + missing.get(i));
            }
            System.out.println();
        }
        return t;
    }

    public static Test suite(String property) {
        return WekaTestSuite.suite((Test)WekaTestSuite.addAll(property), WekaTestSuite.getMissing(property));
    }

    public static Test suite(String superclass, Vector packages) {
        return WekaTestSuite.suite((Test)WekaTestSuite.addAll(superclass, packages), WekaTestSuite.getMissing(superclass, packages));
    }
}

