/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.pmml.consumer;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import junit.framework.TestCase;
import weka.classifiers.AbstractClassifierTest;
import weka.classifiers.Classifier;
import weka.classifiers.evaluation.EvaluationUtils;
import weka.classifiers.pmml.consumer.PMMLClassifier;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.pmml.PMMLFactory;
import weka.core.pmml.PMMLModel;
import weka.test.Regression;

public abstract class AbstractPMMLClassifierTest
extends TestCase {
    protected FastVector m_modelNames = new FastVector();
    protected FastVector m_dataSetNames = new FastVector();

    public AbstractPMMLClassifierTest(String name) {
        super(name);
    }

    public Instances getData(String name) {
        Instances elnino = null;
        try {
            elnino = new Instances((Reader)new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream("weka/classifiers/pmml/data/" + name))));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return elnino;
    }

    public PMMLClassifier getClassifier(String name) {
        PMMLClassifier regression = null;
        try {
            PMMLModel model = PMMLFactory.getPMMLModel((InputStream)new BufferedInputStream(ClassLoader.getSystemResourceAsStream("weka/classifiers/pmml/data/" + name)));
            regression = (PMMLClassifier)model;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return regression;
    }

    public void testRegression() throws Exception {
        PMMLClassifier classifier = null;
        Instances testData = null;
        EvaluationUtils evalUtils = null;
        Regression reg = new Regression(((Object)((Object)this)).getClass());
        FastVector predictions = null;
        boolean success = false;
        int i = 0;
        while (i < this.m_modelNames.size()) {
            block9: {
                classifier = this.getClassifier((String)this.m_modelNames.elementAt(i));
                testData = this.getData((String)this.m_dataSetNames.elementAt(i));
                evalUtils = new EvaluationUtils();
                try {
                    String className = classifier.getMiningSchema().getFieldsAsInstances().classAttribute().name();
                    Attribute classAtt = testData.attribute(className);
                    testData.setClass(classAtt);
                    predictions = evalUtils.getTestPredictions((Classifier)classifier, testData);
                    success = true;
                    String predsString = AbstractClassifierTest.predictionsToString(predictions);
                    reg.println(predsString);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    String msg = ex.getMessage().toLowerCase();
                    if (msg.indexOf("not in classpath") <= -1) break block9;
                    return;
                }
            }
            ++i;
        }
        if (!success) {
            AbstractPMMLClassifierTest.fail((String)"Problem during regression testing: no successful predictions generated");
        }
        try {
            String diff = reg.diff();
            if (diff == null) {
                System.err.println("Warning: No reference available, creating.");
            } else if (!diff.equals("")) {
                AbstractPMMLClassifierTest.fail((String)("Regression test failed. Difference:\n" + diff));
            }
        }
        catch (IOException ex) {
            AbstractPMMLClassifierTest.fail((String)("Problem during regression testing.\n" + ex));
        }
    }
}

