/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.AbstractTimeSeriesFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.TimeSeriesTranslate;

public class TimeSeriesTranslateTest
extends AbstractTimeSeriesFilterTest {
    public TimeSeriesTranslateTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        return this.getFilter("2-3");
    }

    public Filter getFilter(String rangelist) {
        TimeSeriesTranslate af = new TimeSeriesTranslate();
        af.setAttributeIndices(rangelist);
        af.setFillWithMissing(false);
        return af;
    }

    public void testInverted() {
        this.m_Filter = this.getFilter("1,4,2-3");
        ((TimeSeriesTranslate)this.m_Filter).setInvertSelection(true);
        Instances result = this.useFilter();
        TimeSeriesTranslateTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        TimeSeriesTranslateTest.assertEquals((int)(this.m_Instances.numInstances() - 1), (int)result.numInstances());
        int i = 0;
        while (i < result.numInstances()) {
            Instance in = this.m_Instances.instance(i + 1);
            Instance out = result.instance(i);
            int j = 0;
            while (j < result.numAttributes()) {
                if (j != 4 && j != 5 && j != 6) {
                    if (in.isMissing(j)) {
                        TimeSeriesTranslateTest.assertTrue((String)"Nonselected missing values should pass through", (boolean)out.isMissing(j));
                    } else if (result.attribute(j).isString()) {
                        TimeSeriesTranslateTest.assertEquals((String)("Nonselected attributes shouldn't change. " + in + " --> " + out), (String)this.m_Instances.attribute(j).value((int)in.value(j)), (String)result.attribute(j).value((int)out.value(j)));
                    } else {
                        TimeSeriesTranslateTest.assertEquals((String)("Nonselected attributes shouldn't change. " + in + " --> " + out), (double)in.value(j), (double)out.value(j), (double)0.001);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public static Test suite() {
        return new TestSuite(TimeSeriesTranslateTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TimeSeriesTranslateTest.suite());
    }
}

