/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.io.IOException;
import junit.framework.TestCase;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeSelection;
import weka.attributeSelection.CheckAttributeSelection;
import weka.core.CheckGOE;
import weka.core.CheckOptionHandler;
import weka.core.CheckScheme;
import weka.core.Instances;
import weka.test.Regression;

public abstract class AbstractAttributeSelectionTest
extends TestCase {
    protected ASSearch m_Search;
    protected ASEvaluation m_Evaluator;
    protected CheckAttributeSelection m_Tester;
    protected boolean m_weightedInstancesHandler;
    protected boolean m_multiInstanceHandler;
    protected int m_NClasses;
    protected boolean DEBUG = false;
    protected static final int FIRST_CLASSTYPE = 0;
    protected static final int LAST_CLASSTYPE = 4;
    protected boolean[] m_NominalPredictors;
    protected boolean[] m_NumericPredictors;
    protected boolean[] m_StringPredictors;
    protected boolean[] m_DatePredictors;
    protected boolean[] m_RelationalPredictors;
    protected boolean[] m_handleMissingPredictors;
    protected boolean[] m_handleMissingClass;
    protected boolean[] m_handleClassAsFirstAttribute;
    protected boolean[] m_handleClassAsSecondAttribute;
    protected String[] m_RegressionResults;
    protected CheckOptionHandler m_OptionTester;
    protected CheckGOE m_GOETester;

    public AbstractAttributeSelectionTest(String name) {
        super(name);
    }

    protected CheckScheme.PostProcessor getPostProcessor() {
        return null;
    }

    protected CheckAttributeSelection getTester() {
        CheckAttributeSelection result = new CheckAttributeSelection();
        result.setSilent(true);
        result.setSearch(this.m_Search);
        result.setEvaluator(this.m_Evaluator);
        result.setNumInstances(20);
        result.setDebug(this.DEBUG);
        result.setPostProcessor(this.getPostProcessor());
        return result;
    }

    protected CheckOptionHandler getOptionTester() {
        CheckOptionHandler result = new CheckOptionHandler();
        result.setOptionHandler(null);
        result.setUserOptions(new String[0]);
        result.setSilent(true);
        return result;
    }

    protected CheckGOE getGOETester() {
        CheckGOE result = new CheckGOE();
        result.setObject(null);
        result.setSilent(true);
        return result;
    }

    protected void setUp() throws Exception {
        this.m_Search = this.getSearch();
        this.m_Evaluator = this.getEvaluator();
        this.m_Tester = this.getTester();
        this.m_OptionTester = this.getOptionTester();
        this.m_GOETester = this.getGOETester();
        this.m_weightedInstancesHandler = this.m_Tester.weightedInstancesHandler()[0];
        this.m_multiInstanceHandler = this.m_Tester.multiInstanceHandler()[0];
        this.m_NominalPredictors = new boolean[5];
        this.m_NumericPredictors = new boolean[5];
        this.m_StringPredictors = new boolean[5];
        this.m_DatePredictors = new boolean[5];
        this.m_RelationalPredictors = new boolean[5];
        this.m_handleMissingPredictors = new boolean[5];
        this.m_handleMissingClass = new boolean[5];
        this.m_handleClassAsFirstAttribute = new boolean[5];
        this.m_handleClassAsSecondAttribute = new boolean[5];
        this.m_RegressionResults = new String[5];
        this.m_NClasses = 4;
        this.checkAttributes(true, false, false, false, false, false);
        this.checkAttributes(false, true, false, false, false, false);
        this.checkAttributes(false, false, true, false, false, false);
        this.checkAttributes(false, false, false, true, false, false);
        this.checkAttributes(false, false, false, false, true, false);
        for (int i = 0; i <= 4; ++i) {
            if (!this.canPredict(i)) continue;
            this.m_handleMissingPredictors[i] = this.checkMissingPredictors(i, 20, false);
            this.m_handleMissingClass[i] = this.checkMissingClass(i, 20, false);
        }
    }

    protected void tearDown() {
        this.m_Search = null;
        this.m_Evaluator = null;
        this.m_Tester = null;
        this.m_OptionTester = null;
        this.m_GOETester = null;
        this.m_weightedInstancesHandler = false;
        this.m_NominalPredictors = new boolean[5];
        this.m_NumericPredictors = new boolean[5];
        this.m_StringPredictors = new boolean[5];
        this.m_DatePredictors = new boolean[5];
        this.m_RelationalPredictors = new boolean[5];
        this.m_handleMissingPredictors = new boolean[5];
        this.m_handleMissingClass = new boolean[5];
        this.m_handleClassAsFirstAttribute = new boolean[5];
        this.m_handleClassAsSecondAttribute = new boolean[5];
        this.m_RegressionResults = new String[5];
        this.m_NClasses = 4;
    }

    public abstract ASSearch getSearch();

    public abstract ASEvaluation getEvaluator();

    protected boolean canPredict(int type) {
        return this.m_NominalPredictors[type] || this.m_NumericPredictors[type] || this.m_StringPredictors[type] || this.m_DatePredictors[type] || this.m_RelationalPredictors[type];
    }

    protected String getClassTypeString(int type) {
        return CheckAttributeSelection.attributeTypeToString((int)type);
    }

    protected void checkAttributes(boolean nom, boolean num, boolean str, boolean dat, boolean rel, boolean allowFail) {
        String att = "";
        if (nom) {
            att = "nominal";
        } else if (num) {
            att = "numeric";
        } else if (str) {
            att = "string";
        } else if (dat) {
            att = "date";
        } else if (rel) {
            att = "relational";
        }
        for (int i = 0; i <= 4; ++i) {
            boolean[] result = this.m_Tester.canPredict(nom, num, str, dat, rel, this.m_multiInstanceHandler, i);
            if (nom) {
                this.m_NominalPredictors[i] = result[0];
            } else if (num) {
                this.m_NumericPredictors[i] = result[0];
            } else if (str) {
                this.m_StringPredictors[i] = result[0];
            } else if (dat) {
                this.m_DatePredictors[i] = result[0];
            } else if (rel) {
                this.m_RelationalPredictors[i] = result[0];
            }
            if (result[0] || result[1] || !allowFail) continue;
            AbstractAttributeSelectionTest.fail((String)("Error handling " + att + " attributes (" + this.getClassTypeString(i) + " class)!"));
        }
    }

    public void testAttributes() {
        this.checkAttributes(true, false, false, false, false, true);
        this.checkAttributes(false, true, false, false, false, true);
        this.checkAttributes(false, false, true, false, false, true);
        this.checkAttributes(false, false, false, true, false, true);
        if (!this.m_multiInstanceHandler) {
            this.checkAttributes(false, false, false, false, true, true);
        }
    }

    public void testSerialVersionUID() {
        boolean[] result = this.m_Tester.declaresSerialVersionUID();
        if (!result[0]) {
            AbstractAttributeSelectionTest.fail((String)"Doesn't declare serialVersionUID!");
        }
    }

    public void testInstanceWeights() {
        if (this.m_weightedInstancesHandler) {
            for (int i = 0; i <= 4; ++i) {
                boolean[] result;
                if (!this.canPredict(i) || (result = this.m_Tester.instanceWeights(this.m_NominalPredictors[i], this.m_NumericPredictors[i], this.m_StringPredictors[i], this.m_DatePredictors[i], this.m_RelationalPredictors[i], this.m_multiInstanceHandler, i))[0]) continue;
                System.err.println("Error handling instance weights (" + this.getClassTypeString(i) + " class)!");
            }
        }
    }

    public void testNClasses() {
        if (!this.canPredict(1)) {
            return;
        }
        boolean[] result = this.m_Tester.canHandleNClasses(this.m_NominalPredictors[1], this.m_NumericPredictors[1], this.m_StringPredictors[1], this.m_DatePredictors[1], this.m_RelationalPredictors[1], this.m_multiInstanceHandler, this.m_NClasses);
        if (!result[0] && !result[1]) {
            AbstractAttributeSelectionTest.fail((String)("Error handling " + this.m_NClasses + " classes!"));
        }
    }

    protected boolean checkClassAsNthAttribute(int type, int position) {
        boolean[] result = this.m_Tester.canHandleClassAsNthAttribute(this.m_NominalPredictors[type], this.m_NumericPredictors[type], this.m_StringPredictors[type], this.m_DatePredictors[type], this.m_RelationalPredictors[type], this.m_multiInstanceHandler, type, position);
        String indexStr = position == -1 ? "last" : position + 1 + ".";
        if (!result[0] && !result[1]) {
            AbstractAttributeSelectionTest.fail((String)("Error handling class as " + indexStr + " attribute (" + this.getClassTypeString(type) + " class)!"));
        }
        return result[0];
    }

    public void testClassAsNthAttribute() {
        if (this.m_multiInstanceHandler) {
            return;
        }
        for (int i = 0; i <= 4; ++i) {
            if (!this.canPredict(i)) continue;
            this.m_handleClassAsFirstAttribute[i] = this.checkClassAsNthAttribute(i, 0);
            this.m_handleClassAsSecondAttribute[i] = this.checkClassAsNthAttribute(i, 1);
        }
    }

    public void testZeroTraining() {
        for (int i = 0; i <= 4; ++i) {
            boolean[] result;
            if (!this.canPredict(i) || (result = this.m_Tester.canHandleZeroTraining(this.m_NominalPredictors[i], this.m_NumericPredictors[i], this.m_StringPredictors[i], this.m_DatePredictors[i], this.m_RelationalPredictors[i], this.m_multiInstanceHandler, i))[0] || result[1]) continue;
            AbstractAttributeSelectionTest.fail((String)("Error handling zero training instances (" + this.getClassTypeString(i) + " class)!"));
        }
    }

    protected boolean checkMissingPredictors(int type, int percent, boolean allowFail) {
        boolean[] result = this.m_Tester.canHandleMissing(this.m_NominalPredictors[type], this.m_NumericPredictors[type], this.m_StringPredictors[type], this.m_DatePredictors[type], this.m_RelationalPredictors[type], this.m_multiInstanceHandler, type, true, false, percent);
        if (allowFail && !result[0] && !result[1]) {
            AbstractAttributeSelectionTest.fail((String)("Error handling " + percent + "% missing predictors (" + this.getClassTypeString(type) + " class)!"));
        }
        return result[0];
    }

    public void testMissingPredictors() {
        for (int i = 0; i <= 4; ++i) {
            if (!this.canPredict(i)) continue;
            this.checkMissingPredictors(i, 20, true);
            if (!this.m_handleMissingPredictors[i]) continue;
            this.checkMissingPredictors(i, 100, true);
        }
    }

    protected boolean checkMissingClass(int type, int percent, boolean allowFail) {
        boolean[] result = this.m_Tester.canHandleMissing(this.m_NominalPredictors[type], this.m_NumericPredictors[type], this.m_StringPredictors[type], this.m_DatePredictors[type], this.m_RelationalPredictors[type], this.m_multiInstanceHandler, type, false, true, percent);
        if (allowFail && !result[0] && !result[1]) {
            AbstractAttributeSelectionTest.fail((String)("Error handling " + percent + "% missing class labels (" + this.getClassTypeString(type) + " class)!"));
        }
        return result[0];
    }

    public void testMissingClass() {
        for (int i = 0; i <= 4; ++i) {
            if (!this.canPredict(i)) continue;
            this.checkMissingClass(i, 20, true);
            if (!this.m_handleMissingClass[i]) continue;
            this.checkMissingClass(i, 100, true);
        }
    }

    public void testBuildInitialization() {
        for (int i = 0; i <= 4; ++i) {
            boolean[] result;
            if (!this.canPredict(i) || (result = this.m_Tester.correctSearchInitialisation(this.m_NominalPredictors[i], this.m_NumericPredictors[i], this.m_StringPredictors[i], this.m_DatePredictors[i], this.m_RelationalPredictors[i], this.m_multiInstanceHandler, i))[0] || result[1]) continue;
            AbstractAttributeSelectionTest.fail((String)("Incorrect build initialization (" + this.getClassTypeString(i) + " class)!"));
        }
    }

    public void testDatasetIntegrity() {
        for (int i = 0; i <= 4; ++i) {
            boolean[] result;
            if (!this.canPredict(i) || (result = this.m_Tester.datasetIntegrity(this.m_NominalPredictors[i], this.m_NumericPredictors[i], this.m_StringPredictors[i], this.m_DatePredictors[i], this.m_RelationalPredictors[i], this.m_multiInstanceHandler, i, this.m_handleMissingPredictors[i], this.m_handleMissingClass[i]))[0] || result[1]) continue;
            AbstractAttributeSelectionTest.fail((String)("Dataset is altered during training (" + this.getClassTypeString(i) + " class)!"));
        }
    }

    protected String useScheme(Instances data) throws Exception {
        AttributeSelection attsel = null;
        try {
            attsel = new AttributeSelection();
            attsel.setSearch(this.m_Search);
            attsel.setEvaluator(this.m_Evaluator);
            attsel.setSeed(42);
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractAttributeSelectionTest.fail((String)("Problem setting up attribute selection: " + e));
        }
        attsel.SelectAttributes(data);
        return attsel.toResultsString();
    }

    protected Instances process(Instances data) {
        return data;
    }

    public void testRegression() throws Exception {
        if (this.m_Tester.hasClasspathProblems()) {
            return;
        }
        Regression reg = new Regression(((Object)((Object)this)).getClass());
        boolean succeeded = false;
        Instances train = null;
        for (int i = 0; i <= 4; ++i) {
            if (!this.canPredict(i)) continue;
            train = this.m_Tester.makeTestDataset(42, this.m_Tester.getNumInstances(), this.m_NominalPredictors[i] ? 2 : 0, this.m_NumericPredictors[i] ? 1 : 0, this.m_StringPredictors[i] ? 1 : 0, this.m_DatePredictors[i] ? 1 : 0, this.m_RelationalPredictors[i] ? 1 : 0, 2, i, this.m_multiInstanceHandler);
            try {
                this.m_RegressionResults[i] = this.useScheme(train);
                succeeded = true;
                reg.println(this.m_RegressionResults[i]);
                continue;
            }
            catch (Exception e) {
                String msg = e.getMessage().toLowerCase();
                if (msg.indexOf("not in classpath") > -1) {
                    return;
                }
                this.m_RegressionResults[i] = null;
            }
        }
        if (!succeeded) {
            AbstractAttributeSelectionTest.fail((String)"Problem during regression testing: no successful predictions for any class type");
        }
        try {
            String diff = reg.diff();
            if (diff == null) {
                System.err.println("Warning: No reference available, creating.");
            } else if (!diff.equals("")) {
                AbstractAttributeSelectionTest.fail((String)("Regression test failed. Difference:\n" + diff));
            }
        }
        catch (IOException ex) {
            AbstractAttributeSelectionTest.fail((String)("Problem during regression testing.\n" + ex));
        }
    }

    public void testListOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkListOptions()) {
            AbstractAttributeSelectionTest.fail((String)"Options cannot be listed via listOptions.");
        }
    }

    public void testSetOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkSetOptions()) {
            AbstractAttributeSelectionTest.fail((String)"setOptions method failed.");
        }
    }

    public void testDefaultOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkDefaultOptions()) {
            AbstractAttributeSelectionTest.fail((String)"Default options were not processed correctly.");
        }
    }

    public void testRemainingOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkRemainingOptions()) {
            AbstractAttributeSelectionTest.fail((String)"There were 'left-over' options.");
        }
    }

    public void testCanonicalUserOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkCanonicalUserOptions()) {
            AbstractAttributeSelectionTest.fail((String)"setOptions method failed");
        }
    }

    public void testResettingOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkSetOptions()) {
            AbstractAttributeSelectionTest.fail((String)"Resetting of options failed");
        }
    }

    public void testGlobalInfo() {
        if (!this.m_GOETester.checkGlobalInfo()) {
            AbstractAttributeSelectionTest.fail((String)"No globalInfo method");
        }
    }

    public void testToolTips() {
        if (!this.m_GOETester.checkToolTips()) {
            AbstractAttributeSelectionTest.fail((String)"Tool tips inconsistent");
        }
    }
}

