/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Utils;
import weka.filters.unsupervised.attribute.StringToWordVector;

public class UtilsTest
extends TestCase {
    public UtilsTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSplittingAndJoining() {
        try {
            String[] options = new StringToWordVector().getOptions();
            String joined = Utils.joinOptions((String[])options);
            String[] newOptions = Utils.splitOptions((String)joined);
            UtilsTest.assertEquals((String)"Same number of options", (int)options.length, (int)newOptions.length);
            for (int i = 0; i < options.length; ++i) {
                if (options[i].equals(newOptions[i])) continue;
                UtilsTest.fail((String)("Option " + (i + 1) + " differs"));
            }
        }
        catch (Exception e) {
            UtilsTest.fail((String)("Exception: " + e));
        }
    }

    public void testQuoting() {
        String input = "blahblah";
        String output = Utils.quote((String)input);
        UtilsTest.assertTrue((String)"No quoting necessary", (!output.startsWith("'") && !output.endsWith("'") ? 1 : 0) != 0);
        input = "";
        output = Utils.quote((String)input);
        UtilsTest.assertTrue((String)"Empty string quoted", (output.startsWith("'") && output.endsWith("'") ? 1 : 0) != 0);
        UtilsTest.assertTrue((String)"Empty string restored", (boolean)input.equals(Utils.unquote((String)output)));
        input = " ";
        output = Utils.quote((String)input);
        UtilsTest.assertTrue((String)"Blank quoted", (output.startsWith("'") && output.endsWith("'") ? 1 : 0) != 0);
        UtilsTest.assertTrue((String)"Blank restored", (boolean)input.equals(Utils.unquote((String)output)));
        input = "{";
        output = Utils.quote((String)input);
        UtilsTest.assertTrue((String)(">" + input + "< quoted"), (output.startsWith("'") && output.endsWith("'") ? 1 : 0) != 0);
        UtilsTest.assertTrue((String)(">" + input + "< restored"), (boolean)input.equals(Utils.unquote((String)output)));
        input = "}";
        output = Utils.quote((String)input);
        UtilsTest.assertTrue((String)(">" + input + "< quoted"), (output.startsWith("'") && output.endsWith("'") ? 1 : 0) != 0);
        UtilsTest.assertTrue((String)(">" + input + "< restored"), (boolean)input.equals(Utils.unquote((String)output)));
        input = ",";
        output = Utils.quote((String)input);
        UtilsTest.assertTrue((String)(">" + input + "< quoted"), (output.startsWith("'") && output.endsWith("'") ? 1 : 0) != 0);
        UtilsTest.assertTrue((String)(">" + input + "< restored"), (boolean)input.equals(Utils.unquote((String)output)));
        input = "?";
        output = Utils.quote((String)input);
        UtilsTest.assertTrue((String)(">" + input + "< quoted"), (output.startsWith("'") && output.endsWith("'") ? 1 : 0) != 0);
        UtilsTest.assertTrue((String)(">" + input + "< restored"), (boolean)input.equals(Utils.unquote((String)output)));
        input = "\r\n\t'\"%";
        output = Utils.quote((String)input);
        UtilsTest.assertTrue((String)(">" + input + "< quoted"), (output.startsWith("'") && output.endsWith("'") ? 1 : 0) != 0);
        UtilsTest.assertTrue((String)(">" + input + "< restored"), (boolean)input.equals(Utils.unquote((String)output)));
    }

    public void testBackQuoting() {
        String input = "blahblah";
        String output = Utils.backQuoteChars((String)input);
        UtilsTest.assertTrue((String)"No backquoting necessary", (boolean)input.equals(output));
        input = "\r\n\t'\"%";
        output = Utils.backQuoteChars((String)input);
        UtilsTest.assertTrue((String)(">" + input + "< restored"), (boolean)input.equals(Utils.unbackQuoteChars((String)output)));
        input = "\\r\\n\\t\\'\\\"\\%";
        output = Utils.backQuoteChars((String)input);
        UtilsTest.assertTrue((String)(">" + input + "< restored"), (boolean)input.equals(Utils.unbackQuoteChars((String)output)));
        input = Utils.joinOptions((String[])new StringToWordVector().getOptions());
        output = Utils.backQuoteChars((String)input);
        UtilsTest.assertTrue((String)(">" + input + "< restored"), (boolean)input.equals(Utils.unbackQuoteChars((String)output)));
    }

    public static Test suite() {
        return new TestSuite(UtilsTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)UtilsTest.suite());
    }
}

