/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import junit.framework.TestCase;
import weka.core.CheckGOE;
import weka.core.CheckOptionHandler;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.TestInstances;
import weka.core.converters.AbstractLoader;
import weka.core.converters.AbstractSaver;

public abstract class AbstractConverterTest
extends TestCase {
    public static final boolean TEST_OPTION_HANDLING = false;
    protected TestInstances m_TestInstances;
    protected AbstractLoader m_Loader;
    protected AbstractSaver m_Saver;
    protected CheckOptionHandler m_OptionTesterLoader;
    protected CheckOptionHandler m_OptionTesterSaver;
    protected CheckGOE m_GOETesterLoader;
    protected CheckGOE m_GOETesterSaver;
    protected Instances m_Instances;

    public AbstractConverterTest(String name) {
        super(name);
    }

    public abstract AbstractLoader getLoader();

    public abstract AbstractSaver getSaver();

    protected CheckOptionHandler getOptionTester(Object o) {
        CheckOptionHandler result = new CheckOptionHandler();
        if (o instanceof OptionHandler) {
            result.setOptionHandler((OptionHandler)o);
        } else {
            result.setOptionHandler(null);
        }
        result.setUserOptions(new String[0]);
        result.setSilent(true);
        return result;
    }

    protected CheckGOE getGOETester(Object o) {
        CheckGOE result = new CheckGOE();
        result.setObject(o);
        result.setIgnoredProperties(result.getIgnoredProperties() + ",instances");
        result.setSilent(true);
        return result;
    }

    protected CheckOptionHandler getOptionTesterLoader() {
        return this.getOptionTester(this.getLoader());
    }

    protected CheckOptionHandler getOptionTesterSaver() {
        return this.getOptionTester(this.getSaver());
    }

    protected CheckGOE getGOETesterLoader() {
        return this.getGOETester(this.getLoader());
    }

    protected CheckGOE getGOETesterSaver() {
        return this.getGOETester(this.getSaver());
    }

    protected TestInstances getTestInstances() {
        return new TestInstances();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_Loader = this.getLoader();
        this.m_Saver = this.getSaver();
        this.m_OptionTesterLoader = this.getOptionTesterLoader();
        this.m_OptionTesterSaver = this.getOptionTesterSaver();
        this.m_GOETesterLoader = this.getGOETesterLoader();
        this.m_GOETesterSaver = this.getGOETesterSaver();
        this.m_TestInstances = this.getTestInstances();
        this.m_Instances = this.m_TestInstances.generate();
    }

    protected void tearDown() throws Exception {
        this.m_Loader = null;
        this.m_Saver = null;
        this.m_OptionTesterLoader = null;
        this.m_OptionTesterSaver = null;
        this.m_GOETesterLoader = null;
        this.m_GOETesterSaver = null;
        this.m_TestInstances = null;
        this.m_Instances = null;
        super.tearDown();
    }

    public void testListOptions() {
        if (this.m_OptionTesterLoader.getOptionHandler() != null && !this.m_OptionTesterLoader.checkListOptions()) {
            AbstractConverterTest.fail((String)"Loader: Options cannot be listed via listOptions.");
        }
        if (this.m_OptionTesterSaver.getOptionHandler() != null && !this.m_OptionTesterSaver.checkListOptions()) {
            AbstractConverterTest.fail((String)"Saver: Options cannot be listed via listOptions.");
        }
    }

    public void testSetOptions() {
    }

    public void testRemainingOptions() {
    }

    public void testCanonicalUserOptions() {
    }

    public void testResettingOptions() {
    }

    public void testGlobalInfo() {
        if (!this.m_GOETesterLoader.checkGlobalInfo()) {
            AbstractConverterTest.fail((String)"Loader: No globalInfo method");
        }
        if (!this.m_GOETesterSaver.checkGlobalInfo()) {
            AbstractConverterTest.fail((String)"Saver: No globalInfo method");
        }
    }

    public void testToolTips() {
        if (!this.m_GOETesterLoader.checkToolTips()) {
            AbstractConverterTest.fail((String)"Loader: Tool tips inconsistent");
        }
        if (!this.m_GOETesterSaver.checkToolTips()) {
            AbstractConverterTest.fail((String)"Saver: Tool tips inconsistent");
        }
    }
}

