/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.MergeManyValues;

public class MergeManyValuesTest
extends AbstractFilterTest {
    public MergeManyValuesTest(String name) {
        super(name);
    }

    public Filter getFilter() {
        MergeManyValues f = new MergeManyValues();
        f.setAttributeIndex("2");
        return f;
    }

    public void testInvalidAttributeTypes() {
        Instances icopy = new Instances(this.m_Instances);
        try {
            ((MergeManyValues)this.m_Filter).setAttributeIndex("1");
            this.m_Filter.setInputFormat(icopy);
            MergeManyValuesTest.fail((String)"Should have thrown an exception selecting a STRING attribute!");
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            ((MergeManyValues)this.m_Filter).setAttributeIndex("3");
            this.m_Filter.setInputFormat(icopy);
            MergeManyValuesTest.fail((String)"Should have thrown an exception indicating a NUMERIC attribute!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testTypical() {
        Instances result = this.useFilter();
        MergeManyValuesTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        MergeManyValuesTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        int mergedIndex = -1;
        for (int i = 0; i < result.numInstances(); ++i) {
            if (this.m_Instances.instance(i).value(1) != 0.0 && this.m_Instances.instance(i).value(1) != 1.0) continue;
            if (mergedIndex == -1) {
                mergedIndex = (int)result.instance(i).value(1);
                continue;
            }
            MergeManyValuesTest.assertEquals((String)("Checking merged value for instance: " + (i + 1)), (int)mergedIndex, (int)((int)result.instance(i).value(1)));
        }
    }

    public void testDifferentRange() {
        ((MergeManyValues)this.m_Filter).setMergeValueRange("2,3");
        Instances result = this.useFilter();
        MergeManyValuesTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        MergeManyValuesTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        int mergedIndex = -1;
        for (int i = 0; i < result.numInstances(); ++i) {
            if (this.m_Instances.instance(i).value(1) != 1.0 && this.m_Instances.instance(i).value(1) != 2.0) continue;
            if (mergedIndex == -1) {
                mergedIndex = (int)result.instance(i).value(1);
                continue;
            }
            MergeManyValuesTest.assertEquals((String)("Checking merged value for instance: " + (i + 1)), (int)mergedIndex, (int)((int)result.instance(i).value(1)));
        }
    }

    public void testMergeAll() {
        ((MergeManyValues)this.m_Filter).setMergeValueRange("first-last");
        Instances result = this.useFilter();
        MergeManyValuesTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        MergeManyValuesTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        MergeManyValuesTest.assertEquals((int)1, (int)result.attribute(1).numValues());
    }

    public void testAttributeWithMissing() {
        ((MergeManyValues)this.m_Filter).setAttributeIndex("5");
        ((MergeManyValues)this.m_Filter).setMergeValueRange("1,2");
        Instances result = this.useFilter();
        MergeManyValuesTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        MergeManyValuesTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        int mergedIndex = -1;
        for (int i = 0; i < result.numInstances(); ++i) {
            if (this.m_Instances.instance(i).isMissing(4)) {
                MergeManyValuesTest.assertTrue((String)"Missing in input should give missing in result", (boolean)result.instance(i).isMissing(4));
                continue;
            }
            if (this.m_Instances.instance(i).value(4) != 0.0 && this.m_Instances.instance(i).value(4) != 1.0) continue;
            if (mergedIndex == -1) {
                mergedIndex = (int)result.instance(i).value(4);
                continue;
            }
            MergeManyValuesTest.assertEquals((String)("Checking merged value for instance: " + (i + 1)), (int)mergedIndex, (int)((int)result.instance(i).value(4)));
        }
    }

    public void testFilteredClassifier() {
        try {
            Instances data = this.getFilteredClassifierData();
            for (int i = 0; i < data.numAttributes(); ++i) {
                if (data.classIndex() == i || !data.attribute(i).isNominal()) continue;
                ((MergeManyValues)this.m_FilteredClassifier.getFilter()).setAttributeIndex("" + (i + 1));
                break;
            }
        }
        catch (Exception e) {
            MergeManyValuesTest.fail((String)("Problem setting up test for FilteredClassifier: " + e.toString()));
        }
        super.testFilteredClassifier();
    }

    public static Test suite() {
        return new TestSuite(MergeManyValuesTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)MergeManyValuesTest.suite());
    }
}

