/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.RandomSubset;

public class RandomSubsetTest
extends AbstractFilterTest {
    public RandomSubsetTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        return new RandomSubset();
    }

    public Filter getFilter(double num) {
        RandomSubset result = new RandomSubset();
        result.setNumAttributes(num);
        return result;
    }

    protected void performTest(double numSel, int numOut) {
        this.m_Filter = this.getFilter(numSel);
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            RandomSubsetTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex.getMessage()));
        }
        try {
            result = Filter.useFilter((Instances)icopy, (Filter)this.m_Filter);
            RandomSubsetTest.assertNotNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            RandomSubsetTest.fail((String)("Exception thrown on useFilter(): \n" + ex.getMessage()));
        }
        RandomSubsetTest.assertEquals((int)numOut, (int)result.numAttributes());
        RandomSubsetTest.assertEquals((int)icopy.numInstances(), (int)this.m_Instances.numInstances());
    }

    public void testPercentage() {
        this.performTest(0.5, 4);
    }

    public void testAbsolute() {
        this.performTest(5.0, 5);
    }

    public static Test suite() {
        return new TestSuite(RandomSubsetTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RandomSubsetTest.suite());
    }
}

