/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Attribute;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class ReplaceMissingValuesTest
extends AbstractFilterTest {
    public ReplaceMissingValuesTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        return new ReplaceMissingValues();
    }

    public void testTypical() {
        Instances result = this.useFilter();
        ReplaceMissingValuesTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        ReplaceMissingValuesTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        int j = 0;
        while (j < this.m_Instances.numAttributes()) {
            Attribute inatt = this.m_Instances.attribute(j);
            Attribute outatt = result.attribute(j);
            int i = 0;
            while (i < this.m_Instances.numInstances()) {
                if (this.m_Instances.attribute(j).isString()) {
                    if (this.m_Instances.instance(i).isMissing(j)) {
                        ReplaceMissingValuesTest.assertTrue((String)"Missing values in strings cannot be replaced", (boolean)result.instance(i).isMissing(j));
                    } else {
                        ReplaceMissingValuesTest.assertEquals((String)"String values should not have changed", (String)inatt.value((int)this.m_Instances.instance(i).value(j)), (String)outatt.value((int)result.instance(i).value(j)));
                    }
                } else {
                    ReplaceMissingValuesTest.assertTrue((String)"All non-string missing values should have been replaced", (!result.instance(i).isMissing(j) ? 1 : 0) != 0);
                }
                ++i;
            }
            ++j;
        }
    }

    public static Test suite() {
        return new TestSuite(ReplaceMissingValuesTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ReplaceMissingValuesTest.suite());
    }
}

