/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.classifiers.Classifier;
import weka.classifiers.meta.FilteredClassifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.TestInstances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToString;

public class NominalToStringTest
extends AbstractFilterTest {
    public NominalToStringTest(String name) {
        super(name);
    }

    public Filter getFilter() {
        NominalToString f = new NominalToString();
        f.setAttributeIndexes("2");
        return f;
    }

    protected FilteredClassifier getFilteredClassifier() {
        FilteredClassifier result = super.getFilteredClassifier();
        ((NominalToString)result.getFilter()).setAttributeIndexes("1");
        result.setClassifier((Classifier)new ZeroR());
        return result;
    }

    protected Instances getFilteredClassifierData() throws Exception {
        TestInstances test = TestInstances.forCapabilities((Capabilities)this.m_FilteredClassifier.getCapabilities());
        test.setNumRelational(0);
        test.setClassIndex(-1);
        Instances result = test.generate();
        return result;
    }

    public void testTypical() {
        Instances result = this.useFilter();
        NominalToStringTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        NominalToStringTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        NominalToStringTest.assertEquals((String)"Attribute type should now be STRING", (int)2, (int)result.attribute(1).type());
        NominalToStringTest.assertEquals((int)3, (int)result.attribute(1).numValues());
    }

    public void testMissing() {
        ((NominalToString)this.m_Filter).setAttributeIndexes("5");
        Instances result = this.useFilter();
        NominalToStringTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        NominalToStringTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        NominalToStringTest.assertEquals((String)"Attribute type should now be STRING", (int)2, (int)result.attribute(4).type());
        NominalToStringTest.assertEquals((int)4, (int)result.attribute(4).numValues());
        for (int i = 0; i < result.numInstances(); ++i) {
            NominalToStringTest.assertTrue((String)"Missing values should be preserved", (this.m_Instances.instance(i).isMissing(4) == result.instance(i).isMissing(4) ? 1 : 0) != 0);
        }
    }

    public void testFilteredClassifier() {
        try {
            Instances data = this.getFilteredClassifierData();
            for (int i = 0; i < data.numAttributes(); ++i) {
                if (data.classIndex() == i || !data.attribute(i).isNominal()) continue;
                ((NominalToString)this.m_FilteredClassifier.getFilter()).setAttributeIndexes("" + (i + 1));
                break;
            }
        }
        catch (Exception e) {
            NominalToStringTest.fail((String)("Problem setting up test for FilteredClassifier: " + e.toString()));
        }
        super.testFilteredClassifier();
    }

    public static Test suite() {
        return new TestSuite(NominalToStringTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)NominalToStringTest.suite());
    }
}

