/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.InstanceComparator;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.AddNoise;

public class AddNoiseTest
extends AbstractFilterTest {
    protected InstanceComparator m_Comparator;

    public AddNoiseTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_Instances.setClassIndex(1);
        int i = 0;
        while (i < this.m_Instances.numAttributes()) {
            if (!this.m_Instances.attribute(i).isNominal()) {
                this.m_Instances.deleteAttributeAt(i);
                continue;
            }
            ++i;
        }
        this.m_Comparator = new InstanceComparator(true);
    }

    @Override
    public Filter getFilter() {
        AddNoise f = new AddNoise();
        return f;
    }

    public void testTypical() {
        this.m_Filter = this.getFilter();
        Instances result = this.useFilter();
        AddNoiseTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        AddNoiseTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        boolean equal = true;
        int i = 0;
        while (i < this.m_Instances.numInstances()) {
            if (this.m_Comparator.compare(this.m_Instances.instance(i), result.instance(i)) != 0) {
                equal = false;
                break;
            }
            ++i;
        }
        if (equal) {
            AddNoiseTest.fail((String)"No noise added!");
        }
    }

    public void testNoNoise() {
        this.m_Filter = this.getFilter();
        ((AddNoise)this.m_Filter).setPercent(0);
        Instances result = this.useFilter();
        AddNoiseTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        AddNoiseTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        boolean equal = true;
        int i = 0;
        while (i < this.m_Instances.numInstances()) {
            if (this.m_Comparator.compare(this.m_Instances.instance(i), result.instance(i)) != 0) {
                equal = false;
                break;
            }
            ++i;
        }
        if (!equal) {
            AddNoiseTest.fail((String)"Instances modified!");
        }
    }

    public static Test suite() {
        return new TestSuite(AddNoiseTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)AddNoiseTest.suite());
    }
}

