/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.AddValues;

public class AddValuesTest
extends AbstractFilterTest {
    public AddValuesTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        AddValues filter = new AddValues();
        filter.setAttributeIndex("2");
        return filter;
    }

    public Filter getFilter(boolean sorted, String labels) {
        AddValues filter = new AddValues();
        filter.setAttributeIndex("2");
        filter.setSort(sorted);
        filter.setLabels(labels);
        return filter;
    }

    protected void compareDatasets(Instances data1, Instances data2) throws Exception {
        if (data1.numAttributes() != data2.numAttributes()) {
            throw new Exception("number of attributes has changed");
        }
        if (data2.numInstances() != data1.numInstances()) {
            throw new Exception("number of instances has changed");
        }
        int i = 0;
        while (i < data2.numInstances()) {
            Instance orig = data1.instance(i);
            Instance copy = data2.instance(i);
            int j = 0;
            while (j < orig.numAttributes()) {
                if (orig.isMissing(j) ? !copy.isMissing(j) : !orig.toString(j).equals(copy.toString(j))) {
                    throw new Exception("instances have changed");
                }
                if (orig.weight() != copy.weight()) {
                    throw new Exception("instance weights have changed");
                }
                ++j;
            }
            ++i;
        }
    }

    protected void performTest(Filter filter) {
        this.m_Filter = filter;
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AddValuesTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex.getMessage()));
        }
        try {
            result = Filter.useFilter((Instances)this.m_Instances, (Filter)this.m_Filter);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AddValuesTest.fail((String)("Exception thrown on useFilter(): \n" + ex.getMessage()));
        }
        try {
            this.compareDatasets(icopy, result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AddValuesTest.fail((String)("Datasets differ: \n" + ex.getMessage()));
        }
    }

    public void testDefault() {
        this.performTest(this.getFilter());
    }

    public void testSort() {
        this.performTest(this.getFilter(true, ""));
    }

    public void testLabels() {
        this.performTest(this.getFilter(false, "__blah,__blubber"));
    }

    public void testSortAndLabels() {
        this.performTest(this.getFilter(false, "__blah,__blubber"));
    }

    @Override
    public void testFilteredClassifier() {
        try {
            Instances data = this.getFilteredClassifierData();
            int i = 0;
            while (i < data.numAttributes()) {
                if (data.classIndex() != i && data.attribute(i).isNominal()) {
                    ((AddValues)this.m_FilteredClassifier.getFilter()).setAttributeIndex("" + (i + 1));
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            AddValuesTest.fail((String)("Problem setting up test for FilteredClassifier: " + e.toString()));
        }
        super.testFilteredClassifier();
    }

    public static Test suite() {
        return new TestSuite(AddValuesTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)AddValuesTest.suite());
    }
}

