/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.instance.SubsetByExpression;

public class SubsetByExpressionTest
extends AbstractFilterTest {
    public SubsetByExpressionTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_Instances.deleteAttributeType(2);
        this.m_Instances.setClassIndex(0);
    }

    @Override
    public Filter getFilter() {
        return new SubsetByExpression();
    }

    public Filter getFilter(String expr) {
        SubsetByExpression result = new SubsetByExpression();
        result.setExpression(expr);
        return result;
    }

    public void testIsmissing() {
        this.m_Filter = this.getFilter("ismissing(ATT3)");
        Instances result = this.useFilter();
        SubsetByExpressionTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        SubsetByExpressionTest.assertEquals((int)3, (int)result.numInstances());
    }

    public void testNotIsmissing() {
        this.m_Filter = this.getFilter("not ismissing(ATT3)");
        Instances result = this.useFilter();
        SubsetByExpressionTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        SubsetByExpressionTest.assertEquals((int)(this.m_Instances.numInstances() - 3), (int)result.numInstances());
    }

    public void testClassIs() {
        this.m_Filter = this.getFilter("CLASS is 'g'");
        Instances result = this.useFilter();
        SubsetByExpressionTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        SubsetByExpressionTest.assertEquals((int)3, (int)result.numInstances());
    }

    public void testClassIs2() {
        this.m_Filter = this.getFilter("(CLASS is 'r') or (CLASS is 'g') or (CLASS is 'b')");
        Instances result = this.useFilter();
        SubsetByExpressionTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        SubsetByExpressionTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
    }

    public void testAttIs() {
        this.m_Filter = this.getFilter("ATT1 is 'r'");
        Instances result = this.useFilter();
        SubsetByExpressionTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        SubsetByExpressionTest.assertEquals((int)12, (int)result.numInstances());
    }

    public void testGreater() {
        this.m_Filter = this.getFilter("ATT2 > 4");
        Instances result = this.useFilter();
        SubsetByExpressionTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        SubsetByExpressionTest.assertEquals((int)13, (int)result.numInstances());
    }

    public void testLess() {
        this.m_Filter = this.getFilter("ATT2 < 4");
        Instances result = this.useFilter();
        SubsetByExpressionTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        SubsetByExpressionTest.assertEquals((int)7, (int)result.numInstances());
    }

    public void testGreaterOrEqual() {
        this.m_Filter = this.getFilter("ATT2 >= 4");
        Instances result = this.useFilter();
        SubsetByExpressionTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        SubsetByExpressionTest.assertEquals((int)14, (int)result.numInstances());
    }

    public void testLessOrEqual() {
        this.m_Filter = this.getFilter("ATT2 <= 4");
        Instances result = this.useFilter();
        SubsetByExpressionTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        SubsetByExpressionTest.assertEquals((int)8, (int)result.numInstances());
    }

    public void testEqual() {
        this.m_Filter = this.getFilter("ATT2 = 4");
        Instances result = this.useFilter();
        SubsetByExpressionTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        SubsetByExpressionTest.assertEquals((int)1, (int)result.numInstances());
    }

    public void testAnd() {
        this.m_Filter = this.getFilter("(ATT1 is 'r') and (ATT2 <= 5)");
        Instances result = this.useFilter();
        SubsetByExpressionTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        SubsetByExpressionTest.assertEquals((int)6, (int)result.numInstances());
    }

    public static Test suite() {
        return new TestSuite(SubsetByExpressionTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)SubsetByExpressionTest.suite());
    }
}

