/*
 * Decompiled with CFR 0.152.
 */
package weka.core.tokenizers;

import java.io.IOException;
import junit.framework.TestCase;
import weka.core.CheckGOE;
import weka.core.CheckOptionHandler;
import weka.core.FastVector;
import weka.core.OptionHandler;
import weka.core.SerializationHelper;
import weka.core.tokenizers.Tokenizer;
import weka.test.Regression;

public abstract class AbstractTokenizerTest
extends TestCase {
    protected String[] m_Data;
    protected Tokenizer m_Tokenizer;
    protected FastVector[] m_RegressionResults;
    protected CheckOptionHandler m_OptionTester;
    protected CheckGOE m_GOETester;

    public AbstractTokenizerTest(String name) {
        super(name);
    }

    protected String[] getData() {
        return new String[]{"Humpty Dumpty was sitting, with his legs crossed like a Turk, on the top of a high wall -- such a narrow one that Alice quite wondered how he could keep his balance -- and, as his eyes were steadily fixed in the opposite direction, and he didn't take the least notice of her, she thought he must be a stuffed figure, after all.", "The planet Mars, I scarcely need remind the reader, revolves about the sun at a mean distance of 140,000,000 miles, and the light and heat it receives from the sun is barely half of that received by this world.", "I've studied now Philosophy And Jurisprudence, Medicine, And even, alas! Theology All through and through with ardour keen! Here now I stand, poor fool, and see I'm just as wise as formerly."};
    }

    protected CheckOptionHandler getOptionTester() {
        CheckOptionHandler result = new CheckOptionHandler();
        if (this.getTokenizer() instanceof OptionHandler) {
            result.setOptionHandler((OptionHandler)this.getTokenizer());
        } else {
            result.setOptionHandler(null);
        }
        result.setUserOptions(new String[0]);
        result.setSilent(true);
        return result;
    }

    protected CheckGOE getGOETester() {
        CheckGOE result = new CheckGOE();
        result.setObject((Object)this.getTokenizer());
        result.setSilent(true);
        return result;
    }

    protected void setUp() throws Exception {
        this.m_Tokenizer = this.getTokenizer();
        this.m_OptionTester = this.getOptionTester();
        this.m_GOETester = this.getGOETester();
        this.m_Data = this.getData();
        this.m_RegressionResults = new FastVector[this.m_Data.length];
    }

    protected void tearDown() {
        this.m_Tokenizer = null;
        this.m_OptionTester = null;
        this.m_GOETester = null;
        this.m_Data = null;
        this.m_RegressionResults = null;
    }

    public abstract Tokenizer getTokenizer();

    public void testSerialVersionUID() {
        boolean result;
        boolean bl = result = !SerializationHelper.needsUID(this.m_Tokenizer.getClass());
        if (!result) {
            AbstractTokenizerTest.fail((String)"Doesn't declare serialVersionUID!");
        }
    }

    public void testBuildInitialization() {
        int i;
        String[][][] processed = new String[2][this.m_Data.length][];
        int n = 0;
        while (n < 2) {
            i = 0;
            while (i < this.m_Data.length) {
                try {
                    processed[n][i] = Tokenizer.tokenize((Tokenizer)this.m_Tokenizer, (String[])new String[]{this.m_Data[i]});
                }
                catch (Exception e) {
                    processed[n][i] = new String[0];
                }
                ++i;
            }
            ++n;
        }
        boolean result = true;
        String msg = "";
        i = 0;
        while (i < this.m_Data.length) {
            if (processed[0].length != processed[1].length) {
                result = false;
                msg = "different number of substrings";
                break;
            }
            n = 0;
            while (n < processed[0][i].length) {
                if (!processed[0][i][n].equals(processed[1][i][n])) {
                    result = false;
                    msg = "different substrings";
                    break;
                }
                ++n;
            }
            ++i;
        }
        if (!result) {
            AbstractTokenizerTest.fail((String)("Incorrect build initialization (" + msg + ")!"));
        }
    }

    protected FastVector useTokenizer(String s) throws Exception {
        String[] tokens = Tokenizer.tokenize((Tokenizer)this.m_Tokenizer, (String[])new String[]{s});
        FastVector result = new FastVector();
        int i = 0;
        while (i < tokens.length) {
            result.addElement((Object)tokens[i]);
            ++i;
        }
        return result;
    }

    protected String predictionsToString(FastVector tokens) {
        StringBuffer sb = new StringBuffer();
        sb.append(tokens.size()).append(" tokens\n");
        int i = 0;
        while (i < tokens.size()) {
            sb.append(tokens.elementAt(i)).append('\n');
            ++i;
        }
        return sb.toString();
    }

    public void testRegression() {
        Regression reg = new Regression(((Object)((Object)this)).getClass());
        boolean succeeded = false;
        int i = 0;
        while (i < this.m_Data.length) {
            try {
                this.m_RegressionResults[i] = this.useTokenizer(this.m_Data[i]);
                succeeded = true;
                reg.println(this.predictionsToString(this.m_RegressionResults[i]));
            }
            catch (Exception e) {
                this.m_RegressionResults[i] = null;
            }
            ++i;
        }
        if (!succeeded) {
            AbstractTokenizerTest.fail((String)"Problem during regression testing: no successful tokens generated for any string");
        }
        try {
            String diff = reg.diff();
            if (diff == null) {
                System.err.println("Warning: No reference available, creating.");
            } else if (!diff.equals("")) {
                AbstractTokenizerTest.fail((String)("Regression test failed. Difference:\n" + diff));
            }
        }
        catch (IOException ex) {
            AbstractTokenizerTest.fail((String)("Problem during regression testing.\n" + ex));
        }
    }

    public void testListOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkListOptions()) {
            AbstractTokenizerTest.fail((String)"Options cannot be listed via listOptions.");
        }
    }

    public void testSetOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkSetOptions()) {
            AbstractTokenizerTest.fail((String)"setOptions method failed.");
        }
    }

    public void testDefaultOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkDefaultOptions()) {
            AbstractTokenizerTest.fail((String)"Default options were not processed correctly.");
        }
    }

    public void testRemainingOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkRemainingOptions()) {
            AbstractTokenizerTest.fail((String)"There were 'left-over' options.");
        }
    }

    public void testCanonicalUserOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkCanonicalUserOptions()) {
            AbstractTokenizerTest.fail((String)"setOptions method failed");
        }
    }

    public void testResettingOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkSetOptions()) {
            AbstractTokenizerTest.fail((String)"Resetting of options failed");
        }
    }

    public void testGlobalInfo() {
        if (!this.m_GOETester.checkGlobalInfo()) {
            AbstractTokenizerTest.fail((String)"No globalInfo method");
        }
    }

    public void testToolTips() {
        if (!this.m_GOETester.checkToolTips()) {
            AbstractTokenizerTest.fail((String)"Tool tips inconsistent");
        }
    }
}

