/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.MathExpression;

public class MathExpressionTest
extends AbstractFilterTest {
    protected int m_AttIndex = 2;

    public MathExpressionTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        return this.getFilter(new MathExpression().getExpression());
    }

    protected Filter getFilter(String expression) {
        MathExpression f = new MathExpression();
        f.setExpression(expression);
        f.setIgnoreRange("" + (this.m_AttIndex + 1));
        f.setInvertSelection(true);
        return f;
    }

    public void testTypical() {
        this.m_Filter = this.getFilter();
        Instances result = this.useFilter();
        MathExpressionTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        MathExpressionTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
    }

    protected void checkStatistics(String expr, double stats) {
        this.m_Filter = this.getFilter(expr);
        Instances result = this.useFilter();
        MathExpressionTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        MathExpressionTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        boolean equal = true;
        int i = 0;
        while (i < result.numInstances()) {
            if (!Utils.eq((double)stats, (double)result.instance(i).value(this.m_AttIndex))) {
                equal = false;
                break;
            }
            ++i;
        }
        if (!equal) {
            MathExpressionTest.fail((String)("Filter and Attribute statistics differ ('" + expr + "')!"));
        }
    }

    public void testStats() {
        this.checkStatistics("MIN", this.m_Instances.attributeStats((int)this.m_AttIndex).numericStats.min);
        this.checkStatistics("MAX", this.m_Instances.attributeStats((int)this.m_AttIndex).numericStats.max);
        this.checkStatistics("MEAN", this.m_Instances.attributeStats((int)this.m_AttIndex).numericStats.mean);
        this.checkStatistics("SD", this.m_Instances.attributeStats((int)this.m_AttIndex).numericStats.stdDev);
        this.checkStatistics("COUNT", this.m_Instances.attributeStats((int)this.m_AttIndex).numericStats.count);
        this.checkStatistics("SUM", this.m_Instances.attributeStats((int)this.m_AttIndex).numericStats.sum);
        this.checkStatistics("SUMSQUARED", this.m_Instances.attributeStats((int)this.m_AttIndex).numericStats.sumSq);
    }

    public void testEquality() {
        this.m_Filter = this.getFilter("A");
        Instances result = this.useFilter();
        MathExpressionTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        MathExpressionTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        boolean equal = true;
        int i = 0;
        while (i < result.numInstances()) {
            if (!(this.m_Instances.instance(i) instanceof SparseInstance) && !Utils.eq((double)this.m_Instances.instance(i).value(this.m_AttIndex), (double)result.instance(i).value(this.m_AttIndex))) {
                equal = false;
                break;
            }
            ++i;
        }
        if (!equal) {
            MathExpressionTest.fail((String)"Filter modifies attribute values)!");
        }
    }

    public void testAbs() {
        this.m_Filter = this.getFilter("abs(A)");
        Instances result = this.useFilter();
        MathExpressionTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        MathExpressionTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        boolean equal = true;
        int i = 0;
        while (i < result.numInstances()) {
            if (!(this.m_Instances.instance(i) instanceof SparseInstance) && !Utils.eq((double)Math.abs(this.m_Instances.instance(i).value(this.m_AttIndex)), (double)result.instance(i).value(this.m_AttIndex))) {
                equal = false;
                break;
            }
            ++i;
        }
        if (!equal) {
            MathExpressionTest.fail((String)"Filter produces different result)!");
        }
    }

    public void testsqrt() {
        this.m_Filter = this.getFilter("sqrt(A)");
        Instances result = this.useFilter();
        MathExpressionTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        MathExpressionTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        boolean equal = true;
        int i = 0;
        while (i < result.numInstances()) {
            if (!(this.m_Instances.instance(i) instanceof SparseInstance) && !Utils.eq((double)Math.sqrt(this.m_Instances.instance(i).value(this.m_AttIndex)), (double)result.instance(i).value(this.m_AttIndex))) {
                equal = false;
                break;
            }
            ++i;
        }
        if (!equal) {
            MathExpressionTest.fail((String)"Filter produces different result)!");
        }
    }

    public void testLog() {
        this.m_Filter = this.getFilter("log(A)");
        Instances result = this.useFilter();
        MathExpressionTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        MathExpressionTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        boolean equal = true;
        int i = 0;
        while (i < result.numInstances()) {
            if (!(this.m_Instances.instance(i) instanceof SparseInstance) && !Utils.eq((double)Math.log(this.m_Instances.instance(i).value(this.m_AttIndex)), (double)result.instance(i).value(this.m_AttIndex))) {
                equal = false;
                break;
            }
            ++i;
        }
        if (!equal) {
            MathExpressionTest.fail((String)"Filter produces different result)!");
        }
    }

    public void testExp() {
        this.m_Filter = this.getFilter("exp(A)");
        Instances result = this.useFilter();
        MathExpressionTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        MathExpressionTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        boolean equal = true;
        int i = 0;
        while (i < result.numInstances()) {
            if (!(this.m_Instances.instance(i) instanceof SparseInstance) && !Utils.eq((double)Math.exp(this.m_Instances.instance(i).value(this.m_AttIndex)), (double)result.instance(i).value(this.m_AttIndex))) {
                equal = false;
                break;
            }
            ++i;
        }
        if (!equal) {
            MathExpressionTest.fail((String)"Filter produces different result)!");
        }
    }

    public void testSin() {
        this.m_Filter = this.getFilter("sin(A)");
        Instances result = this.useFilter();
        MathExpressionTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        MathExpressionTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        boolean equal = true;
        int i = 0;
        while (i < result.numInstances()) {
            if (!(this.m_Instances.instance(i) instanceof SparseInstance) && !Utils.eq((double)Math.sin(this.m_Instances.instance(i).value(this.m_AttIndex)), (double)result.instance(i).value(this.m_AttIndex))) {
                equal = false;
                break;
            }
            ++i;
        }
        if (!equal) {
            MathExpressionTest.fail((String)"Filter produces different result)!");
        }
    }

    public void testCos() {
        this.m_Filter = this.getFilter("cos(A)");
        Instances result = this.useFilter();
        MathExpressionTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        MathExpressionTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        boolean equal = true;
        int i = 0;
        while (i < result.numInstances()) {
            if (!(this.m_Instances.instance(i) instanceof SparseInstance) && !Utils.eq((double)Math.cos(this.m_Instances.instance(i).value(this.m_AttIndex)), (double)result.instance(i).value(this.m_AttIndex))) {
                equal = false;
                break;
            }
            ++i;
        }
        if (!equal) {
            MathExpressionTest.fail((String)"Filter produces different result)!");
        }
    }

    public void testTan() {
        this.m_Filter = this.getFilter("tan(A)");
        Instances result = this.useFilter();
        MathExpressionTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        MathExpressionTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        boolean equal = true;
        int i = 0;
        while (i < result.numInstances()) {
            if (!(this.m_Instances.instance(i) instanceof SparseInstance) && !Utils.eq((double)Math.tan(this.m_Instances.instance(i).value(this.m_AttIndex)), (double)result.instance(i).value(this.m_AttIndex))) {
                equal = false;
                break;
            }
            ++i;
        }
        if (!equal) {
            MathExpressionTest.fail((String)"Filter produces different result)!");
        }
    }

    public void testRint() {
        this.m_Filter = this.getFilter("rint(A)");
        Instances result = this.useFilter();
        MathExpressionTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        MathExpressionTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        boolean equal = true;
        int i = 0;
        while (i < result.numInstances()) {
            if (!(this.m_Instances.instance(i) instanceof SparseInstance) && !Utils.eq((double)Math.rint(this.m_Instances.instance(i).value(this.m_AttIndex)), (double)result.instance(i).value(this.m_AttIndex))) {
                equal = false;
                break;
            }
            ++i;
        }
        if (!equal) {
            MathExpressionTest.fail((String)"Filter produces different result)!");
        }
    }

    public void testFloor() {
        this.m_Filter = this.getFilter("floor(A)");
        Instances result = this.useFilter();
        MathExpressionTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        MathExpressionTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        boolean equal = true;
        int i = 0;
        while (i < result.numInstances()) {
            if (!(this.m_Instances.instance(i) instanceof SparseInstance) && !Utils.eq((double)Math.floor(this.m_Instances.instance(i).value(this.m_AttIndex)), (double)result.instance(i).value(this.m_AttIndex))) {
                equal = false;
                break;
            }
            ++i;
        }
        if (!equal) {
            MathExpressionTest.fail((String)"Filter produces different result)!");
        }
    }

    public void testPow2() {
        this.m_Filter = this.getFilter("pow(A,2)");
        Instances result = this.useFilter();
        MathExpressionTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        MathExpressionTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        boolean equal = true;
        int i = 0;
        while (i < result.numInstances()) {
            if (!(this.m_Instances.instance(i) instanceof SparseInstance) && !Utils.eq((double)Math.pow(this.m_Instances.instance(i).value(this.m_AttIndex), 2.0), (double)result.instance(i).value(this.m_AttIndex))) {
                equal = false;
                break;
            }
            ++i;
        }
        if (!equal) {
            MathExpressionTest.fail((String)"Filter produces different result)!");
        }
    }

    public void testCeil() {
        this.m_Filter = this.getFilter("ceil(A)");
        Instances result = this.useFilter();
        MathExpressionTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        MathExpressionTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        boolean equal = true;
        int i = 0;
        while (i < result.numInstances()) {
            if (!(this.m_Instances.instance(i) instanceof SparseInstance) && !Utils.eq((double)Math.ceil(this.m_Instances.instance(i).value(this.m_AttIndex)), (double)result.instance(i).value(this.m_AttIndex))) {
                equal = false;
                break;
            }
            ++i;
        }
        if (!equal) {
            MathExpressionTest.fail((String)"Filter produces different result)!");
        }
    }

    public static Test suite() {
        return new TestSuite(MathExpressionTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)MathExpressionTest.suite());
    }
}

