/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.RenameAttribute;

public class RenameAttributeTest
extends AbstractFilterTest {
    public RenameAttributeTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        return new RenameAttribute();
    }

    public Filter getFilter(String find, String replace, boolean all, String range, boolean invert) {
        RenameAttribute result = new RenameAttribute();
        result.setFind(find);
        result.setReplace(replace);
        result.setReplaceAll(all);
        result.setAttributeIndices(range);
        result.setInvertSelection(invert);
        return result;
    }

    protected Instances performTest() {
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            RenameAttributeTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex.getMessage()));
        }
        try {
            result = Filter.useFilter((Instances)icopy, (Filter)this.m_Filter);
            RenameAttributeTest.assertNotNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            RenameAttributeTest.fail((String)("Exception thrown on useFilter(): \n" + ex.getMessage()));
        }
        RenameAttributeTest.assertEquals((int)icopy.numAttributes(), (int)result.numAttributes());
        RenameAttributeTest.assertEquals((int)icopy.numInstances(), (int)this.m_Instances.numInstances());
        return result;
    }

    public static Test suite() {
        return new TestSuite(RenameAttributeTest.class);
    }

    public void testReplaceFirst() {
        this.m_Filter = this.getFilter("t", "_", false, "first-last", false);
        Instances result = this.performTest();
        RenameAttributeTest.assertEquals((String)"S_ringAtt1", (String)result.attribute(0).name());
    }

    public void testReplaceAll() {
        this.m_Filter = this.getFilter("t", "_", true, "first-last", false);
        Instances result = this.performTest();
        RenameAttributeTest.assertEquals((String)"S_ringA__1", (String)result.attribute(0).name());
    }

    public void testInvertRange() {
        this.m_Filter = this.getFilter("t", "_", true, "first", true);
        Instances result = this.performTest();
        RenameAttributeTest.assertTrue((String)"The first attribute contains '_'!", (result.attribute(0).name().indexOf("_") == -1 ? 1 : 0) != 0);
    }

    public void testGroup() {
        this.m_Filter = this.getFilter("(.+)(Att)(.+)", "$1$3", true, "first-last", false);
        Instances result = this.performTest();
        int i = 0;
        while (i < result.numAttributes()) {
            RenameAttributeTest.assertTrue((String)(String.valueOf(result.attribute(i).name()) + " still contains 'Att'"), (result.attribute(i).name().indexOf("Att") == -1 ? 1 : 0) != 0);
            ++i;
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RenameAttributeTest.suite());
    }
}

