/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Reorder;

public class ReorderTest
extends AbstractFilterTest {
    public ReorderTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        return this.getFilter("first-last");
    }

    public Filter getFilter(String rangelist) {
        try {
            Reorder af = new Reorder();
            af.setAttributeIndices(rangelist);
            return af;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ReorderTest.fail((String)("Exception setting attribute range: " + rangelist + "\n" + ex.getMessage()));
            return null;
        }
    }

    public void testTypical() {
        this.m_Filter = this.getFilter("2,1");
        Instances result = this.useFilter();
        int origNum = this.m_Instances.numAttributes();
        ReorderTest.assertEquals((int)2, (int)result.numAttributes());
        ReorderTest.assertTrue((boolean)result.attribute(1).name().endsWith(this.m_Instances.attribute(0).name()));
        ReorderTest.assertTrue((boolean)result.attribute(0).name().endsWith(this.m_Instances.attribute(1).name()));
    }

    public void testTypical2() {
        this.m_Filter = this.getFilter("3-4");
        Instances result = this.useFilter();
        int origNum = this.m_Instances.numAttributes();
        ReorderTest.assertEquals((int)2, (int)result.numAttributes());
        ReorderTest.assertTrue((boolean)result.attribute(0).name().endsWith(this.m_Instances.attribute(2).name()));
        ReorderTest.assertTrue((boolean)result.attribute(1).name().endsWith(this.m_Instances.attribute(3).name()));
    }

    public void testTypical3() {
        this.m_Filter = this.getFilter("2-last,1");
        Instances result = this.useFilter();
        int origNum = this.m_Instances.numAttributes();
        ReorderTest.assertEquals((int)origNum, (int)result.numAttributes());
        ReorderTest.assertTrue((boolean)result.attribute(0).name().endsWith(this.m_Instances.attribute(1).name()));
        ReorderTest.assertTrue((boolean)result.attribute(1).name().endsWith(this.m_Instances.attribute(2).name()));
        ReorderTest.assertTrue((boolean)result.attribute(origNum - 1).name().endsWith(this.m_Instances.attribute(0).name()));
    }

    public static Test suite() {
        return new TestSuite(ReorderTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ReorderTest.suite());
    }
}

