/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation.statistics;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import weka.classifiers.Evaluation;
import weka.core.OptionHandler;

public abstract class AbstractStatistics
implements Serializable,
OptionHandler {
    private static final long serialVersionUID = 8855183718143422394L;
    protected Hashtable<String, Double> m_Statistics;

    public AbstractStatistics() {
        this.initialize();
    }

    protected void initialize() {
        this.m_Statistics = new Hashtable();
    }

    public abstract String globalInfo();

    @Override
    public Enumeration listOptions() {
        return new Vector().elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
    }

    @Override
    public String[] getOptions() {
        return new String[0];
    }

    protected void check(Evaluation eval) {
        if (eval == null) {
            throw new IllegalArgumentException("No Evaluation object provided!");
        }
    }

    protected abstract void doGenerate(Evaluation var1);

    public void generate(Evaluation eval) {
        this.m_Statistics.clear();
        this.check(eval);
        this.doGenerate(eval);
    }

    public Enumeration<String> names() {
        return this.m_Statistics.keys();
    }

    public double getStatistic(String name) {
        if (this.m_Statistics.containsKey(name)) {
            return this.m_Statistics.get(name);
        }
        throw new IllegalArgumentException("Unknown statistic: " + name);
    }

    public abstract String toSummary();

    public String toString() {
        return this.m_Statistics.toString();
    }
}

