/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Range;

public class RangeTest
extends TestCase {
    public RangeTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected Range getRange(String initial, int upper) {
        Range result;
        if (initial == null) {
            result = new Range();
            result.setRanges("1");
            result.setUpper(upper);
        } else {
            result = new Range(initial);
            result.setUpper(upper);
        }
        return result;
    }

    public void testDefaultConstructor() throws Exception {
        int upper = 10;
        int indexInt = 0;
        String indexStr = "" + (indexInt + 1);
        Range index = new Range();
        index.setRanges(indexStr);
        index.setUpper(upper);
        RangeTest.assertEquals((String)indexStr, (String)index.getRanges());
        RangeTest.assertEquals((int)1, (int)index.getSelection().length);
        RangeTest.assertEquals((int)indexInt, (int)index.getSelection()[0]);
    }

    public void testInitialValueConstructor() throws Exception {
        int upper = 10;
        int indexInt = 0;
        String indexStr = "" + (indexInt + 1);
        Range index = this.getRange("1", upper);
        RangeTest.assertEquals((String)indexStr, (String)index.getRanges());
        RangeTest.assertEquals((int)1, (int)index.getSelection().length);
        RangeTest.assertEquals((int)indexInt, (int)index.getSelection()[0]);
    }

    public void testFirst() throws Exception {
        int upper = 10;
        Range index = this.getRange("first", upper);
        RangeTest.assertEquals((String)"first", (String)index.getRanges());
        RangeTest.assertEquals((int)1, (int)index.getSelection().length);
        RangeTest.assertEquals((int)0, (int)index.getSelection()[0]);
    }

    public void testLast() throws Exception {
        int upper = 10;
        Range index = this.getRange("last", upper);
        RangeTest.assertEquals((String)"last", (String)index.getRanges());
        RangeTest.assertEquals((int)1, (int)index.getSelection().length);
        RangeTest.assertEquals((int)upper, (int)index.getSelection()[0]);
    }

    public void testFirstLast() throws Exception {
        int upper = 10;
        Range index = this.getRange("first-last", upper);
        RangeTest.assertEquals((String)"first-last", (String)index.getRanges());
        RangeTest.assertEquals((int)(upper + 1), (int)index.getSelection().length);
    }

    public void testSimpleRange() throws Exception {
        int upper = 10;
        String range = "1-3";
        Range index = this.getRange(range, upper);
        int[] expected = new int[]{0, 1, 2};
        RangeTest.assertEquals((String)range, (String)index.getRanges());
        RangeTest.assertEquals((int)expected.length, (int)index.getSelection().length);
        for (int i = 0; i < expected.length; ++i) {
            RangeTest.assertEquals((int)expected[i], (int)index.getSelection()[i]);
        }
    }

    public void testMixedRange() throws Exception {
        int upper = 10;
        String range = "1-3,6,8-last";
        Range index = this.getRange(range, upper);
        int[] expected = new int[]{0, 1, 2, 5, 7, 8, 9, 10};
        RangeTest.assertEquals((String)range, (String)index.getRanges());
        RangeTest.assertEquals((int)expected.length, (int)index.getSelection().length);
        for (int i = 0; i < expected.length; ++i) {
            RangeTest.assertEquals((int)expected[i], (int)index.getSelection()[i]);
        }
    }

    public void testUnorderedRange() throws Exception {
        int upper = 10;
        String range = "8-last,1-3,6";
        Range index = this.getRange(range, upper);
        int[] expected = new int[]{7, 8, 9, 10, 0, 1, 2, 5};
        RangeTest.assertEquals((String)range, (String)index.getRanges());
        RangeTest.assertEquals((int)expected.length, (int)index.getSelection().length);
        for (int i = 0; i < expected.length; ++i) {
            RangeTest.assertEquals((int)expected[i], (int)index.getSelection()[i]);
        }
    }

    public static Test suite() {
        return new TestSuite(RangeTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RangeTest.suite());
    }
}

