/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.packageManagement;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.pentaho.packageManagement.DefaultPackage;
import org.pentaho.packageManagement.Dependency;
import org.pentaho.packageManagement.Package;
import org.pentaho.packageManagement.PackageConstraint;
import org.pentaho.packageManagement.PackageManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPackageManager
extends PackageManager {
    static final int BUFF_SIZE = 100000;
    static final byte[] m_buffer = new byte[100000];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected File downloadPackage(URL uRL, PrintStream ... printStreamArray) throws Exception {
        String string = uRL.toString();
        string = string.substring(0, string.lastIndexOf(".zip") + 3);
        string = string.substring(0, string.lastIndexOf(46));
        string = string.substring(string.lastIndexOf(47), string.length());
        File file = File.createTempFile(string, ".zip");
        for (int i = 0; i < printStreamArray.length; ++i) {
            printStreamArray[i].println(uRL.toString());
            printStreamArray[i].println("[DefaultPackageManager] Tmp file: " + file.toString());
        }
        URLConnection uRLConnection = null;
        uRLConnection = this.setProxyAuthentication() ? uRL.openConnection(this.m_httpProxy) : uRL.openConnection();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        int n = 0;
        while (true) {
            int n2;
            byte[] byArray = m_buffer;
            // MONITORENTER : m_buffer
            int n3 = bufferedInputStream.read(m_buffer);
            if (n3 == -1) {
                n2 = 0;
                while (true) {
                    if (n2 >= printStreamArray.length) {
                        // MONITOREXIT : byArray
                        bufferedInputStream.close();
                        bufferedOutputStream.close();
                        return file;
                    }
                    printStreamArray[n2].println("[DefaultPackageManager] downloaded " + n / 1000 + " KB");
                    ++n2;
                }
            }
            bufferedOutputStream.write(m_buffer, 0, n3);
            n += n3;
            for (n2 = 0; n2 < printStreamArray.length; ++n2) {
                printStreamArray[n2].println("%%[DefaultPackageManager] downloaded " + n / 1000 + " KB");
            }
            // MONITOREXIT : byArray
        }
    }

    @Override
    public Package getURLPackageInfo(URL uRL) throws Exception {
        File file = this.downloadPackage(uRL, new PrintStream[0]);
        return this.getPackageArchiveInfo(file);
    }

    @Override
    public Package getRepositoryPackageInfo(String string) throws Exception {
        return this.getRepositoryPackageInfo(string, "Latest");
    }

    @Override
    public List<Object> getRepositoryPackageVersions(String string) throws Exception {
        String string2;
        if (this.getPackageRepositoryURL() == null) {
            throw new Exception("[DefaultPackageManager] No package repository set!!");
        }
        String string3 = this.m_packageRepository.toString() + "/" + string + "/" + "versions.txt";
        URL uRL = new URL(string3);
        URLConnection uRLConnection = null;
        uRLConnection = this.setProxyAuthentication() ? uRL.openConnection(this.m_httpProxy) : uRL.openConnection();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while ((string2 = bufferedReader.readLine()) != null) {
            arrayList.add(string2.trim());
        }
        bufferedReader.close();
        return arrayList;
    }

    @Override
    public Package getRepositoryPackageInfo(String string, Object object) throws Exception {
        if (this.getPackageRepositoryURL() == null) {
            throw new Exception("[DefaultPackageManager] No package repository set!!");
        }
        if (object == null) {
            object = "Latest";
        }
        String string2 = this.m_packageRepository.toString() + "/" + string + "/" + object.toString() + ".props";
        URL uRL = new URL(string2);
        URLConnection uRLConnection = null;
        uRLConnection = this.setProxyAuthentication() ? uRL.openConnection(this.m_httpProxy) : uRL.openConnection();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        Properties properties = new Properties();
        properties.load(bufferedInputStream);
        bufferedInputStream.close();
        return new DefaultPackage(this.m_packageHome, this, properties);
    }

    private Package getPackageArchiveInfo(File file) throws Exception {
        return this.getPackageArchiveInfo(file.getAbsolutePath());
    }

    @Override
    public Package getPackageArchiveInfo(String string) throws Exception {
        ZipFile zipFile = new ZipFile(new File(string));
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!zipEntry.getName().endsWith("Description.props")) continue;
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            Properties properties = new Properties();
            properties.load(new BufferedInputStream(inputStream));
            inputStream.close();
            DefaultPackage defaultPackage = new DefaultPackage(this.m_packageHome, this, properties);
            return defaultPackage;
        }
        throw new Exception("Unable to find Description file in package archive!");
    }

    @Override
    public Package getInstalledPackageInfo(String string) throws Exception {
        File file = new File(this.m_packageHome.getAbsoluteFile() + File.separator + string + File.separator + "Description.props");
        if (!file.exists()) {
            return null;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        Properties properties = new Properties();
        properties.load(fileInputStream);
        fileInputStream.close();
        DefaultPackage defaultPackage = new DefaultPackage(this.m_packageHome, this, properties);
        return defaultPackage;
    }

    protected boolean establishPackageHome() {
        if (this.m_packageHome == null) {
            return false;
        }
        if (!this.m_packageHome.exists() && !this.m_packageHome.mkdir()) {
            System.err.println("Unable to create packages directory (" + this.m_packageHome.getAbsolutePath() + ")");
            return false;
        }
        return true;
    }

    public static void deleteDir(File file, PrintStream ... printStreamArray) throws Exception {
        File[] fileArray = file.listFiles();
        if (fileArray.length != 0) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    DefaultPackageManager.deleteDir(file2, new PrintStream[0]);
                    continue;
                }
                for (int i = 0; i < printStreamArray.length; ++i) {
                    printStreamArray[i].println("[DefaultPackageManager] removing: " + file2.toString());
                }
                if (file2.delete()) continue;
                System.err.println("[DefaultPackageManager] can't delete file " + file2.toString());
                file2.deleteOnExit();
            }
        }
        if (!file.delete()) {
            System.err.println("[DefaultPackageManager] can't delete directory " + file.toString());
            file.deleteOnExit();
        }
        for (int i = 0; i < printStreamArray.length; ++i) {
            printStreamArray[i].println("[DefaultPackageManager] removing: " + file.toString());
        }
    }

    @Override
    public void uninstallPackage(String string, PrintStream ... printStreamArray) throws Exception {
        File file = new File(this.m_packageHome.toString() + File.separator + string);
        if (!file.exists()) {
            throw new Exception("[DefaultPackageManager] Can't remove " + string + " because it doesn't seem to be installed!");
        }
        DefaultPackageManager.deleteDir(file, printStreamArray);
    }

    @Override
    public String installPackageFromArchive(String string, PrintStream ... printStreamArray) throws Exception {
        Properties properties = (Properties)this.getPackageArchiveInfo(string).getPackageMetaData();
        String string2 = properties.getProperty("PackageName");
        if (string2 == null) {
            throw new Exception("Unable to find the name of the package in the Description file for " + string);
        }
        this.installPackage(string, string2, printStreamArray);
        return string2;
    }

    @Override
    public void installPackages(List<Package> list, PrintStream ... printStreamArray) throws Exception {
        int n;
        File[] fileArray = new File[list.size()];
        for (n = 0; n < list.size(); ++n) {
            Package package_ = list.get(n);
            fileArray[n] = this.downloadPackage(package_.getPackageURL(), printStreamArray);
        }
        for (n = 0; n < fileArray.length; ++n) {
            this.installPackageFromArchive(fileArray[n].getAbsolutePath(), printStreamArray);
        }
    }

    protected static boolean checkDependencies(PackageConstraint packageConstraint, Map<String, Dependency> map, Map<String, List<Dependency>> map2) throws Exception {
        boolean bl = true;
        List<Dependency> list = packageConstraint.getPackage().getDependencies();
        for (Dependency dependency : list) {
            String string = dependency.getTarget().getPackage().getPackageMetaDataElement("PackageName").toString();
            if (!map.containsKey(string)) {
                map.put(string, dependency);
                bl = DefaultPackageManager.checkDependencies(dependency.getTarget(), map, map2);
                continue;
            }
            Dependency dependency2 = map.get(string);
            PackageConstraint packageConstraint2 = dependency2.getTarget().checkConstraint(dependency.getTarget());
            if (packageConstraint2 != null) {
                dependency2.setTarget(packageConstraint2);
                map.put(string, dependency2);
                continue;
            }
            List<Dependency> list2 = map2.get(string);
            list2.add(dependency);
            bl = false;
        }
        return bl;
    }

    @Override
    public List<Dependency> getAllDependenciesForPackage(Package package_, Map<String, List<Dependency>> map) throws Exception {
        List<Dependency> list2 = package_.getDependencies();
        HashMap<String, Dependency> hashMap = new HashMap<String, Dependency>();
        for (Dependency object22 : list2) {
            hashMap.put(object22.getTarget().getPackage().getPackageMetaDataElement("PackageName").toString(), object22);
            ArrayList<Dependency> arrayList = new ArrayList<Dependency>();
            arrayList.add(object22);
            map.put(object22.getTarget().getPackage().getPackageMetaDataElement("PackageName").toString(), (List<Dependency>)arrayList);
        }
        for (Dependency dependency : list2) {
            DefaultPackageManager.checkDependencies(dependency.getTarget(), hashMap, map);
        }
        ArrayList arrayList = new ArrayList(hashMap.values());
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string : map.keySet()) {
            List<Dependency> list = map.get(string);
            if (list.size() != 1) continue;
            arrayList2.add(string);
        }
        for (List<Dependency> list : arrayList2) {
            map.remove(list);
        }
        return arrayList;
    }

    @Override
    public void installPackageFromRepository(String string, Object object, PrintStream ... printStreamArray) throws Exception {
        Package package_ = this.getRepositoryPackageInfo(string, object);
        String string2 = package_.getPackageMetaDataElement("PackageURL").toString();
        URL uRL = new URL(string2);
        this.installPackageFromURL(uRL, printStreamArray);
    }

    @Override
    public String installPackageFromURL(URL uRL, PrintStream ... printStreamArray) throws Exception {
        File file = this.downloadPackage(uRL, printStreamArray);
        return this.installPackageFromArchive(file.getAbsolutePath(), printStreamArray);
    }

    private static void copyStreams(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray, 0, 1024)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    protected void installPackage(String string, String string2, PrintStream ... printStreamArray) throws Exception {
        if (!this.establishPackageHome()) {
            throw new Exception("Unable to install " + string + " because package home (" + this.m_packageHome.getAbsolutePath() + ") can't be established.");
        }
        File file = new File(this.m_packageHome, string2);
        if (!file.mkdir()) {
            // empty if block
        }
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        ZipFile zipFile = new ZipFile(string);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory()) {
                new File(file, zipEntry.getName()).mkdir();
                continue;
            }
            for (int i = 0; i < printStreamArray.length; ++i) {
                printStreamArray[i].println("[DefaultPackageManager] Installing: " + zipEntry.getName());
            }
            bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            File file2 = new File(file, zipEntry.getName());
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            DefaultPackageManager.copyStreams(bufferedInputStream, bufferedOutputStream);
            ((InputStream)bufferedInputStream).close();
            ((OutputStream)bufferedOutputStream).flush();
            ((OutputStream)bufferedOutputStream).close();
        }
    }

    private URLConnection getConnection(String string) throws IOException {
        URL uRL = new URL(string);
        URLConnection uRLConnection = null;
        uRLConnection = this.setProxyAuthentication() ? uRL.openConnection(this.m_httpProxy) : uRL.openConnection();
        uRLConnection.setConnectTimeout(60000);
        return uRLConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void transToBAOS(BufferedInputStream bufferedInputStream, ByteArrayOutputStream byteArrayOutputStream) throws Exception {
        while (true) {
            byte[] byArray = m_buffer;
            // MONITORENTER : m_buffer
            int n = bufferedInputStream.read(m_buffer);
            if (n == -1) {
                // MONITOREXIT : byArray
                bufferedInputStream.close();
                return;
            }
            byteArrayOutputStream.write(m_buffer, 0, n);
            // MONITOREXIT : byArray
        }
    }

    private void writeZipEntryForPackage(String string, ZipOutputStream zipOutputStream) throws Exception {
        ZipEntry zipEntry = new ZipEntry(string + "/");
        zipOutputStream.putNextEntry(zipEntry);
        ZipEntry zipEntry2 = new ZipEntry(string + "/Latest.props");
        ZipEntry zipEntry3 = new ZipEntry(string + "/Latest.html");
        URLConnection uRLConnection = this.getConnection(this.m_packageRepository.toString() + "/" + string + "/Latest.props");
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.transToBAOS(bufferedInputStream, byteArrayOutputStream);
        zipOutputStream.putNextEntry(zipEntry2);
        zipOutputStream.write(byteArrayOutputStream.toByteArray());
        uRLConnection = this.getConnection(this.m_packageRepository.toString() + "/" + string + "/Latest.html");
        bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        byteArrayOutputStream = new ByteArrayOutputStream();
        this.transToBAOS(bufferedInputStream, byteArrayOutputStream);
        zipOutputStream.putNextEntry(zipEntry3);
        zipOutputStream.write(byteArrayOutputStream.toByteArray());
        zipEntry2 = new ZipEntry(string + "/versions.txt");
        uRLConnection = this.getConnection(this.m_packageRepository.toString() + "/" + string + "/versions.txt");
        bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        byteArrayOutputStream = new ByteArrayOutputStream();
        this.transToBAOS(bufferedInputStream, byteArrayOutputStream);
        zipOutputStream.putNextEntry(zipEntry2);
        zipOutputStream.write(byteArrayOutputStream.toByteArray());
        zipEntry2 = new ZipEntry(string + "/index.html");
        uRLConnection = this.getConnection(this.m_packageRepository.toString() + "/" + string + "/index.html");
        bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        byteArrayOutputStream = new ByteArrayOutputStream();
        this.transToBAOS(bufferedInputStream, byteArrayOutputStream);
        zipOutputStream.putNextEntry(zipEntry2);
        zipOutputStream.write(byteArrayOutputStream.toByteArray());
        List<Object> list = this.getRepositoryPackageVersions(string);
        for (Object object : list) {
            uRLConnection = this.getConnection(this.m_packageRepository.toString() + "/" + string + "/" + object.toString() + ".props");
            zipEntry2 = new ZipEntry(string + "/" + object.toString() + ".props");
            bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
            byteArrayOutputStream = new ByteArrayOutputStream();
            this.transToBAOS(bufferedInputStream, byteArrayOutputStream);
            zipOutputStream.putNextEntry(zipEntry2);
            zipOutputStream.write(byteArrayOutputStream.toByteArray());
            uRLConnection = this.getConnection(this.m_packageRepository.toString() + "/" + string + "/" + object.toString() + ".html");
            zipEntry2 = new ZipEntry(string + "/" + object.toString() + ".html");
            bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
            byteArrayOutputStream = new ByteArrayOutputStream();
            this.transToBAOS(bufferedInputStream, byteArrayOutputStream);
            zipOutputStream.putNextEntry(zipEntry2);
            zipOutputStream.write(byteArrayOutputStream.toByteArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public byte[] getRepositoryPackageMetaDataOnlyAsZip(PrintStream ... printStreamArray) throws Exception {
        if (this.getPackageRepositoryURL() == null) {
            throw new Exception("[DefaultPackageManager] No package repository set!!");
        }
        try {
            String string = this.m_packageRepository.toString() + "/repo.zip";
            URLConnection uRLConnection = null;
            uRLConnection = this.getConnection(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 0;
            while (true) {
                int n2;
                byte[] byArray = m_buffer;
                // MONITORENTER : m_buffer
                int n3 = bufferedInputStream.read(m_buffer);
                if (n3 == -1) {
                    n2 = 0;
                    while (true) {
                        if (n2 >= printStreamArray.length) {
                            // MONITOREXIT : byArray
                            bufferedInputStream.close();
                            return byteArrayOutputStream.toByteArray();
                        }
                        printStreamArray[n2].println("[DefaultPackageManager] downloaded " + n / 1000 + " KB");
                        ++n2;
                    }
                }
                byteArrayOutputStream.write(m_buffer, 0, n3);
                n += n3;
                for (n2 = 0; n2 < printStreamArray.length; ++n2) {
                    printStreamArray[n2].println("[DefaultPackageManager] downloaded " + n / 1000 + " KB");
                }
                // MONITOREXIT : byArray
            }
        }
        catch (Exception exception) {
            System.err.println("Unable to download repository zip archve (" + exception.getMessage() + ") - trying legacy routine...");
            return this.getRepositoryPackageMetaDataOnlyAsZipLegacy(printStreamArray);
        }
    }

    public byte[] getRepositoryPackageMetaDataOnlyAsZipLegacy(PrintStream ... printStreamArray) throws Exception {
        String string;
        String string2;
        if (this.getPackageRepositoryURL() == null) {
            throw new Exception("[DefaultPackageManager] No package repository set!!");
        }
        String string3 = this.m_packageRepository.toString() + "/packageList.txt";
        String string4 = this.m_packageRepository.toString() + "/packageListWithVersion.txt";
        URLConnection uRLConnection = null;
        uRLConnection = this.getConnection(string3);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
        while ((string2 = bufferedReader.readLine()) != null) {
            for (PrintStream printStream : printStreamArray) {
                printStream.println("Fetching meta data for " + string2);
            }
            this.writeZipEntryForPackage(string2, zipOutputStream);
        }
        bufferedReader.close();
        uRLConnection = this.getConnection(string3);
        ZipEntry zipEntry = new ZipEntry("packageList.txt");
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        this.transToBAOS(bufferedInputStream, byteArrayOutputStream2);
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.write(byteArrayOutputStream2.toByteArray());
        bufferedInputStream.close();
        uRLConnection = this.getConnection(string4);
        ZipEntry zipEntry2 = new ZipEntry("packageListWithVersion.txt");
        bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        byteArrayOutputStream2 = new ByteArrayOutputStream();
        this.transToBAOS(bufferedInputStream, byteArrayOutputStream2);
        zipOutputStream.putNextEntry(zipEntry2);
        zipOutputStream.write(byteArrayOutputStream2.toByteArray());
        bufferedInputStream.close();
        String string5 = this.m_packageRepository.toString() + "/images.txt";
        uRLConnection = this.getConnection(string5);
        bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        while ((string = bufferedReader.readLine()) != null) {
            ZipEntry zipEntry3 = new ZipEntry(string);
            URLConnection uRLConnection2 = this.getConnection(this.m_packageRepository.toString() + "/" + string);
            bufferedInputStream = new BufferedInputStream(uRLConnection2.getInputStream());
            byteArrayOutputStream2 = new ByteArrayOutputStream();
            this.transToBAOS(bufferedInputStream, byteArrayOutputStream2);
            zipOutputStream.putNextEntry(zipEntry3);
            zipOutputStream.write(byteArrayOutputStream2.toByteArray());
            bufferedInputStream.close();
        }
        uRLConnection = this.getConnection(string5);
        ZipEntry zipEntry4 = new ZipEntry("images.txt");
        bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        byteArrayOutputStream2 = new ByteArrayOutputStream();
        this.transToBAOS(bufferedInputStream, byteArrayOutputStream2);
        zipOutputStream.putNextEntry(zipEntry4);
        zipOutputStream.write(byteArrayOutputStream2.toByteArray());
        bufferedInputStream.close();
        zipOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public List<Package> getAllPackages(PrintStream ... printStreamArray) throws Exception {
        String string;
        ArrayList<Package> arrayList = new ArrayList<Package>();
        if (this.getPackageRepositoryURL() == null) {
            throw new Exception("[DefaultPackageManager] No package repository set!!");
        }
        String string2 = this.m_packageRepository.toString() + "/packageList.txt";
        URL uRL = new URL(string2);
        URLConnection uRLConnection = null;
        uRLConnection = this.setProxyAuthentication() ? uRL.openConnection(this.m_httpProxy) : uRL.openConnection();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        while ((string = bufferedReader.readLine()) != null) {
            Package package_ = this.getRepositoryPackageInfo(string);
            arrayList.add(package_);
        }
        return arrayList;
    }

    @Override
    public List<Package> getAvailablePackages() throws Exception {
        List<Package> list = this.getAllPackages(new PrintStream[0]);
        ArrayList<Package> arrayList = new ArrayList<Package>();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).isInstalled()) continue;
            arrayList.add(list.get(i));
        }
        return arrayList;
    }

    @Override
    public List<Package> getInstalledPackages() throws Exception {
        if (!this.establishPackageHome()) {
            throw new Exception("Unable to get list of installed packages because package home (" + this.m_packageHome.getAbsolutePath() + ") can't be established.");
        }
        ArrayList<Package> arrayList = new ArrayList<Package>();
        File[] fileArray = this.m_packageHome.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file;
            if (!fileArray[i].isDirectory() || !(file = new File(fileArray[i].getAbsolutePath() + File.separator + "Description.props")).exists()) continue;
            try {
                Properties properties = new Properties();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                properties.load(bufferedInputStream);
                bufferedInputStream.close();
                bufferedInputStream = null;
                DefaultPackage defaultPackage = new DefaultPackage(this.m_packageHome, this, properties);
                arrayList.add(defaultPackage);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return arrayList;
    }

    protected static String padLeft(String string, int n) {
        return DefaultPackageManager.fixStringLength(string, n, false);
    }

    protected static String padRight(String string, int n) {
        return DefaultPackageManager.fixStringLength(string, n, true);
    }

    private static String fixStringLength(String string, int n, boolean bl) {
        if (string.length() < n) {
            while (string.length() < n) {
                string = bl ? string.concat(" ") : " ".concat(string);
            }
        } else if (string.length() > n) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            URL uRL = new URL(stringArray[0]);
            DefaultPackageManager defaultPackageManager = new DefaultPackageManager();
            defaultPackageManager.downloadPackage(uRL, System.out);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

