/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeEvaluator;
import weka.attributeSelection.AttributeTransformer;
import weka.attributeSelection.CfsSubsetEval;
import weka.attributeSelection.GreedyStepwise;
import weka.attributeSelection.InfoGainAttributeEval;
import weka.attributeSelection.Ranker;
import weka.classifiers.meta.AttributeSelectedClassifier;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.filters.supervised.attribute.AttributeSelection;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.LogPanel;
import weka.gui.Logger;
import weka.gui.PropertyPanel;
import weka.gui.ResultHistoryPanel;
import weka.gui.SaveBuffer;
import weka.gui.SysErrLog;
import weka.gui.TaskLogger;
import weka.gui.explorer.Explorer;
import weka.gui.explorer.ExplorerDefaults;
import weka.gui.visualize.MatrixPanel;

public class AttributeSelectionPanel
extends JPanel
implements Explorer.CapabilitiesFilterChangeListener,
Explorer.ExplorerPanel,
Explorer.LogHandler {
    static final long serialVersionUID = 5627185966993476142L;
    protected Explorer m_Explorer = null;
    protected GenericObjectEditor m_AttributeEvaluatorEditor = new GenericObjectEditor();
    protected GenericObjectEditor m_AttributeSearchEditor = new GenericObjectEditor();
    protected PropertyPanel m_AEEPanel = new PropertyPanel(this.m_AttributeEvaluatorEditor);
    protected PropertyPanel m_ASEPanel = new PropertyPanel(this.m_AttributeSearchEditor);
    protected JTextArea m_OutText = new JTextArea(20, 40);
    protected Logger m_Log = new SysErrLog();
    SaveBuffer m_SaveOut = new SaveBuffer(this.m_Log, this);
    protected ResultHistoryPanel m_History = new ResultHistoryPanel(this.m_OutText);
    protected JComboBox m_ClassCombo = new JComboBox();
    protected JRadioButton m_CVBut = new JRadioButton("Cross-validation");
    protected JRadioButton m_TrainBut = new JRadioButton("Use full training set");
    protected JLabel m_CVLab = new JLabel("Folds", 4);
    protected JTextField m_CVText = new JTextField("10");
    protected JLabel m_SeedLab = new JLabel("Seed", 4);
    protected JTextField m_SeedText = new JTextField("1");
    ActionListener m_RadioListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AttributeSelectionPanel.this.updateRadioLinks();
        }
    };
    protected JButton m_StartBut = new JButton("Start");
    protected JButton m_StopBut = new JButton("Stop");
    private Dimension COMBO_SIZE;
    protected Instances m_Instances;
    protected Thread m_RunThread;

    public AttributeSelectionPanel() {
        this.COMBO_SIZE = new Dimension(150, this.m_StartBut.getPreferredSize().height);
        this.m_OutText.setEditable(false);
        this.m_OutText.setFont(new Font("Monospaced", 0, 12));
        this.m_OutText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_OutText.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 16) {
                    AttributeSelectionPanel.this.m_OutText.selectAll();
                }
            }
        });
        this.m_History.setBorder(BorderFactory.createTitledBorder("Result list (right-click for options)"));
        this.m_AttributeEvaluatorEditor.setClassType(ASEvaluation.class);
        this.m_AttributeEvaluatorEditor.setValue(ExplorerDefaults.getASEvaluator());
        this.m_AttributeEvaluatorEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                int result;
                Object backup;
                if (AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getValue() instanceof AttributeEvaluator) {
                    if (!(AttributeSelectionPanel.this.m_AttributeSearchEditor.getValue() instanceof Ranker)) {
                        backup = AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getBackup();
                        result = JOptionPane.showConfirmDialog(null, "You must use use the Ranker search method in order to use\n" + AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getValue().getClass().getName() + ".\nShould I select the Ranker search method for you?", "Alert!", 0);
                        if (result == 0) {
                            AttributeSelectionPanel.this.m_AttributeSearchEditor.setValue(new Ranker());
                        } else if (backup != null) {
                            AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.setValue(backup);
                        }
                    }
                } else if (AttributeSelectionPanel.this.m_AttributeSearchEditor.getValue() instanceof Ranker) {
                    backup = AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getBackup();
                    result = JOptionPane.showConfirmDialog(null, "You must use use a search method that explores \nthe space of attribute subsets (such as GreedyStepwise) in order to use\n" + AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getValue().getClass().getName() + ".\nShould I select the GreedyStepwise search method for " + "you?\n(you can always switch to a different method afterwards)", "Alert!", 0);
                    if (result == 0) {
                        AttributeSelectionPanel.this.m_AttributeSearchEditor.setValue(new GreedyStepwise());
                    } else if (backup != null) {
                        AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.setValue(backup);
                    }
                }
                AttributeSelectionPanel.this.updateRadioLinks();
                AttributeSelectionPanel.this.m_StartBut.setEnabled(true);
                Capabilities currentFilter = AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getCapabilitiesFilter();
                ASEvaluation evaluator = (ASEvaluation)AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getValue();
                Capabilities currentSchemeCapabilities = null;
                if (evaluator != null && currentFilter != null && evaluator instanceof CapabilitiesHandler && !(currentSchemeCapabilities = evaluator.getCapabilities()).supportsMaybe(currentFilter) && !currentSchemeCapabilities.supports(currentFilter)) {
                    AttributeSelectionPanel.this.m_StartBut.setEnabled(false);
                }
                AttributeSelectionPanel.this.repaint();
            }
        });
        this.m_AttributeSearchEditor.setClassType(ASSearch.class);
        this.m_AttributeSearchEditor.setValue(ExplorerDefaults.getASSearch());
        this.m_AttributeSearchEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (AttributeSelectionPanel.this.m_AttributeSearchEditor.getValue() instanceof Ranker) {
                    if (!(AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getValue() instanceof AttributeEvaluator)) {
                        Object backup = AttributeSelectionPanel.this.m_AttributeSearchEditor.getBackup();
                        int result = JOptionPane.showConfirmDialog(null, "You must use use an evaluator that evaluates\nsingle attributes (such as InfoGain) in order to use\nthe Ranker. Should I select the InfoGain evaluator for you?\n(You can always switch to a different method afterwards)", "Alert!", 0);
                        if (result == 0) {
                            AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.setValue(new InfoGainAttributeEval());
                        } else if (backup != null) {
                            AttributeSelectionPanel.this.m_AttributeSearchEditor.setValue(backup);
                        }
                    }
                } else if (AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getValue() instanceof AttributeEvaluator) {
                    Object backup = AttributeSelectionPanel.this.m_AttributeSearchEditor.getBackup();
                    int result = JOptionPane.showConfirmDialog(null, "You must use use an evaluator that evaluates\nsubsets of attributes (such as CFS) in order to use\n" + AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getValue().getClass().getName() + ".\nShould I select the CFS subset evaluator for you?" + "\n(you can always switch to a different method afterwards)", "Alert!", 0);
                    if (result == 0) {
                        AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.setValue(new CfsSubsetEval());
                    } else if (backup != null) {
                        AttributeSelectionPanel.this.m_AttributeSearchEditor.setValue(backup);
                    }
                }
                AttributeSelectionPanel.this.repaint();
            }
        });
        this.m_ClassCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributeSelectionPanel.this.updateCapabilitiesFilter(AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getCapabilitiesFilter());
            }
        });
        this.m_ClassCombo.setToolTipText("Select the attribute to use as the class");
        this.m_TrainBut.setToolTipText("select attributes using the full training dataset");
        this.m_CVBut.setToolTipText("Perform a n-fold cross-validation");
        this.m_StartBut.setToolTipText("Starts attribute selection");
        this.m_StopBut.setToolTipText("Stops a attribute selection task");
        this.m_ClassCombo.setPreferredSize(this.COMBO_SIZE);
        this.m_ClassCombo.setMaximumSize(this.COMBO_SIZE);
        this.m_ClassCombo.setMinimumSize(this.COMBO_SIZE);
        this.m_History.setPreferredSize(this.COMBO_SIZE);
        this.m_History.setMaximumSize(this.COMBO_SIZE);
        this.m_History.setMinimumSize(this.COMBO_SIZE);
        this.m_ClassCombo.setEnabled(false);
        this.m_TrainBut.setSelected(ExplorerDefaults.getASTestMode() == 0);
        this.m_CVBut.setSelected(ExplorerDefaults.getASTestMode() == 1);
        this.updateRadioLinks();
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_TrainBut);
        bg.add(this.m_CVBut);
        this.m_TrainBut.addActionListener(this.m_RadioListener);
        this.m_CVBut.addActionListener(this.m_RadioListener);
        this.m_CVText.setText("" + ExplorerDefaults.getASCrossvalidationFolds());
        this.m_SeedText.setText("" + ExplorerDefaults.getASRandomSeed());
        this.m_StartBut.setEnabled(false);
        this.m_StopBut.setEnabled(false);
        this.m_StartBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributeSelectionPanel.this.startAttributeSelection();
            }
        });
        this.m_StopBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributeSelectionPanel.this.stopAttributeSelection();
            }
        });
        this.m_History.setHandleRightClicks(false);
        this.m_History.getList().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 16 || e.isAltDown()) {
                    int index = AttributeSelectionPanel.this.m_History.getList().locationToIndex(e.getPoint());
                    if (index != -1) {
                        String name = AttributeSelectionPanel.this.m_History.getNameAtIndex(index);
                        AttributeSelectionPanel.this.visualize(name, e.getX(), e.getY());
                    } else {
                        AttributeSelectionPanel.this.visualize(null, e.getX(), e.getY());
                    }
                }
            }
        });
        JPanel p1 = new JPanel();
        p1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Attribute Evaluator"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        p1.setLayout(new BorderLayout());
        p1.add((Component)this.m_AEEPanel, "North");
        JPanel p1_1 = new JPanel();
        p1_1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Search Method"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        p1_1.setLayout(new BorderLayout());
        p1_1.add((Component)this.m_ASEPanel, "North");
        JPanel p_new = new JPanel();
        p_new.setLayout(new BorderLayout());
        p_new.add((Component)p1, "North");
        p_new.add((Component)p1_1, "Center");
        JPanel p2 = new JPanel();
        GridBagLayout gbL = new GridBagLayout();
        p2.setLayout(gbL);
        p2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Attribute Selection Mode"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagConstraints gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.gridy = 2;
        gbC.gridx = 0;
        gbL.setConstraints(this.m_TrainBut, gbC);
        p2.add(this.m_TrainBut);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.gridy = 4;
        gbC.gridx = 0;
        gbL.setConstraints(this.m_CVBut, gbC);
        p2.add(this.m_CVBut);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.fill = 2;
        gbC.gridy = 4;
        gbC.gridx = 1;
        gbC.insets = new Insets(2, 10, 2, 10);
        gbL.setConstraints(this.m_CVLab, gbC);
        p2.add(this.m_CVLab);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.fill = 2;
        gbC.gridy = 4;
        gbC.gridx = 2;
        gbC.weightx = 100.0;
        gbC.ipadx = 20;
        gbL.setConstraints(this.m_CVText, gbC);
        p2.add(this.m_CVText);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.fill = 2;
        gbC.gridy = 6;
        gbC.gridx = 1;
        gbC.insets = new Insets(2, 10, 2, 10);
        gbL.setConstraints(this.m_SeedLab, gbC);
        p2.add(this.m_SeedLab);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.fill = 2;
        gbC.gridy = 6;
        gbC.gridx = 2;
        gbC.weightx = 100.0;
        gbC.ipadx = 20;
        gbL.setConstraints(this.m_SeedText, gbC);
        p2.add(this.m_SeedText);
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(2, 2));
        buttons.add(this.m_ClassCombo);
        this.m_ClassCombo.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel ssButs = new JPanel();
        ssButs.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ssButs.setLayout(new GridLayout(1, 2, 5, 5));
        ssButs.add(this.m_StartBut);
        ssButs.add(this.m_StopBut);
        buttons.add(ssButs);
        JPanel p3 = new JPanel();
        p3.setBorder(BorderFactory.createTitledBorder("Attribute selection output"));
        p3.setLayout(new BorderLayout());
        JScrollPane js = new JScrollPane(this.m_OutText);
        p3.add((Component)js, "Center");
        js.getViewport().addChangeListener(new ChangeListener(){
            private int lastHeight;

            @Override
            public void stateChanged(ChangeEvent e) {
                JViewport vp = (JViewport)e.getSource();
                int h = vp.getViewSize().height;
                if (h != this.lastHeight) {
                    this.lastHeight = h;
                    int x = h - vp.getExtentSize().height;
                    vp.setViewPosition(new Point(0, x));
                }
            }
        });
        JPanel mondo = new JPanel();
        gbL = new GridBagLayout();
        mondo.setLayout(gbL);
        gbC = new GridBagConstraints();
        gbC.fill = 2;
        gbC.gridy = 0;
        gbC.gridx = 0;
        gbC.weightx = 0.0;
        gbL.setConstraints(p2, gbC);
        mondo.add(p2);
        gbC = new GridBagConstraints();
        gbC.anchor = 11;
        gbC.fill = 2;
        gbC.gridy = 1;
        gbC.gridx = 0;
        gbC.weightx = 0.0;
        gbL.setConstraints(buttons, gbC);
        mondo.add(buttons);
        gbC = new GridBagConstraints();
        gbC.fill = 1;
        gbC.gridy = 2;
        gbC.gridx = 0;
        gbC.weightx = 0.0;
        gbC.weighty = 100.0;
        gbL.setConstraints(this.m_History, gbC);
        mondo.add(this.m_History);
        gbC = new GridBagConstraints();
        gbC.fill = 1;
        gbC.gridy = 0;
        gbC.gridx = 1;
        gbC.gridheight = 3;
        gbC.weightx = 100.0;
        gbC.weighty = 100.0;
        gbL.setConstraints(p3, gbC);
        mondo.add(p3);
        this.setLayout(new BorderLayout());
        this.add((Component)p_new, "North");
        this.add((Component)mondo, "Center");
    }

    protected void updateRadioLinks() {
        this.m_CVBut.setEnabled(true);
        this.m_CVText.setEnabled(this.m_CVBut.isSelected());
        this.m_CVLab.setEnabled(this.m_CVBut.isSelected());
        this.m_SeedText.setEnabled(this.m_CVBut.isSelected());
        this.m_SeedLab.setEnabled(this.m_CVBut.isSelected());
        if (this.m_AttributeEvaluatorEditor.getValue() instanceof AttributeTransformer) {
            this.m_CVBut.setSelected(false);
            this.m_CVBut.setEnabled(false);
            this.m_CVText.setEnabled(false);
            this.m_CVLab.setEnabled(false);
            this.m_SeedText.setEnabled(false);
            this.m_SeedLab.setEnabled(false);
            this.m_TrainBut.setSelected(true);
        }
    }

    @Override
    public void setLog(Logger newLog) {
        this.m_Log = newLog;
    }

    @Override
    public void setInstances(Instances inst) {
        this.m_Instances = inst;
        String[] attribNames = new String[this.m_Instances.numAttributes()];
        for (int i = 0; i < attribNames.length; ++i) {
            String type = "(" + Attribute.typeToStringShort(this.m_Instances.attribute(i)) + ") ";
            String attnm = this.m_Instances.attribute(i).name();
            attribNames[i] = type + attnm;
        }
        this.m_StartBut.setEnabled(this.m_RunThread == null);
        this.m_StopBut.setEnabled(this.m_RunThread != null);
        this.m_ClassCombo.setModel(new DefaultComboBoxModel<String>(attribNames));
        if (inst.classIndex() == -1) {
            this.m_ClassCombo.setSelectedIndex(attribNames.length - 1);
        } else {
            this.m_ClassCombo.setSelectedIndex(inst.classIndex());
        }
        this.m_ClassCombo.setEnabled(true);
    }

    protected void startAttributeSelection() {
        if (this.m_RunThread == null) {
            this.m_StartBut.setEnabled(false);
            this.m_StopBut.setEnabled(true);
            this.m_RunThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AttributeSelectionPanel.this.m_Log.statusMessage("Setting up...");
                    Instances inst = new Instances(AttributeSelectionPanel.this.m_Instances);
                    int testMode = 0;
                    int numFolds = 10;
                    int seed = 1;
                    int classIndex = AttributeSelectionPanel.this.m_ClassCombo.getSelectedIndex();
                    ASEvaluation evaluator = (ASEvaluation)AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getValue();
                    ASSearch search = (ASSearch)AttributeSelectionPanel.this.m_AttributeSearchEditor.getValue();
                    StringBuffer outBuff = new StringBuffer();
                    String name = new SimpleDateFormat("HH:mm:ss - ").format(new Date());
                    String sname = search.getClass().getName();
                    name = sname.startsWith("weka.attributeSelection.") ? name + sname.substring("weka.attributeSelection.".length()) : name + sname;
                    String ename = evaluator.getClass().getName();
                    name = ename.startsWith("weka.attributeSelection.") ? name + " + " + ename.substring("weka.attributeSelection.".length()) : name + " + " + ename;
                    Vector<String> list = new Vector<String>();
                    list.add("-s");
                    if (search instanceof OptionHandler) {
                        list.add(sname + " " + Utils.joinOptions(((OptionHandler)((Object)search)).getOptions()));
                    } else {
                        list.add(sname);
                    }
                    if (evaluator instanceof OptionHandler) {
                        String[] opt = ((OptionHandler)((Object)evaluator)).getOptions();
                        for (int i = 0; i < opt.length; ++i) {
                            list.add(opt[i]);
                        }
                    }
                    String cmd = ename + " " + Utils.joinOptions(list.toArray(new String[list.size()]));
                    AttributeSelection filter = new AttributeSelection();
                    filter.setEvaluator((ASEvaluation)AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getValue());
                    filter.setSearch((ASSearch)AttributeSelectionPanel.this.m_AttributeSearchEditor.getValue());
                    String cmdFilter = filter.getClass().getName() + " " + Utils.joinOptions(filter.getOptions());
                    AttributeSelectedClassifier cls = new AttributeSelectedClassifier();
                    cls.setEvaluator((ASEvaluation)AttributeSelectionPanel.this.m_AttributeEvaluatorEditor.getValue());
                    cls.setSearch((ASSearch)AttributeSelectionPanel.this.m_AttributeSearchEditor.getValue());
                    String cmdClassifier = cls.getClass().getName() + " " + Utils.joinOptions(cls.getOptions());
                    weka.attributeSelection.AttributeSelection eval = null;
                    try {
                        String[] o;
                        if (AttributeSelectionPanel.this.m_CVBut.isSelected()) {
                            testMode = 1;
                            numFolds = Integer.parseInt(AttributeSelectionPanel.this.m_CVText.getText());
                            seed = Integer.parseInt(AttributeSelectionPanel.this.m_SeedText.getText());
                            if (numFolds <= 1) {
                                throw new Exception("Number of folds must be greater than 1");
                            }
                        }
                        inst.setClassIndex(classIndex);
                        AttributeSelectionPanel.this.m_Log.logMessage("Started " + ename);
                        AttributeSelectionPanel.this.m_Log.logMessage("Command: " + cmd);
                        AttributeSelectionPanel.this.m_Log.logMessage("Filter command: " + cmdFilter);
                        AttributeSelectionPanel.this.m_Log.logMessage("Meta-classifier command: " + cmdClassifier);
                        if (AttributeSelectionPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)((Object)AttributeSelectionPanel.this.m_Log)).taskStarted();
                        }
                        outBuff.append("=== Run information ===\n\n");
                        outBuff.append("Evaluator:    " + ename);
                        if (evaluator instanceof OptionHandler) {
                            o = ((OptionHandler)((Object)evaluator)).getOptions();
                            outBuff.append(" " + Utils.joinOptions(o));
                        }
                        outBuff.append("\nSearch:       " + sname);
                        if (search instanceof OptionHandler) {
                            o = ((OptionHandler)((Object)search)).getOptions();
                            outBuff.append(" " + Utils.joinOptions(o));
                        }
                        outBuff.append("\n");
                        outBuff.append("Relation:     " + inst.relationName() + '\n');
                        outBuff.append("Instances:    " + inst.numInstances() + '\n');
                        outBuff.append("Attributes:   " + inst.numAttributes() + '\n');
                        if (inst.numAttributes() < 100) {
                            for (int i = 0; i < inst.numAttributes(); ++i) {
                                outBuff.append("              " + inst.attribute(i).name() + '\n');
                            }
                        } else {
                            outBuff.append("              [list of attributes omitted]\n");
                        }
                        outBuff.append("Evaluation mode:    ");
                        switch (testMode) {
                            case 0: {
                                outBuff.append("evaluate on all training data\n");
                                break;
                            }
                            case 1: {
                                outBuff.append("" + numFolds + "-fold cross-validation\n");
                            }
                        }
                        outBuff.append("\n");
                        AttributeSelectionPanel.this.m_History.addResult(name, outBuff);
                        AttributeSelectionPanel.this.m_History.setSingle(name);
                        AttributeSelectionPanel.this.m_Log.statusMessage("Doing feature selection...");
                        AttributeSelectionPanel.this.m_History.updateResult(name);
                        eval = new weka.attributeSelection.AttributeSelection();
                        eval.setEvaluator(evaluator);
                        eval.setSearch(search);
                        eval.setFolds(numFolds);
                        eval.setSeed(seed);
                        if (testMode == 1) {
                            eval.setXval(true);
                        }
                        switch (testMode) {
                            case 0: {
                                AttributeSelectionPanel.this.m_Log.statusMessage("Evaluating on training data...");
                                eval.SelectAttributes(inst);
                                break;
                            }
                            case 1: {
                                AttributeSelectionPanel.this.m_Log.statusMessage("Randomizing instances...");
                                Random random = new Random(seed);
                                inst.randomize(random);
                                if (inst.attribute(classIndex).isNominal()) {
                                    AttributeSelectionPanel.this.m_Log.statusMessage("Stratifying instances...");
                                    inst.stratify(numFolds);
                                }
                                for (int fold = 0; fold < numFolds; ++fold) {
                                    AttributeSelectionPanel.this.m_Log.statusMessage("Creating splits for fold " + (fold + 1) + "...");
                                    Instances train = inst.trainCV(numFolds, fold, random);
                                    AttributeSelectionPanel.this.m_Log.statusMessage("Selecting attributes using all but fold " + (fold + 1) + "...");
                                    eval.selectAttributesCVSplit(train);
                                }
                                break;
                            }
                            default: {
                                throw new Exception("Test mode not implemented");
                            }
                        }
                        if (testMode == 0) {
                            outBuff.append(eval.toResultsString());
                        } else {
                            outBuff.append(eval.CVResultsString());
                        }
                        outBuff.append("\n");
                        AttributeSelectionPanel.this.m_History.updateResult(name);
                        AttributeSelectionPanel.this.m_Log.logMessage("Finished " + ename + " " + sname);
                        AttributeSelectionPanel.this.m_Log.statusMessage("OK");
                    }
                    catch (Exception ex) {
                        AttributeSelectionPanel.this.m_Log.logMessage(ex.getMessage());
                        AttributeSelectionPanel.this.m_Log.statusMessage("See error log");
                    }
                    finally {
                        if (evaluator instanceof AttributeTransformer) {
                            try {
                                Instances transformed = ((AttributeTransformer)((Object)evaluator)).transformedData(inst);
                                transformed.setRelationName("AT: " + transformed.relationName());
                                FastVector<Instances> vv = new FastVector<Instances>();
                                vv.addElement(transformed);
                                AttributeSelectionPanel.this.m_History.addObject(name, vv);
                            }
                            catch (Exception ex) {
                                System.err.println(ex);
                                ex.printStackTrace();
                            }
                        } else if (testMode == 0) {
                            try {
                                Instances reducedInst = eval.reduceDimensionality(inst);
                                FastVector<Instances> vv = new FastVector<Instances>();
                                vv.addElement(reducedInst);
                                AttributeSelectionPanel.this.m_History.addObject(name, vv);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        if (this.isInterrupted()) {
                            AttributeSelectionPanel.this.m_Log.logMessage("Interrupted " + ename + " " + sname);
                            AttributeSelectionPanel.this.m_Log.statusMessage("See error log");
                        }
                        AttributeSelectionPanel.this.m_RunThread = null;
                        AttributeSelectionPanel.this.m_StartBut.setEnabled(true);
                        AttributeSelectionPanel.this.m_StopBut.setEnabled(false);
                        if (AttributeSelectionPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)((Object)AttributeSelectionPanel.this.m_Log)).taskFinished();
                        }
                    }
                }
            };
            this.m_RunThread.setPriority(1);
            this.m_RunThread.start();
        }
    }

    protected void stopAttributeSelection() {
        if (this.m_RunThread != null) {
            this.m_RunThread.interrupt();
            this.m_RunThread.stop();
        }
    }

    protected void saveBuffer(String name) {
        StringBuffer sb = this.m_History.getNamedBuffer(name);
        if (sb != null && this.m_SaveOut.save(sb)) {
            this.m_Log.logMessage("Save succesful.");
        }
    }

    protected void visualizeTransformedData(Instances ti) {
        if (ti != null) {
            MatrixPanel mp = new MatrixPanel();
            mp.setInstances(ti);
            String plotName = ti.relationName();
            final JFrame jf = new JFrame("Weka Attribute Selection Visualize: " + plotName);
            jf.setSize(800, 600);
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)mp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                }
            });
            jf.setVisible(true);
        }
    }

    protected void saveTransformedData(Instances ti) {
        JFileChooser fc = new JFileChooser();
        ExtensionFileFilter filter = new ExtensionFileFilter(".arff", "ARFF data files");
        fc.setFileFilter(filter);
        int retVal = fc.showSaveDialog(this);
        if (retVal == 0) {
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(fc.getSelectedFile()));
                writer.write(ti.toString());
                writer.flush();
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.m_Log.logMessage("Problem saving data: " + e.getMessage());
                JOptionPane.showMessageDialog(this, "Problem saving data:\n" + e.getMessage(), "Error", 0);
            }
        }
    }

    protected void visualize(String name, int x, int y) {
        final String selectedName = name;
        JPopupMenu resultListMenu = new JPopupMenu();
        JMenuItem visMainBuffer = new JMenuItem("View in main window");
        if (selectedName != null) {
            visMainBuffer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributeSelectionPanel.this.m_History.setSingle(selectedName);
                }
            });
        } else {
            visMainBuffer.setEnabled(false);
        }
        resultListMenu.add(visMainBuffer);
        JMenuItem visSepBuffer = new JMenuItem("View in separate window");
        if (selectedName != null) {
            visSepBuffer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributeSelectionPanel.this.m_History.openFrame(selectedName);
                }
            });
        } else {
            visSepBuffer.setEnabled(false);
        }
        resultListMenu.add(visSepBuffer);
        JMenuItem saveOutput = new JMenuItem("Save result buffer");
        if (selectedName != null) {
            saveOutput.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributeSelectionPanel.this.saveBuffer(selectedName);
                }
            });
        } else {
            saveOutput.setEnabled(false);
        }
        resultListMenu.add(saveOutput);
        JMenuItem deleteOutput = new JMenuItem("Delete result buffer");
        if (selectedName != null) {
            deleteOutput.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributeSelectionPanel.this.m_History.removeResult(selectedName);
                }
            });
        } else {
            deleteOutput.setEnabled(false);
        }
        resultListMenu.add(deleteOutput);
        FastVector o = null;
        if (selectedName != null) {
            o = (FastVector)this.m_History.getNamedObject(selectedName);
        }
        Instances tempTransformed = null;
        if (o != null) {
            for (int i = 0; i < o.size(); ++i) {
                Object temp = o.elementAt(i);
                if (!(temp instanceof Instances)) continue;
                tempTransformed = (Instances)temp;
            }
        }
        final Instances ti = tempTransformed;
        JMenuItem visTrans = null;
        if (ti != null) {
            visTrans = ti.relationName().startsWith("AT:") ? new JMenuItem("Visualize transformed data") : new JMenuItem("Visualize reduced data");
            resultListMenu.addSeparator();
        }
        if (ti != null && visTrans != null) {
            visTrans.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributeSelectionPanel.this.visualizeTransformedData(ti);
                }
            });
        }
        if (visTrans != null) {
            resultListMenu.add(visTrans);
        }
        AbstractButton saveTrans = null;
        if (ti != null) {
            saveTrans = ti.relationName().startsWith("AT:") ? new JMenuItem("Save transformed data...") : new JMenuItem("Save reduced data...");
        }
        if (saveTrans != null) {
            saveTrans.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributeSelectionPanel.this.saveTransformedData(ti);
                }
            });
            resultListMenu.add((JMenuItem)saveTrans);
        }
        resultListMenu.show(this.m_History.getList(), x, y);
    }

    protected void updateCapabilitiesFilter(Capabilities filter) {
        Capabilities filterClass;
        if (filter == null) {
            this.m_AttributeEvaluatorEditor.setCapabilitiesFilter(new Capabilities(null));
            this.m_AttributeSearchEditor.setCapabilitiesFilter(new Capabilities(null));
            return;
        }
        Instances tempInst = !ExplorerDefaults.getInitGenericObjectEditorFilter() ? new Instances(this.m_Instances, 0) : new Instances(this.m_Instances);
        tempInst.setClassIndex(this.m_ClassCombo.getSelectedIndex());
        try {
            filterClass = Capabilities.forInstances(tempInst);
        }
        catch (Exception e) {
            filterClass = new Capabilities(null);
        }
        this.m_AttributeEvaluatorEditor.setCapabilitiesFilter(filterClass);
        this.m_AttributeSearchEditor.setCapabilitiesFilter(filterClass);
        this.m_StartBut.setEnabled(true);
        Capabilities currentFilter = this.m_AttributeEvaluatorEditor.getCapabilitiesFilter();
        ASEvaluation evaluator = (ASEvaluation)this.m_AttributeEvaluatorEditor.getValue();
        Capabilities currentSchemeCapabilities = null;
        if (evaluator != null && currentFilter != null && evaluator instanceof CapabilitiesHandler && !(currentSchemeCapabilities = evaluator.getCapabilities()).supportsMaybe(currentFilter) && !currentSchemeCapabilities.supports(currentFilter)) {
            this.m_StartBut.setEnabled(false);
        }
    }

    @Override
    public void capabilitiesFilterChanged(Explorer.CapabilitiesFilterChangeEvent e) {
        if (e.getFilter() == null) {
            this.updateCapabilitiesFilter(null);
        } else {
            this.updateCapabilitiesFilter((Capabilities)e.getFilter().clone());
        }
    }

    @Override
    public void setExplorer(Explorer parent) {
        this.m_Explorer = parent;
    }

    @Override
    public Explorer getExplorer() {
        return this.m_Explorer;
    }

    @Override
    public String getTabTitle() {
        return "Select attributes";
    }

    @Override
    public String getTabTitleToolTip() {
        return "Determine relevance of attributes";
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame("Weka Explorer: Select attributes");
            jf.getContentPane().setLayout(new BorderLayout());
            AttributeSelectionPanel sp = new AttributeSelectionPanel();
            jf.getContentPane().add((Component)sp, "Center");
            LogPanel lp = new LogPanel();
            sp.setLog(lp);
            jf.getContentPane().add((Component)lp, "South");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
            if (args.length == 1) {
                System.err.println("Loading instances from " + args[0]);
                BufferedReader r = new BufferedReader(new FileReader(args[0]));
                Instances i = new Instances(r);
                sp.setInstances(i);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    static {
        GenericObjectEditor.registerEditors();
    }
}

