/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.RankedOutputSearch;
import weka.attributeSelection.StartSetHandler;
import weka.attributeSelection.SubsetEvaluator;
import weka.attributeSelection.UnsupervisedSubsetEvaluator;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class GreedyStepwise
extends ASSearch
implements RankedOutputSearch,
StartSetHandler,
OptionHandler {
    static final long serialVersionUID = -6312951970168325471L;
    protected boolean m_hasClass;
    protected int m_classIndex;
    protected int m_numAttribs;
    protected boolean m_rankingRequested;
    protected boolean m_doRank;
    protected boolean m_doneRanking = false;
    protected double m_threshold = -1.7976931348623157E308;
    protected int m_numToSelect = -1;
    protected int m_calculatedNumToSelect;
    protected double m_bestMerit;
    protected double[][] m_rankedAtts;
    protected int m_rankedSoFar;
    protected BitSet m_best_group;
    protected ASEvaluation m_ASEval;
    protected Instances m_Instances;
    protected Range m_startRange = new Range();
    protected int[] m_starting = null;
    protected boolean m_backward = false;
    protected boolean m_conservativeSelection = false;

    public GreedyStepwise() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "GreedyStepwise :\n\nPerforms a greedy forward or backward search through the space of attribute subsets. May start with no/all attributes or from an arbitrary point in the space. Stops when the addition/deletion of any remaining attributes results in a decrease in evaluation. Can also produce a ranked list of attributes by traversing the space from one side to the other and recording the order that attributes are selected.\n";
    }

    public String searchBackwardsTipText() {
        return "Search backwards rather than forwards.";
    }

    public void setSearchBackwards(boolean back) {
        this.m_backward = back;
        if (this.m_backward) {
            this.setGenerateRanking(false);
        }
    }

    public boolean getSearchBackwards() {
        return this.m_backward;
    }

    public String thresholdTipText() {
        return "Set threshold by which attributes can be discarded. Default value results in no attributes being discarded. Use in conjunction with generateRanking";
    }

    @Override
    public void setThreshold(double threshold) {
        this.m_threshold = threshold;
    }

    @Override
    public double getThreshold() {
        return this.m_threshold;
    }

    public String numToSelectTipText() {
        return "Specify the number of attributes to retain. The default value (-1) indicates that all attributes are to be retained. Use either this option or a threshold to reduce the attribute set.";
    }

    @Override
    public void setNumToSelect(int n) {
        this.m_numToSelect = n;
    }

    @Override
    public int getNumToSelect() {
        return this.m_numToSelect;
    }

    @Override
    public int getCalculatedNumToSelect() {
        if (this.m_numToSelect >= 0) {
            this.m_calculatedNumToSelect = this.m_numToSelect;
        }
        return this.m_calculatedNumToSelect;
    }

    public String generateRankingTipText() {
        return "Set to true if a ranked list is required.";
    }

    @Override
    public void setGenerateRanking(boolean doRank) {
        this.m_rankingRequested = doRank;
    }

    @Override
    public boolean getGenerateRanking() {
        return this.m_rankingRequested;
    }

    public String startSetTipText() {
        return "Set the start point for the search. This is specified as a comma seperated list off attribute indexes starting at 1. It can include ranges. Eg. 1,2,5-9,17.";
    }

    @Override
    public void setStartSet(String startSet) throws Exception {
        this.m_startRange.setRanges(startSet);
    }

    @Override
    public String getStartSet() {
        return this.m_startRange.getRanges();
    }

    public String conservativeForwardSelectionTipText() {
        return "If true (and forward search is selected) then attributes will continue to be added to the best subset as long as merit does not degrade.";
    }

    public void setConservativeForwardSelection(boolean c) {
        this.m_conservativeSelection = c;
    }

    public boolean getConservativeForwardSelection() {
        return this.m_conservativeSelection;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(5);
        newVector.addElement(new Option("\tUse conservative forward search", "-C", 0, "-C"));
        newVector.addElement(new Option("\tUse a backward search instead of a\n\tforward one.", "-B", 0, "-B"));
        newVector.addElement(new Option("\tSpecify a starting set of attributes.\n\tEg. 1,3,5-7.", "P", 1, "-P <start set>"));
        newVector.addElement(new Option("\tProduce a ranked list of attributes.", "R", 0, "-R"));
        newVector.addElement(new Option("\tSpecify a theshold by which attributes\n\tmay be discarded from the ranking.\n\tUse in conjuction with -R", "T", 1, "-T <threshold>"));
        newVector.addElement(new Option("\tSpecify number of attributes to select", "N", 1, "-N <num to select>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        this.setSearchBackwards(Utils.getFlag('B', options));
        this.setConservativeForwardSelection(Utils.getFlag('C', options));
        String optionString = Utils.getOption('P', options);
        if (optionString.length() != 0) {
            this.setStartSet(optionString);
        }
        this.setGenerateRanking(Utils.getFlag('R', options));
        optionString = Utils.getOption('T', options);
        if (optionString.length() != 0) {
            Double temp = Double.valueOf(optionString);
            this.setThreshold(temp);
        }
        if ((optionString = Utils.getOption('N', options)).length() != 0) {
            this.setNumToSelect(Integer.parseInt(optionString));
        }
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[9];
        int current = 0;
        if (this.getSearchBackwards()) {
            options[current++] = "-B";
        }
        if (this.getConservativeForwardSelection()) {
            options[current++] = "-C";
        }
        if (!this.getStartSet().equals("")) {
            options[current++] = "-P";
            options[current++] = this.startSetToString();
        }
        if (this.getGenerateRanking()) {
            options[current++] = "-R";
        }
        options[current++] = "-T";
        options[current++] = "" + this.getThreshold();
        options[current++] = "-N";
        options[current++] = "" + this.getNumToSelect();
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    protected String startSetToString() {
        StringBuffer FString = new StringBuffer();
        if (this.m_starting == null) {
            return this.getStartSet();
        }
        int i = 0;
        while (i < this.m_starting.length) {
            boolean didPrint = false;
            if (!this.m_hasClass || this.m_hasClass && i != this.m_classIndex) {
                FString.append(this.m_starting[i] + 1);
                didPrint = true;
            }
            if (i == this.m_starting.length - 1) {
                FString.append("");
            } else if (didPrint) {
                FString.append(",");
            }
            ++i;
        }
        return FString.toString();
    }

    public String toString() {
        StringBuffer FString = new StringBuffer();
        FString.append("\tGreedy Stepwise (" + (this.m_backward ? "backwards)" : "forwards)") + ".\n\tStart set: ");
        if (this.m_starting == null) {
            if (this.m_backward) {
                FString.append("all attributes\n");
            } else {
                FString.append("no attributes\n");
            }
        } else {
            FString.append(String.valueOf(this.startSetToString()) + "\n");
        }
        if (!this.m_doneRanking) {
            FString.append("\tMerit of best subset found: " + Utils.doubleToString(Math.abs(this.m_bestMerit), 8, 3) + "\n");
        }
        if (this.m_threshold != -1.7976931348623157E308 && this.m_doneRanking) {
            FString.append("\tThreshold for discarding attributes: " + Utils.doubleToString(this.m_threshold, 8, 4) + "\n");
        }
        return FString.toString();
    }

    @Override
    public int[] search(ASEvaluation ASEval, Instances data) throws Exception {
        int i;
        double best_merit = -1.7976931348623157E308;
        int temp_index = 0;
        if (data != null) {
            this.resetOptions();
            this.m_Instances = data;
        }
        this.m_ASEval = ASEval;
        this.m_numAttribs = this.m_Instances.numAttributes();
        if (this.m_best_group == null) {
            this.m_best_group = new BitSet(this.m_numAttribs);
        }
        if (!(this.m_ASEval instanceof SubsetEvaluator)) {
            throw new Exception(String.valueOf(this.m_ASEval.getClass().getName()) + " is not a " + "Subset evaluator!");
        }
        this.m_startRange.setUpper(this.m_numAttribs - 1);
        if (!this.getStartSet().equals("")) {
            this.m_starting = this.m_startRange.getSelection();
        }
        if (this.m_ASEval instanceof UnsupervisedSubsetEvaluator) {
            this.m_hasClass = false;
            this.m_classIndex = -1;
        } else {
            this.m_hasClass = true;
            this.m_classIndex = this.m_Instances.classIndex();
        }
        SubsetEvaluator ASEvaluator = (SubsetEvaluator)((Object)this.m_ASEval);
        if (this.m_rankedAtts == null) {
            this.m_rankedAtts = new double[this.m_numAttribs][2];
            this.m_rankedSoFar = 0;
        }
        if (this.m_starting != null && this.m_rankedSoFar <= 0) {
            i = 0;
            while (i < this.m_starting.length) {
                if (this.m_starting[i] != this.m_classIndex) {
                    this.m_best_group.set(this.m_starting[i]);
                }
                ++i;
            }
        } else if (this.m_backward && this.m_rankedSoFar <= 0) {
            i = 0;
            while (i < this.m_numAttribs) {
                if (i != this.m_classIndex) {
                    this.m_best_group.set(i);
                }
                ++i;
            }
        }
        best_merit = ASEvaluator.evaluateSubset(this.m_best_group);
        boolean done = false;
        boolean addone = false;
        while (!done) {
            BitSet temp_group = (BitSet)this.m_best_group.clone();
            double temp_best = best_merit;
            if (this.m_doRank) {
                temp_best = -1.7976931348623157E308;
            }
            done = true;
            addone = false;
            i = 0;
            while (i < this.m_numAttribs) {
                boolean z;
                if (this.m_backward) {
                    z = i != this.m_classIndex && temp_group.get(i);
                } else {
                    boolean bl = z = i != this.m_classIndex && !temp_group.get(i);
                }
                if (z) {
                    if (this.m_backward) {
                        temp_group.clear(i);
                    } else {
                        temp_group.set(i);
                    }
                    double temp_merit = ASEvaluator.evaluateSubset(temp_group);
                    if (this.m_backward) {
                        z = temp_merit >= temp_best;
                    } else if (this.m_conservativeSelection) {
                        z = temp_merit >= temp_best;
                    } else {
                        boolean bl = z = temp_merit > temp_best;
                    }
                    if (z) {
                        temp_best = temp_merit;
                        temp_index = i;
                        addone = true;
                        done = false;
                    }
                    if (this.m_backward) {
                        temp_group.set(i);
                    } else {
                        temp_group.clear(i);
                    }
                    if (this.m_doRank) {
                        done = false;
                    }
                }
                ++i;
            }
            if (!addone) continue;
            if (this.m_backward) {
                this.m_best_group.clear(temp_index);
            } else {
                this.m_best_group.set(temp_index);
            }
            best_merit = temp_best;
            this.m_rankedAtts[this.m_rankedSoFar][0] = temp_index;
            this.m_rankedAtts[this.m_rankedSoFar][1] = best_merit;
            ++this.m_rankedSoFar;
        }
        this.m_bestMerit = best_merit;
        return this.attributeList(this.m_best_group);
    }

    @Override
    public double[][] rankedAttributes() throws Exception {
        if (this.m_rankedAtts == null || this.m_rankedSoFar == -1) {
            throw new Exception("Search must be performed before attributes can be ranked.");
        }
        this.m_doRank = true;
        this.search(this.m_ASEval, null);
        double[][] final_rank = new double[this.m_rankedSoFar][2];
        int i = 0;
        while (i < this.m_rankedSoFar) {
            final_rank[i][0] = this.m_rankedAtts[i][0];
            final_rank[i][1] = this.m_rankedAtts[i][1];
            ++i;
        }
        this.resetOptions();
        this.m_doneRanking = true;
        if (this.m_numToSelect > final_rank.length) {
            throw new Exception("More attributes requested than exist in the data");
        }
        if (this.m_numToSelect <= 0) {
            if (this.m_threshold == -1.7976931348623157E308) {
                this.m_calculatedNumToSelect = final_rank.length;
            } else {
                this.determineNumToSelectFromThreshold(final_rank);
            }
        }
        return final_rank;
    }

    private void determineNumToSelectFromThreshold(double[][] ranking) {
        int count = 0;
        int i = 0;
        while (i < ranking.length) {
            if (ranking[i][1] > this.m_threshold) {
                ++count;
            }
            ++i;
        }
        this.m_calculatedNumToSelect = count;
    }

    protected int[] attributeList(BitSet group) {
        int count = 0;
        int i = 0;
        while (i < this.m_numAttribs) {
            if (group.get(i)) {
                ++count;
            }
            ++i;
        }
        int[] list = new int[count];
        count = 0;
        int i2 = 0;
        while (i2 < this.m_numAttribs) {
            if (group.get(i2)) {
                list[count++] = i2;
            }
            ++i2;
        }
        return list;
    }

    protected void resetOptions() {
        this.m_doRank = false;
        this.m_best_group = null;
        this.m_ASEval = null;
        this.m_Instances = null;
        this.m_rankedSoFar = -1;
        this.m_rankedAtts = null;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.10 $");
    }
}

