/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.AttributeTransformer;
import weka.attributeSelection.UnsupervisedAttributeEvaluator;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Matrix;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Center;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.Remove;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;
import weka.filters.unsupervised.attribute.Standardize;

public class PrincipalComponents
extends UnsupervisedAttributeEvaluator
implements AttributeTransformer,
OptionHandler {
    private static final long serialVersionUID = -3675307197777734007L;
    private Instances m_trainInstances;
    private Instances m_trainHeader;
    private Instances m_transformedFormat;
    private Instances m_originalSpaceFormat;
    private boolean m_hasClass;
    private int m_classIndex;
    private int m_numAttribs;
    private int m_numInstances;
    private double[][] m_correlation;
    private double[] m_means;
    private double[] m_stdDevs;
    private boolean m_center = false;
    private double[][] m_eigenvectors;
    private double[] m_eigenvalues = null;
    private int[] m_sortedEigens;
    private double m_sumOfEigenValues = 0.0;
    private ReplaceMissingValues m_replaceMissingFilter;
    private NominalToBinary m_nominalToBinFilter;
    private Remove m_attributeFilter;
    private Center m_centerFilter;
    private Standardize m_standardizeFilter;
    private int m_outputNumAtts = -1;
    private double m_coverVariance = 0.95;
    private boolean m_transBackToOriginal = false;
    private int m_maxAttrsInName = 5;
    private double[][] m_eTranspose;

    public String globalInfo() {
        return "Performs a principal components analysis and transformation of the data. Use in conjunction with a Ranker search. Dimensionality reduction is accomplished by choosing enough eigenvectors to account for some percentage of the variance in the original data---default 0.95 (95%). Attribute noise can be filtered by transforming to the PC space, eliminating some of the worst eigenvectors, and then transforming back to the original space.";
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(3);
        newVector.addElement(new Option("\tCenter (rather than standardize) the\n\tdata and compute PCA using the covariance (rather\n\t than the correlation) matrix.", "C", 0, "-C"));
        newVector.addElement(new Option("\tRetain enough PC attributes to account \n\tfor this proportion of variance in the original data.\n\t(default = 0.95)", "R", 1, "-R"));
        newVector.addElement(new Option("\tTransform through the PC space and \n\tback to the original space.", "O", 0, "-O"));
        newVector.addElement(new Option("\tMaximum number of attributes to include in \n\ttransformed attribute names. (-1 = include all)", "A", 1, "-A"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        String optionString = Utils.getOption('R', options);
        if (optionString.length() != 0) {
            Double temp = Double.valueOf(optionString);
            this.setVarianceCovered(temp);
        }
        if ((optionString = Utils.getOption('A', options)).length() != 0) {
            this.setMaximumAttributeNames(Integer.parseInt(optionString));
        }
        this.setTransformBackToOriginal(Utils.getFlag('O', options));
        this.setCenterData(Utils.getFlag('C', options));
    }

    private void resetOptions() {
        this.m_coverVariance = 0.95;
        this.m_sumOfEigenValues = 0.0;
        this.m_transBackToOriginal = false;
    }

    public String centerDataTipText() {
        return "Center (rather than standardize) the data. PCA will be computed from the covariance (rather than correlation) matrix";
    }

    public void setCenterData(boolean center) {
        this.m_center = center;
    }

    public boolean getCenterData() {
        return this.m_center;
    }

    public String varianceCoveredTipText() {
        return "Retain enough PC attributes to account for this proportion of variance.";
    }

    public void setVarianceCovered(double vc) {
        this.m_coverVariance = vc;
    }

    public double getVarianceCovered() {
        return this.m_coverVariance;
    }

    public String maximumAttributeNamesTipText() {
        return "The maximum number of attributes to include in transformed attribute names.";
    }

    public void setMaximumAttributeNames(int m) {
        this.m_maxAttrsInName = m;
    }

    public int getMaximumAttributeNames() {
        return this.m_maxAttrsInName;
    }

    public String transformBackToOriginalTipText() {
        return "Transform through the PC space and back to the original space. If only the best n PCs are retained (by setting varianceCovered < 1) then this option will give a dataset in the original space but with less attribute noise.";
    }

    public void setTransformBackToOriginal(boolean b) {
        this.m_transBackToOriginal = b;
    }

    public boolean getTransformBackToOriginal() {
        return this.m_transBackToOriginal;
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[6];
        int current = 0;
        if (this.getCenterData()) {
            options[current++] = "-C";
        }
        options[current++] = "-R";
        options[current++] = "" + this.getVarianceCovered();
        options[current++] = "-A";
        options[current++] = "" + this.getMaximumAttributeNames();
        if (this.getTransformBackToOriginal()) {
            options[current++] = "-O";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public void buildEvaluator(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.buildAttributeConstructor(data);
    }

    private void buildAttributeConstructor(Instances data) throws Exception {
        this.m_eigenvalues = null;
        this.m_outputNumAtts = -1;
        this.m_attributeFilter = null;
        this.m_nominalToBinFilter = null;
        this.m_sumOfEigenValues = 0.0;
        this.m_trainInstances = new Instances(data);
        this.m_trainHeader = new Instances(this.m_trainInstances, 0);
        this.m_replaceMissingFilter = new ReplaceMissingValues();
        this.m_replaceMissingFilter.setInputFormat(this.m_trainInstances);
        this.m_trainInstances = Filter.useFilter(this.m_trainInstances, this.m_replaceMissingFilter);
        this.m_nominalToBinFilter = new NominalToBinary();
        this.m_nominalToBinFilter.setInputFormat(this.m_trainInstances);
        this.m_trainInstances = Filter.useFilter(this.m_trainInstances, this.m_nominalToBinFilter);
        Vector<Integer> deleteCols = new Vector<Integer>();
        int i = 0;
        while (i < this.m_trainInstances.numAttributes()) {
            if (this.m_trainInstances.numDistinctValues(i) <= 1) {
                deleteCols.addElement(new Integer(i));
            }
            ++i;
        }
        if (this.m_trainInstances.classIndex() >= 0) {
            this.m_hasClass = true;
            this.m_classIndex = this.m_trainInstances.classIndex();
            deleteCols.addElement(new Integer(this.m_classIndex));
        }
        if (deleteCols.size() > 0) {
            this.m_attributeFilter = new Remove();
            int[] todelete = new int[deleteCols.size()];
            int i2 = 0;
            while (i2 < deleteCols.size()) {
                todelete[i2] = (Integer)deleteCols.elementAt(i2);
                ++i2;
            }
            this.m_attributeFilter.setAttributeIndicesArray(todelete);
            this.m_attributeFilter.setInvertSelection(false);
            this.m_attributeFilter.setInputFormat(this.m_trainInstances);
            this.m_trainInstances = Filter.useFilter(this.m_trainInstances, this.m_attributeFilter);
        }
        this.getCapabilities().testWithFail(this.m_trainInstances);
        this.m_numInstances = this.m_trainInstances.numInstances();
        this.m_numAttribs = this.m_trainInstances.numAttributes();
        this.fillCovariance();
        double[] d = new double[this.m_numAttribs];
        double[][] v = new double[this.m_numAttribs][this.m_numAttribs];
        Matrix corr = new Matrix(this.m_correlation);
        corr.eigenvalueDecomposition(v, d);
        this.m_eigenvectors = (double[][])v.clone();
        this.m_eigenvalues = (double[])d.clone();
        int i3 = 0;
        while (i3 < this.m_eigenvalues.length) {
            if (this.m_eigenvalues[i3] < 0.0) {
                this.m_eigenvalues[i3] = 0.0;
            }
            ++i3;
        }
        this.m_sortedEigens = Utils.sort(this.m_eigenvalues);
        this.m_sumOfEigenValues = Utils.sum(this.m_eigenvalues);
        this.m_transformedFormat = this.setOutputFormat();
        if (this.m_transBackToOriginal) {
            this.m_originalSpaceFormat = this.setOutputFormatOriginal();
            int numVectors = this.m_transformedFormat.classIndex() < 0 ? this.m_transformedFormat.numAttributes() : this.m_transformedFormat.numAttributes() - 1;
            double[][] orderedVectors = new double[this.m_eigenvectors.length][numVectors + 1];
            int i4 = this.m_numAttribs - 1;
            while (i4 > this.m_numAttribs - numVectors - 1) {
                int j = 0;
                while (j < this.m_numAttribs) {
                    orderedVectors[j][this.m_numAttribs - i4] = this.m_eigenvectors[j][this.m_sortedEigens[i4]];
                    ++j;
                }
                --i4;
            }
            int nr = orderedVectors.length;
            int nc = orderedVectors[0].length;
            this.m_eTranspose = new double[nc][nr];
            int i5 = 0;
            while (i5 < nc) {
                int j = 0;
                while (j < nr) {
                    this.m_eTranspose[i5][j] = orderedVectors[j][i5];
                    ++j;
                }
                ++i5;
            }
        }
    }

    @Override
    public Instances transformedHeader() throws Exception {
        if (this.m_eigenvalues == null) {
            throw new Exception("Principal components hasn't been built yet");
        }
        if (this.m_transBackToOriginal) {
            return this.m_originalSpaceFormat;
        }
        return this.m_transformedFormat;
    }

    @Override
    public Instances transformedData(Instances data) throws Exception {
        if (this.m_eigenvalues == null) {
            throw new Exception("Principal components hasn't been built yet");
        }
        Instances output = null;
        output = this.m_transBackToOriginal ? new Instances(this.m_originalSpaceFormat) : new Instances(this.m_transformedFormat);
        int i = 0;
        while (i < data.numInstances()) {
            Instance converted = this.convertInstance(data.instance(i));
            output.add(converted);
            ++i;
        }
        return output;
    }

    @Override
    public double evaluateAttribute(int att) throws Exception {
        if (this.m_eigenvalues == null) {
            throw new Exception("Principal components hasn't been built yet!");
        }
        if (this.m_transBackToOriginal) {
            return 1.0;
        }
        double cumulative = 0.0;
        int i = this.m_numAttribs - 1;
        while (i >= this.m_numAttribs - att - 1) {
            cumulative += this.m_eigenvalues[this.m_sortedEigens[i]];
            --i;
        }
        return 1.0 - cumulative / this.m_sumOfEigenValues;
    }

    private void fillCovariance() throws Exception {
        this.m_means = new double[this.m_trainInstances.numAttributes()];
        this.m_stdDevs = new double[this.m_trainInstances.numAttributes()];
        int i = 0;
        while (i < this.m_trainInstances.numAttributes()) {
            this.m_means[i] = this.m_trainInstances.meanOrMode(i);
            ++i;
        }
        if (!this.m_center) {
            this.fillCorrelation();
            return;
        }
        double[] att = new double[this.m_trainInstances.numInstances()];
        this.m_centerFilter = new Center();
        this.m_centerFilter.setInputFormat(this.m_trainInstances);
        this.m_trainInstances = Filter.useFilter(this.m_trainInstances, this.m_centerFilter);
        this.m_correlation = new double[this.m_numAttribs][this.m_numAttribs];
        int i2 = 0;
        while (i2 < this.m_numAttribs) {
            int j = 0;
            while (j < this.m_numAttribs) {
                double cov = 0.0;
                int k = 0;
                while (k < this.m_numInstances) {
                    cov = i2 == j ? (cov += this.m_trainInstances.instance(k).value(i2) * this.m_trainInstances.instance(k).value(i2)) : (cov += this.m_trainInstances.instance(k).value(i2) * this.m_trainInstances.instance(k).value(j));
                    ++k;
                }
                this.m_correlation[i2][j] = cov /= (double)(this.m_trainInstances.numInstances() - 1);
                this.m_correlation[j][i2] = cov;
                ++j;
            }
            ++i2;
        }
    }

    private void fillCorrelation() throws Exception {
        this.m_correlation = new double[this.m_numAttribs][this.m_numAttribs];
        double[] att1 = new double[this.m_numInstances];
        double[] att2 = new double[this.m_numInstances];
        int i = 0;
        while (i < this.m_numAttribs) {
            int j = 0;
            while (j < this.m_numAttribs) {
                int k = 0;
                while (k < this.m_numInstances) {
                    att1[k] = this.m_trainInstances.instance(k).value(i);
                    att2[k] = this.m_trainInstances.instance(k).value(j);
                    ++k;
                }
                if (i == j) {
                    this.m_correlation[i][j] = 1.0;
                    this.m_stdDevs[i] = Math.sqrt(Utils.variance(att1));
                } else {
                    double corr;
                    this.m_correlation[i][j] = corr = Utils.correlation(att1, att2, this.m_numInstances);
                    this.m_correlation[j][i] = corr;
                }
                ++j;
            }
            ++i;
        }
        this.m_standardizeFilter = new Standardize();
        this.m_standardizeFilter.setInputFormat(this.m_trainInstances);
        this.m_trainInstances = Filter.useFilter(this.m_trainInstances, this.m_standardizeFilter);
    }

    private String principalComponentsSummary() {
        StringBuffer result = new StringBuffer();
        double cumulative = 0.0;
        Instances output = null;
        int numVectors = 0;
        try {
            output = this.setOutputFormat();
            numVectors = output.classIndex() < 0 ? output.numAttributes() : output.numAttributes() - 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        String corrCov = this.m_center ? "Covariance " : "Correlation ";
        result.append(String.valueOf(corrCov) + "matrix\n" + this.matrixToString(this.m_correlation) + "\n\n");
        result.append("eigenvalue\tproportion\tcumulative\n");
        int i = this.m_numAttribs - 1;
        while (i > this.m_numAttribs - numVectors - 1) {
            result.append(String.valueOf(Utils.doubleToString(this.m_eigenvalues[this.m_sortedEigens[i]], 9, 5)) + "\t" + Utils.doubleToString(this.m_eigenvalues[this.m_sortedEigens[i]] / this.m_sumOfEigenValues, 9, 5) + "\t" + Utils.doubleToString((cumulative += this.m_eigenvalues[this.m_sortedEigens[i]]) / this.m_sumOfEigenValues, 9, 5) + "\t" + output.attribute(this.m_numAttribs - i - 1).name() + "\n");
            --i;
        }
        result.append("\nEigenvectors\n");
        int j = 1;
        while (j <= numVectors) {
            result.append(" V" + j + '\t');
            ++j;
        }
        result.append("\n");
        j = 0;
        while (j < this.m_numAttribs) {
            int i2 = this.m_numAttribs - 1;
            while (i2 > this.m_numAttribs - numVectors - 1) {
                result.append(String.valueOf(Utils.doubleToString(this.m_eigenvectors[j][this.m_sortedEigens[i2]], 7, 4)) + "\t");
                --i2;
            }
            result.append(String.valueOf(this.m_trainInstances.attribute(j).name()) + '\n');
            ++j;
        }
        if (this.m_transBackToOriginal) {
            result.append("\nPC space transformed back to original space.\n(Note: can't evaluate attributes in the original space)\n");
        }
        return result.toString();
    }

    public String toString() {
        if (this.m_eigenvalues == null) {
            return "Principal components hasn't been built yet!";
        }
        return "\tPrincipal Components Attribute Transformer\n\n" + this.principalComponentsSummary();
    }

    private String matrixToString(double[][] matrix) {
        StringBuffer result = new StringBuffer();
        int last = matrix.length - 1;
        int i = 0;
        while (i <= last) {
            int j = 0;
            while (j <= last) {
                result.append(String.valueOf(Utils.doubleToString(matrix[i][j], 6, 2)) + " ");
                if (j == last) {
                    result.append('\n');
                }
                ++j;
            }
            ++i;
        }
        return result.toString();
    }

    private Instance convertInstanceToOriginal(Instance inst) throws Exception {
        double[] newVals = null;
        newVals = this.m_hasClass ? new double[this.m_numAttribs + 1] : new double[this.m_numAttribs];
        if (this.m_hasClass) {
            newVals[this.m_numAttribs] = inst.value(inst.numAttributes() - 1);
        }
        int i = 0;
        while (i < this.m_eTranspose[0].length) {
            double tempval = 0.0;
            int j = 1;
            while (j < this.m_eTranspose.length) {
                tempval += this.m_eTranspose[j][i] * inst.value(j - 1);
                ++j;
            }
            newVals[i] = tempval;
            if (!this.m_center) {
                int n = i;
                newVals[n] = newVals[n] * this.m_stdDevs[i];
            }
            int n = i;
            newVals[n] = newVals[n] + this.m_means[i];
            ++i;
        }
        if (inst instanceof SparseInstance) {
            return new SparseInstance(inst.weight(), newVals);
        }
        return new DenseInstance(inst.weight(), newVals);
    }

    @Override
    public Instance convertInstance(Instance instance) throws Exception {
        if (this.m_eigenvalues == null) {
            throw new Exception("convertInstance: Principal components not built yet");
        }
        double[] newVals = new double[this.m_outputNumAtts];
        Instance tempInst = (Instance)instance.copy();
        if (!instance.dataset().equalHeaders(this.m_trainHeader)) {
            throw new Exception("Can't convert instance: header's don't match: PrincipalComponents\n" + instance.dataset().equalHeadersMsg(this.m_trainHeader));
        }
        this.m_replaceMissingFilter.input(tempInst);
        this.m_replaceMissingFilter.batchFinished();
        tempInst = this.m_replaceMissingFilter.output();
        this.m_nominalToBinFilter.input(tempInst);
        this.m_nominalToBinFilter.batchFinished();
        tempInst = this.m_nominalToBinFilter.output();
        if (this.m_attributeFilter != null) {
            this.m_attributeFilter.input(tempInst);
            this.m_attributeFilter.batchFinished();
            tempInst = this.m_attributeFilter.output();
        }
        if (!this.m_center) {
            this.m_standardizeFilter.input(tempInst);
            this.m_standardizeFilter.batchFinished();
            tempInst = this.m_standardizeFilter.output();
        } else {
            this.m_centerFilter.input(tempInst);
            this.m_centerFilter.batchFinished();
            tempInst = this.m_centerFilter.output();
        }
        if (this.m_hasClass) {
            newVals[this.m_outputNumAtts - 1] = instance.value(instance.classIndex());
        }
        double cumulative = 0.0;
        int i = this.m_numAttribs - 1;
        while (i >= 0) {
            double tempval = 0.0;
            int j = 0;
            while (j < this.m_numAttribs) {
                tempval += this.m_eigenvectors[j][this.m_sortedEigens[i]] * tempInst.value(j);
                ++j;
            }
            newVals[this.m_numAttribs - i - 1] = tempval;
            if ((cumulative += this.m_eigenvalues[this.m_sortedEigens[i]]) / this.m_sumOfEigenValues >= this.m_coverVariance) break;
            --i;
        }
        if (!this.m_transBackToOriginal) {
            if (instance instanceof SparseInstance) {
                return new SparseInstance(instance.weight(), newVals);
            }
            return new DenseInstance(instance.weight(), newVals);
        }
        if (instance instanceof SparseInstance) {
            return this.convertInstanceToOriginal(new SparseInstance(instance.weight(), newVals));
        }
        return this.convertInstanceToOriginal(new DenseInstance(instance.weight(), newVals));
    }

    private Instances setOutputFormatOriginal() throws Exception {
        FastVector<Attribute> attributes = new FastVector<Attribute>();
        int i = 0;
        while (i < this.m_numAttribs) {
            String att = this.m_trainInstances.attribute(i).name();
            attributes.addElement(new Attribute(att));
            ++i;
        }
        if (this.m_hasClass) {
            attributes.addElement((Attribute)this.m_trainHeader.classAttribute().copy());
        }
        Instances outputFormat = new Instances(String.valueOf(this.m_trainHeader.relationName()) + "->PC->original space", attributes, 0);
        if (this.m_hasClass) {
            outputFormat.setClassIndex(outputFormat.numAttributes() - 1);
        }
        return outputFormat;
    }

    private Instances setOutputFormat() throws Exception {
        if (this.m_eigenvalues == null) {
            return null;
        }
        double cumulative = 0.0;
        FastVector<Attribute> attributes = new FastVector<Attribute>();
        int i = this.m_numAttribs - 1;
        while (i >= 0) {
            int j;
            int[] coeff_inds;
            int num_attrs;
            StringBuffer attName = new StringBuffer();
            double[] coeff_mags = new double[this.m_numAttribs];
            int j2 = 0;
            while (j2 < this.m_numAttribs) {
                coeff_mags[j2] = -Math.abs(this.m_eigenvectors[j2][this.m_sortedEigens[i]]);
                ++j2;
            }
            int n = num_attrs = this.m_maxAttrsInName > 0 ? Math.min(this.m_numAttribs, this.m_maxAttrsInName) : this.m_numAttribs;
            if (this.m_numAttribs > 0) {
                coeff_inds = Utils.sort(coeff_mags);
            } else {
                coeff_inds = new int[this.m_numAttribs];
                j = 0;
                while (j < this.m_numAttribs) {
                    coeff_inds[j] = j;
                    ++j;
                }
            }
            j = 0;
            while (j < num_attrs) {
                double coeff_value = this.m_eigenvectors[coeff_inds[j]][this.m_sortedEigens[i]];
                if (j > 0 && coeff_value >= 0.0) {
                    attName.append("+");
                }
                attName.append(String.valueOf(Utils.doubleToString(coeff_value, 5, 3)) + this.m_trainInstances.attribute(coeff_inds[j]).name());
                ++j;
            }
            if (num_attrs < this.m_numAttribs) {
                attName.append("...");
            }
            attributes.addElement(new Attribute(attName.toString()));
            if ((cumulative += this.m_eigenvalues[this.m_sortedEigens[i]]) / this.m_sumOfEigenValues >= this.m_coverVariance) break;
            --i;
        }
        if (this.m_hasClass) {
            attributes.addElement((Attribute)this.m_trainHeader.classAttribute().copy());
        }
        Instances outputFormat = new Instances(String.valueOf(this.m_trainInstances.relationName()) + "_principal components", attributes, 0);
        if (this.m_hasClass) {
            outputFormat.setClassIndex(outputFormat.numAttributes() - 1);
        }
        this.m_outputNumAtts = outputFormat.numAttributes();
        return outputFormat;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 6714 $");
    }

    public static void main(String[] argv) {
        PrincipalComponents.runEvaluator(new PrincipalComponents(), argv);
    }
}

